/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.isp.core.vsdk;

import com.nxp.s32ds.ext.rcp.variables.RcpVariables;
import com.nxp.s32ds.mdt.icf.vsdk.IcfVsdkProperties;
import com.nxp.s32ds.mdt.icf.vsdk.cameras.IcfVsdkMipiCameras;
import com.nxp.s32ds.mdt.icf.vsdk.cameras.IcfVsdkViuCameras;
import com.nxp.s32ds.mdt.ide.core.vsdk.MdtV234SdkHelper;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;

public class IspVsdkHelper
extends MdtV234SdkHelper {
    private Collection<String> mipiCameras;
    private Collection<String> viuCameras;
    private String defaultKernelsRoot;
    private static final IspVsdkHelper INSTANCE = new IspVsdkHelper();

    public static IspVsdkHelper getInstance() {
        return INSTANCE;
    }

    protected void cleanup() {
        this.mipiCameras = Collections.emptyList();
        this.viuCameras = Collections.emptyList();
        this.defaultKernelsRoot = "";
    }

    protected void initializeValues() throws CoreException {
        Path vsdkPropertiesFilePath = this.getVsdkPropertiesFilePath();
        IcfVsdkProperties prop = new IcfVsdkProperties(vsdkPropertiesFilePath.toString());
        this.mipiCameras = new IcfVsdkMipiCameras(this.getVsdkVariable(), prop).getNames();
        this.viuCameras = new IcfVsdkViuCameras(this.getVsdkVariable(), prop).getNames();
        this.defaultKernelsRoot = RcpVariables.INSTANCE.relativize(this.getVsdkVariable(), prop.getKernelsRoot());
    }

    public Collection<String> getExternalMipiCameras() {
        this.init();
        return this.mipiCameras;
    }

    public Collection<String> getExternalViuCameras() {
        this.init();
        return this.viuCameras;
    }

    public String getDefaultKernelsRoot() {
        this.init();
        return this.defaultKernelsRoot;
    }
}

