/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.variables.preferences;

import com.nxp.s32ds.cle.ide.internal.variables.preferences.CleIdePreferencesActivator;
import com.nxp.s32ds.cle.ide.internal.variables.preferences.Messages;
import com.nxp.s32ds.cle.ide.variables.preferences.CategoryDescriptor;
import com.nxp.s32ds.cle.ide.variables.preferences.VariableDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class VariablesRegistry {
    public static VariablesRegistry INSTANCE = new VariablesRegistry();
    private List<CategoryDescriptor> categories = new ArrayList<CategoryDescriptor>();

    private VariablesRegistry() {
    }

    public List<CategoryDescriptor> getCategoryDescriptors() {
        return this.categories;
    }

    public void addCategory(CategoryDescriptor category) {
        Optional<CategoryDescriptor> existing;
        if (category == null) {
            CleIdePreferencesActivator.getInstance().logWarning(Messages.VariablesRegistry_category_is_null);
        }
        if ((existing = this.findCategory(category)).isPresent()) {
            for (VariableDescriptor var : category.getVariables()) {
                existing.get().addVariable(var);
            }
        } else {
            this.categories.add(category);
        }
    }

    private Optional<CategoryDescriptor> findCategory(CategoryDescriptor category) {
        return this.categories.stream().filter(c -> category.getName().equals(c.getName())).findAny();
    }
}

