/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.internal.variables.preferences.ui;

import com.nxp.s32ds.cle.ide.internal.variables.preferences.CleIdePreferencesActivator;
import com.nxp.s32ds.cle.ide.internal.variables.preferences.Messages;
import com.nxp.s32ds.cle.ide.internal.variables.preferences.ui.CleIdeVariableWrapper;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

class CleIdeVariableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String EMPTY_STRING = "";

    CleIdeVariableLabelProvider() {
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof CleIdeVariableWrapper) {
            CleIdeVariableWrapper var = (CleIdeVariableWrapper)element;
            switch (columnIndex) {
                case 0: {
                    return var.getName();
                }
                case 1: {
                    String value = var.getValue();
                    return value == null ? EMPTY_STRING : value;
                }
                case 2: {
                    String description = var.getDescription();
                    return description == null ? EMPTY_STRING : description;
                }
                case 3: {
                    String contr = EMPTY_STRING;
                    if (var.isContributed()) {
                        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                        if (manager == null) {
                            CleIdePreferencesActivator.getInstance().logWarning(Messages.VariablesRegistry_category_is_null);
                            return EMPTY_STRING;
                        }
                        String id = manager.getContributingPluginId((IStringVariable)var.getInternalVariable());
                        if (id != null) {
                            contr = id;
                        }
                    }
                    return contr;
                }
            }
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }
}

