/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.internal.variables.preferences.ui;

import com.nxp.s32ds.cle.ide.internal.variables.preferences.CleIdePreferencesActivator;
import com.nxp.s32ds.cle.ide.internal.variables.preferences.Messages;
import com.nxp.s32ds.cle.ide.internal.variables.preferences.ui.CleIdeVariableWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class CleIdeVariableContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private List<CleIdeVariableWrapper> workingList = new ArrayList<CleIdeVariableWrapper>();
    private Map<String, List<String>> config = Collections.emptyMap();

    public CleIdeVariableContentProvider(Map<String, List<String>> config) {
        this.config = config;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<CleIdeVariableWrapper> list = new ArrayList<CleIdeVariableWrapper>();
        for (CleIdeVariableWrapper w : this.workingList) {
            if (!this.config.keySet().contains(w.getName())) continue;
            list.add(w);
        }
        return list.toArray();
    }

    public void inputChanged(Viewer v, Object oldInp, Object newInp) {
        if (newInp == null || !(newInp instanceof IStringVariableManager)) {
            return;
        }
        this.initVariables();
    }

    public Object[] getChildren(Object parentElement) {
        if (!(parentElement instanceof CleIdeVariableWrapper)) {
            return null;
        }
        CleIdeVariableWrapper var = (CleIdeVariableWrapper)parentElement;
        String name = var.getName();
        for (Map.Entry<String, List<String>> entry : this.config.entrySet()) {
            if (!entry.getKey().equals(name)) continue;
            List<String> values = entry.getValue();
            ArrayList<CleIdeVariableWrapper> tmp = new ArrayList<CleIdeVariableWrapper>();
            for (CleIdeVariableWrapper w : this.workingList) {
                if (!values.contains(w.getName())) continue;
                tmp.add(w);
            }
            return tmp.toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (!(element instanceof CleIdeVariableWrapper)) {
            return null;
        }
        CleIdeVariableWrapper var = (CleIdeVariableWrapper)element;
        String name = var.getName();
        for (Map.Entry<String, List<String>> entry : this.config.entrySet()) {
            List<String> values = entry.getValue();
            if (!values.contains(name)) continue;
            return this.workingList.stream().filter(w -> w.getName().equals(entry.getKey())).findFirst().get();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (!(element instanceof CleIdeVariableWrapper)) {
            return false;
        }
        CleIdeVariableWrapper var = (CleIdeVariableWrapper)element;
        return this.config.containsKey(var.getName());
    }

    public void saveVariables() {
        for (CleIdeVariableWrapper variable : this.workingList) {
            if (variable.isHeader()) continue;
            IValueVariable valueVariable = variable.getInternalVariable();
            valueVariable.setValue(variable.getValue());
            valueVariable.setDescription(variable.getDescription());
        }
    }

    public void initVariables() {
        this.workingList.clear();
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        if (manager == null) {
            CleIdePreferencesActivator.getInstance().logWarning(Messages.CleIdeVariableLabelProvider_variable_manager_is_null);
            return;
        }
        IValueVariable[] iValueVariableArray = manager.getValueVariables();
        int n = iValueVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IValueVariable var = iValueVariableArray[n2];
            List allValues = this.config.values().stream().flatMap(x -> x.stream()).collect(Collectors.toList());
            if (allValues.contains(var.getName())) {
                this.workingList.add(new CleIdeVariableWrapper(var));
            }
            ++n2;
        }
        Set<String> keys = this.config.keySet();
        List list = keys.stream().map(s -> CleIdeVariableWrapper.createHeaderVariable(s)).collect(Collectors.toList());
        this.workingList.addAll(list);
    }
}

