/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.internal.variables.preferences.ui;

import com.nxp.s32ds.cle.ide.internal.variables.preferences.CleIdePreferencesActivator;
import com.nxp.s32ds.cle.ide.internal.variables.preferences.Messages;
import com.nxp.s32ds.cle.ide.internal.variables.preferences.ui.CleIdeMultipleInputDialog;
import com.nxp.s32ds.cle.ide.internal.variables.preferences.ui.CleIdeVariableContentProvider;
import com.nxp.s32ds.cle.ide.internal.variables.preferences.ui.CleIdeVariableLabelProvider;
import com.nxp.s32ds.cle.ide.internal.variables.preferences.ui.CleIdeVariableWrapper;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CleIdeStringVariablePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String[] VARIABLE_TABLES_COLUMN_HEADER = new String[]{Messages.CleIdeStringVariablePreferencePage_variable_header, Messages.CleIdeStringVariablePreferencePage_value_header, Messages.CleIdeStringVariablePreferencePage_description_header, Messages.CleIdeStringVariablePreferencePage_contributed_by};
    private static final ColumnLayoutData[] VARIABLE_TABLE_COLUMN_LAYOUTS = new ColumnLayoutData[]{new ColumnWeightData(30), new ColumnWeightData(25), new ColumnWeightData(25), new ColumnWeightData(20)};
    private TreeViewer treeViewer;
    private Button editButton;
    private CleIdeVariableContentProvider variableContentProvider;

    public CleIdeStringVariablePreferencePage() {
        this.setDescription(Messages.CleIdeStringVariablePreferencePage_page_description);
        this.createContentProvider();
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.variableContentProvider.saveVariables();
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 4;
        composite.setLayout((Layout)gl);
        this.createTree(composite);
        this.createEditButton(composite);
        this.noDefaultAndApplyButton();
        return composite;
    }

    protected void performDefaults() {
        this.variableContentProvider.initVariables();
        this.treeViewer.refresh();
        super.performDefaults();
    }

    private void createContentProvider() {
        CleIdePreferencesActivator activator = CleIdePreferencesActivator.getInstance();
        this.variableContentProvider = new CleIdeVariableContentProvider(activator.getConfig());
    }

    private void createTree(Composite parent) {
        Composite treeComposite = new Composite(parent, 0);
        treeComposite.setLayout((Layout)new FillLayout());
        treeComposite.setFont(parent.getFont());
        this.treeViewer = new TreeViewer(parent);
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        tree.setFont(parent.getFont());
        GridData gridData = new GridData(1808);
        this.treeViewer.getControl().setLayoutData((Object)gridData);
        this.treeViewer.setContentProvider((IContentProvider)this.variableContentProvider);
        this.treeViewer.setColumnProperties(new String[]{Messages.CleIdeStringVariablePreferencePage_variable_header, Messages.CleIdeStringVariablePreferencePage_value_header, Messages.CleIdeStringVariablePreferencePage_description_header, Messages.CleIdeStringVariablePreferencePage_contributed_by});
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!CleIdeStringVariablePreferencePage.this.treeViewer.getSelection().isEmpty()) {
                    CleIdeStringVariablePreferencePage.this.handleEdit();
                }
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CleIdeStringVariablePreferencePage.this.handleSelectionChanged(event);
            }
        });
        int i = 0;
        while (i < VARIABLE_TABLES_COLUMN_HEADER.length) {
            TreeColumn tc = new TreeColumn(tree, 0, i);
            tc.setResizable(CleIdeStringVariablePreferencePage.VARIABLE_TABLE_COLUMN_LAYOUTS[i].resizable);
            tc.setText(VARIABLE_TABLES_COLUMN_HEADER[i]);
            ++i;
        }
        this.initColumns();
        this.treeViewer.setInput((Object)VariablesPlugin.getDefault().getStringVariableManager());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CleIdeVariableLabelProvider());
    }

    private void handleSelectionChanged(SelectionChangedEvent event) {
        IValueVariable valueVar;
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        CleIdeVariableWrapper var = (CleIdeVariableWrapper)sel.getFirstElement();
        if (var != null && (valueVar = var.getInternalVariable()) != null && !valueVar.isReadOnly()) {
            this.editButton.setEnabled(sel.size() == 1);
            return;
        }
        this.editButton.setEnabled(false);
    }

    private void createEditButton(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 1;
        GridData gdata = new GridData(2);
        buttonComposite.setLayout((Layout)gl);
        buttonComposite.setLayoutData((Object)gdata);
        buttonComposite.setFont(parent.getFont());
        this.editButton = this.createButton(parent, Messages.CleIdeStringVariablePreferencePage_page_button_edit_text);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CleIdeStringVariablePreferencePage.this.handleEdit();
            }
        });
        this.editButton.setEnabled(false);
    }

    private Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        GridData gd = new GridData();
        PixelConverter converter = new PixelConverter((Control)button);
        gd.widthHint = converter.convertHorizontalDLUsToPixels(61);
        button.setLayoutData((Object)gd);
        button.setText(text);
        return button;
    }

    private void handleEdit() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        CleIdeVariableWrapper var = (CleIdeVariableWrapper)selection.getFirstElement();
        if (var == null || var.isHeader()) {
            return;
        }
        String title = NLS.bind((String)Messages.CleIdeStringVariablePreferencePage_page_edit, (Object)var.getName());
        CleIdeMultipleInputDialog dlg = new CleIdeMultipleInputDialog(this.getShell(), title);
        dlg.setValue(var.getValue());
        dlg.setDescription(var.getDescription());
        if (dlg.open() == 0) {
            var.setValue(dlg.getValue());
            var.setDescription(dlg.getDescription());
            this.treeViewer.update((Object)var, null);
        }
    }

    private void initColumns() {
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < VARIABLE_TABLE_COLUMN_LAYOUTS.length) {
            layout.addColumnData(VARIABLE_TABLE_COLUMN_LAYOUTS[i]);
            ++i;
        }
        this.treeViewer.getTree().setLayout((Layout)layout);
    }
}

