/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.internal.variables.preferences;

import com.nxp.s32ds.cle.ide.internal.variables.preferences.Messages;
import com.nxp.s32ds.cle.ide.variables.preferences.CategoryDescriptor;
import com.nxp.s32ds.cle.ide.variables.preferences.VariableDescriptor;
import com.nxp.s32ds.cle.ide.variables.preferences.VariablesRegistry;
import com.nxp.s32ds.ext.rcp.runtime.Extensions;
import com.nxp.s32ds.ext.rcp.runtime.RcpBundle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class CleIdePreferencesActivator
extends RcpBundle {
    public static final String PLUGIN_ID = "com.nxp.s32ds.cle.ide.variables.preferences";
    private static final String S32DSVARIABLES_EXT_POINT = "s32dsVariables";
    private static final String CATEGORY_ELEMENT = "category";
    private static final String NAME_ATTRIBUTE = "name";
    private Map<String, List<String>> config = new HashMap<String, List<String>>();
    private VariablesRegistry registry = VariablesRegistry.INSTANCE;
    private static CleIdePreferencesActivator activator;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        activator = this;
        this.readExtensions();
        this.loadConfig();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        activator = null;
    }

    protected String getBundleId() {
        return PLUGIN_ID;
    }

    public static CleIdePreferencesActivator getInstance() {
        if (activator == null) {
            activator = new CleIdePreferencesActivator();
        }
        return activator;
    }

    public Map<String, List<String>> getConfig() {
        return this.config;
    }

    private void loadConfig() {
        for (CategoryDescriptor category : this.registry.getCategoryDescriptors()) {
            ArrayList<String> vars = new ArrayList<String>();
            for (VariableDescriptor variable : category.getVariables()) {
                String varName = variable.getName();
                if (variable.isEclipseVariable()) {
                    vars.add(varName);
                    continue;
                }
                this.logWarning(NLS.bind((String)Messages.CleIdePreferencesActivator_trying_to_add_unknown_variable, (Object)varName));
            }
            this.config.put(category.getName(), vars);
        }
    }

    private void readExtensions() {
        List categories = Extensions.getConfigrationElements((String)PLUGIN_ID, (String)S32DSVARIABLES_EXT_POINT, (String)CATEGORY_ELEMENT, (String[])new String[0]);
        for (IConfigurationElement category : categories) {
            CategoryDescriptor categoryDescriptor = new CategoryDescriptor(category.getAttribute(NAME_ATTRIBUTE));
            IConfigurationElement[] iConfigurationElementArray = category.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement var = iConfigurationElementArray[n2];
                VariableDescriptor variableDescriptor = new VariableDescriptor(var.getAttribute(NAME_ATTRIBUTE));
                categoryDescriptor.addVariable(variableDescriptor);
                ++n2;
            }
            this.registry.addCategory(categoryDescriptor);
        }
    }
}

