/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.collateral.core.internal.model.implementations;

import com.nxp.s32ds.rcp.collateral.CollateralFeature;
import com.nxp.s32ds.rcp.collateral.CollateralListener;
import com.nxp.s32ds.rcp.collateral.CollateralPack;
import com.nxp.s32ds.rcp.collateral.CollateralRegistry;
import com.nxp.s32ds.rcp.collateral.CollateralResource;
import com.nxp.s32ds.rcp.collateral.CollateralResourceType;
import com.nxp.s32ds.rcp.collateral.CollateralTag;
import com.nxp.s32ds.rcp.collateral.core.internal.CollateralMaterialsActivator;
import com.nxp.s32ds.rcp.collateral.core.internal.model.implementations.CollateralFeatureImplementation;
import com.nxp.s32ds.rcp.collateral.core.internal.model.implementations.CollateralPackImplementation;
import com.nxp.s32ds.rcp.collateral.core.internal.model.implementations.CollateralResourceImplementation;
import com.nxp.s32ds.rcp.collateral.core.internal.model.implementations.Messages;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CollateralRegistryImplementation
implements CollateralRegistry {
    private Set<CollateralListener> listeners;
    private Set<CollateralPack> packs = new HashSet<CollateralPack>();
    private Set<CollateralTag> tags = new HashSet<CollateralTag>();
    private Set<CollateralResourceType> resourceTypes = new HashSet<CollateralResourceType>();

    public CollateralRegistryImplementation() {
        this.listeners = new HashSet<CollateralListener>();
    }

    public void addPack(CollateralPack pack) {
        if (!this.packs.add(pack)) {
            this.mergePacks(pack);
        }
        this.listeners.stream().forEach(CollateralListener::registryUpdated);
    }

    private void mergePacks(CollateralPack pack) {
        for (CollateralPack mergePack : this.packs) {
            if (!pack.equals(mergePack)) continue;
            for (CollateralFeature feature : pack.getFeatures()) {
                this.addCollateralFeatureToPack(feature, mergePack);
            }
        }
    }

    public void addTag(CollateralTag tag) {
        this.tags.add(tag);
    }

    public void addResourceType(CollateralResourceType resourceType) {
        this.resourceTypes.add(resourceType);
    }

    public Set<CollateralPack> getAllPacks() {
        return Collections.unmodifiableSet(this.packs);
    }

    public Set<CollateralFeature> getPackFeatures(String packageId) {
        Set result = null;
        for (CollateralPack clPackage : this.packs) {
            if (!clPackage.getId().equals(packageId)) continue;
            result = clPackage.getFeatures();
        }
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    public Set<CollateralResource> getAllResources() {
        HashSet<CollateralResource> result = new HashSet<CollateralResource>();
        for (CollateralPack clPackage : this.packs) {
            for (CollateralFeature clFeature : clPackage.getFeatures()) {
                result.addAll(clFeature.getResources());
            }
        }
        return result;
    }

    public Set<CollateralResource> getFeatureResources(String featureId) {
        Set result = null;
        for (CollateralPack clPackage : this.packs) {
            for (CollateralFeature clFeature : clPackage.getFeatures()) {
                if (!clFeature.getId().equals(featureId)) continue;
                result = clFeature.getResources();
            }
        }
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    public Set<CollateralResource> getResourcesByTag(String tagId) {
        HashSet<CollateralResource> result = new HashSet<CollateralResource>();
        for (CollateralPack clPackage : this.packs) {
            for (CollateralFeature clFeature : clPackage.getFeatures()) {
                for (CollateralResource resource : clFeature.getResources()) {
                    for (CollateralTag clTag : resource.getTags()) {
                        if (!clTag.getId().equals(tagId)) continue;
                        result.add(resource);
                    }
                }
            }
        }
        return result;
    }

    public Set<CollateralResource> getResourcesByResourceType(String tagId) {
        HashSet<CollateralResource> result = new HashSet<CollateralResource>();
        for (CollateralPack clPackage : this.packs) {
            for (CollateralFeature clFeature : clPackage.getFeatures()) {
                for (CollateralResource resource : clFeature.getResources()) {
                    if (!resource.getResourceType().getId().equals(tagId)) continue;
                    result.add(resource);
                }
            }
        }
        return result;
    }

    public Set<CollateralResourceType> getAllResourceTypes() {
        return Collections.unmodifiableSet(this.resourceTypes);
    }

    public CollateralPack getPacksById(String packageId) {
        for (CollateralPack collateralPack : this.packs) {
            if (!packageId.equals(collateralPack.getId())) continue;
            return collateralPack;
        }
        return null;
    }

    public CollateralFeature getFeatureById(String featureId) {
        for (CollateralPack collateralPack : this.packs) {
            for (CollateralFeature feature : collateralPack.getFeatures()) {
                if (!featureId.equals(feature.getId())) continue;
                return feature;
            }
        }
        return null;
    }

    public Set<CollateralResource> getResourcesByResourcesTypeIdAndFeatureId(String categoryId, String featureId) {
        HashSet<CollateralResource> collateralResources = new HashSet<CollateralResource>();
        for (CollateralPack collateralPack : this.packs) {
            for (CollateralFeature feature : collateralPack.getFeatures()) {
                if (!featureId.equals(feature.getId())) continue;
                for (CollateralResource collateralResource : feature.getResources()) {
                    if (!categoryId.equals(collateralResource.getResourceType().getId())) continue;
                    collateralResources.add(collateralResource);
                }
            }
        }
        return collateralResources;
    }

    public void addCollateralFeatureToPack(CollateralFeature collateralFeature, CollateralPack pack) {
        CollateralPackImplementation collateralPackImplementation;
        if (pack instanceof CollateralPackImplementation && !(collateralPackImplementation = (CollateralPackImplementation)pack).addCLFeature(collateralFeature)) {
            for (CollateralFeature margeFeature : pack.getFeatures()) {
                if (!margeFeature.equals(collateralFeature)) continue;
                for (CollateralResource resource : collateralFeature.getResources()) {
                    this.addCollateralResourceToFeature(resource, margeFeature);
                }
            }
        }
        if (collateralFeature instanceof CollateralFeatureImplementation) {
            ((CollateralFeatureImplementation)collateralFeature).setPack(pack);
        }
        this.listeners.stream().forEach(CollateralListener::registryUpdated);
    }

    public void addCollateralResourceToFeature(CollateralResource collateralResource, CollateralFeature collateralFeature) {
        if (collateralFeature instanceof CollateralFeatureImplementation && !((CollateralFeatureImplementation)collateralFeature).addCLResource(collateralResource)) {
            CollateralMaterialsActivator.getDefault().logWarning(Messages.bind((String)(String.valueOf(Messages.CollateralRegistryImplementation_DublicateCollateralResourceId) + collateralResource.getId()), (Object)collateralResource.getId()));
            return;
        }
        if (collateralResource instanceof CollateralResourceImplementation) {
            ((CollateralResourceImplementation)collateralResource).setFeature(collateralFeature);
        }
        this.listeners.stream().forEach(CollateralListener::registryUpdated);
    }

    public void addCollateralTagToResource(CollateralTag tag, CollateralResource collateralResource) {
        if (collateralResource instanceof CollateralResourceImplementation) {
            ((CollateralResourceImplementation)collateralResource).addCLTag(tag);
        }
    }

    public void setCollateralResourceTypeToResource(CollateralResourceType resourceType, CollateralResource collateralResource) {
        if (collateralResource instanceof CollateralResourceImplementation) {
            ((CollateralResourceImplementation)collateralResource).setResourceType(resourceType);
        }
    }

    public Set<CollateralTag> getAllCollateralTag() {
        return Collections.unmodifiableSet(this.tags);
    }

    public void addPacks(Set<CollateralPack> inputPacks) {
        inputPacks.stream().filter(pack -> !this.packs.add((CollateralPack)pack)).forEach(this::mergePacks);
        this.listeners.stream().forEach(CollateralListener::registryUpdated);
    }

    public void addCollateralListener(CollateralListener listener) {
        this.listeners.add(listener);
    }

    public void removeCollateralListener(CollateralListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllCollateralListeners() {
        this.listeners.clear();
    }
}

