/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.wizards.processordata;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.expert.processordb.IConfigComponentInfo;
import com.nxp.swtools.expert.processordb.ISWToolsDataFolderInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.framework.wizards.processordata.ExportImportProcessorDataUtils;
import com.nxp.swtools.framework.wizards.processordata.ImportProcessorDataPage;
import com.nxp.swtools.provider.processors.DataPackage;
import com.nxp.swtools.utils.wizards.KExWizard;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ImportProcessorDataWizard
extends KExWizard
implements IImportWizard {
    @Nullable
    private ImportProcessorDataPage mainPage;
    protected static final Logger LOGGER = LogManager.getLogger(ImportProcessorDataWizard.class);

    public void init(@Nullable IWorkbench workbench, @Nullable IStructuredSelection selection) {
        this.setWindowTitle(Messages.get().ImportProcessorDataWizard_WindowTitle);
        this.setNeedsProgressMonitor(true);
        this.mainPage = new ImportProcessorDataPage(UtilsText.safeString((String)Messages.get().ImportProcessorDataWizard_WindowTitle));
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.mainPage);
    }

    ImportProcessorDataPage getMainPage() {
        assert (this.mainPage != null);
        return this.mainPage;
    }

    public boolean performFinish() {
        AtomicBoolean result = new AtomicBoolean(true);
        Object[] selection = this.getMainPage().getSelection();
        ISupportedDerivativesForSwTools input = (ISupportedDerivativesForSwTools)this.getMainPage().getViewer().getInput();
        assert (input != null);
        String importDataTaskName = UtilsText.safeString((String)Messages.get().ImportProcessorDataWizard_ImportingDataTask);
        ISupportedDerivativesForSwTools targetSuppDerivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        Collection<ISWToolsDataFolderInfo> dataToImport = ExportImportProcessorDataUtils.convertSelectionToSWToolsData(selection, input);
        Collection<IConfigComponentInfo> componentsToImport = ExportImportProcessorDataUtils.getComponentsToUpgrade(input.getAllComponentsInfos(), targetSuppDerivatives);
        try {
            this.getContainer().run(true, true, monitor -> {
                Path tempDir = this.getMainPage().getWorkTempDir();
                assert (tempDir != null);
                SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)importDataTaskName, (int)dataToImport.size());
                try {
                    DataPackage.copyData((Collection)dataToImport, (Collection)componentsToImport, (File)tempDir.toFile(), (File)new File(targetSuppDerivatives.getDataDir()), (IProgressMonitor)subMon.newChild(dataToImport.size()));
                }
                catch (IOException e) {
                    Shell shell = this.getShell();
                    assert (shell != null);
                    shell.getDisplay().syncExec(() -> MessageDialog.openError((Shell)shell, (String)Messages.get().NewConfigDialog_ErrorDialogTitle, (String)(String.valueOf(Messages.get().ExportProcessorDataWizard_CannotExportProcessorData) + "\r\n" + e.getMessage())));
                    LOGGER.log(Level.SEVERE, "cannot import data ", e);
                    result.set(false);
                }
                targetSuppDerivatives.refreshSupportedDerivatives();
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.log(Level.WARNING, "Unable to import processors data ", e);
        }
        return result.get();
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    public static void openWizard() {
        ImportProcessorDataWizard wizard = new ImportProcessorDataWizard();
        WizardDialog wd = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        wd.setTitle(wizard.getWindowTitle());
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection());
        wd.open();
    }
}

