/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.wizards.processordata;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.dialogs.KExProgressMonitorDialog;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.runtime.JobsHelper;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.zip.ZipUtils;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.framework.ui.downloadmanager.DataManager;
import com.nxp.swtools.framework.ui.newconfig.ProcessorNode;
import com.nxp.swtools.framework.ui.newconfig.containers.ProcessorSelectionContainer;
import com.nxp.swtools.framework.wizards.processordata.ExportImportProcessorDataUtils;
import com.nxp.swtools.provider.processors.DataPackage;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiPredicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class ImportProcessorDataPage
extends WizardPage {
    @Nullable
    protected Text userFileNameText = null;
    @Nullable
    protected CheckboxTreeViewer viewer;
    @Nullable
    private Path workTempDir;
    static Logger LOGGER = LogManager.getLogger(ImportProcessorDataPage.class);
    @Nullable
    private File extractedArchive;
    static final BiPredicate<ITemplateInfo, @Nullable ITemplateInfo> templateVersionUpdatePredicate = (t1, t2) -> t2 == null || KExProcessorsProvider.isVersionHigher((String)t1.getVersion(), (String)t2.getVersion());
    static final BiPredicate<IProcessorMasterToolInfo, ISupportedDerivativesForSwTools> processorVersionUpdatePredicate = (it, sharedDerivatives) -> Objects.isNull(sharedDerivatives.getProcessorMasterToolInfo(it.getId(), it.getSWToolsDataFolderID())) || sharedDerivatives.getProcessorMasterToolInfos(it.getId()).anyMatch(p -> KExProcessorsProvider.isVersionHigher((String)it.getVersion(), (String)p.getVersion()));

    protected ImportProcessorDataPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.get().ImportProcessorDataPage_ImportProcessorData);
        try {
            this.workTempDir = Files.createTempDirectory("exported_data", new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Cannot create temp. directory");
            e.printStackTrace();
        }
    }

    String getSelectedFile() {
        Text exportTextLoc = this.userFileNameText;
        assert (exportTextLoc != null);
        return exportTextLoc.getText();
    }

    Object[] getSelection() {
        return ExportImportProcessorDataUtils.getSelection(this.getViewer());
    }

    public @Nullable Path getWorkTempDir() {
        return this.workTempDir;
    }

    protected CheckboxTreeViewer getViewer() {
        assert (this.viewer != null);
        return this.viewer;
    }

    public void createControl(@NonNull Composite parent) {
        Text userFileNameTextLoc;
        Composite pageComposite = new Composite(parent, 0);
        pageComposite.setLayout((Layout)new GridLayout(1, false));
        pageComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).minSize(600, 200).create());
        this.setControl((Control)pageComposite);
        Composite dirComposite = new Composite(pageComposite, 0);
        dirComposite.setLayout((Layout)new GridLayout(3, false));
        dirComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).indent(0, 0).create());
        Label userFileNameLabel = new Label(dirComposite, 0);
        GridData gridData = new GridData();
        userFileNameLabel.setLayoutData((Object)gridData);
        userFileNameLabel.setText(Messages.get().ImportProcessorDataPage_Archive);
        this.userFileNameText = userFileNameTextLoc = new Text(dirComposite, 2048);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)userFileNameTextLoc, "DownloadProcessorDataCustomDirectoryText");
        userFileNameTextLoc.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        userFileNameTextLoc.addModifyListener(e -> this.validatePage());
        Button findButton = new Button(dirComposite, 0);
        findButton.setText(Messages.get().ExportProcessorDataPage_Browse);
        findButton.addListener(13, event -> {
            Shell shell = parent.getShell();
            String title = UtilsText.safeString((String)Messages.get().ImportProcessorDataPage_SelectSourceArchive);
            FileDialog fd = new FileDialog(shell, 4096);
            fd.setText(title);
            fd.setFilterExtensions(ExportImportProcessorDataUtils.ZIP_EXTENSIONS);
            fd.setFileName(userFileNameTextLoc.getText());
            String selectedPath = fd.open();
            if (selectedPath != null && !selectedPath.isEmpty()) {
                userFileNameTextLoc.setText(selectedPath);
            }
        });
        Label seriesLabel = new Label(pageComposite, 0);
        gridData = new GridData();
        seriesLabel.setLayoutData((Object)gridData);
        seriesLabel.setText(Messages.get().ImportProcessorDataPage_SelectWhatToImport);
        CheckboxTreeViewer viewerLoc = this.viewer = ExportImportProcessorDataUtils.createTreeWithProcessorData(pageComposite, null);
        viewerLoc.setAutoExpandLevel(2);
        viewerLoc.addCheckStateListener(event -> this.checkStateChanged(event));
        ImportProcessorDataPage.createStatusColumn((TreeViewer)viewerLoc, SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools());
        this.validatePage();
    }

    private static void createStatusColumn(final TreeViewer treeViewer, final ISupportedDerivativesForSwTools derivatives) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(treeViewer, 0);
        TreeColumn column = viewerColumn.getColumn();
        column.setText(Messages.get().ProcessorProvider_StatusColumn);
        column.setWidth(250);
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public @Nullable String getText(Object element) {
                if (element instanceof ProcessorNode) {
                    return null;
                }
                if (ProcessorSelectionContainer.isElementAvailableOffline(element, derivatives)) {
                    String cachVer = ProcessorSelectionContainer.getOfflineElementVersion(element, derivatives);
                    Object input = treeViewer.getInput();
                    if (!$assertionsDisabled && input == null) {
                        throw new AssertionError();
                    }
                    String importVer = ProcessorSelectionContainer.getOfflineElementVersion(element, (ISupportedDerivativesForSwTools)input);
                    if (KExProcessorsProvider.isVersionHigher((String)importVer, (String)cachVer)) {
                        return MessageFormat.format(Messages.get().ImportProcessorDataPage_ImportStatusNewer, cachVer, importVer);
                    }
                    if (KExProcessorsProvider.isVersionHigher((String)cachVer, (String)importVer)) {
                        return MessageFormat.format(Messages.get().ImportProcessorDataPage_ImportStatusOlder, cachVer, importVer);
                    }
                    return MessageFormat.format(Messages.get().ImportProcessorDataPage_ImportStatusSame, cachVer, importVer);
                }
                return Messages.get().ImportProcessorDataPage_ImportStatusNew;
            }
        });
    }

    protected static boolean isUpdateAvailable(TreeViewer viewer, Object element, ISupportedDerivativesForSwTools derivatives) {
        if (element instanceof ITemplateInfo) {
            ITemplateInfo template = (ITemplateInfo)element;
            switch (template.getTemplateType()) {
                case ttTemplate: {
                    return false;
                }
                case ttBoard: {
                    return templateVersionUpdatePredicate.test(template, derivatives.getBoardById(template.getId(), template.getSWToolsDataFolderID()));
                }
                case ttKit: {
                    return templateVersionUpdatePredicate.test(template, derivatives.getKitById(template.getId(), template.getSWToolsDataFolderID()));
                }
            }
            assert (false) : "unsupported template type";
        } else if (element instanceof IProcessorMasterToolInfo) {
            IProcessorMasterToolInfo info = (IProcessorMasterToolInfo)element;
            ISupportedDerivativesForSwTools input = (ISupportedDerivativesForSwTools)viewer.getInput();
            if (input == null) {
                return false;
            }
            return input.getProcessorMasterToolInfos(info.getId()).anyMatch(it -> processorVersionUpdatePredicate.test((IProcessorMasterToolInfo)it, derivatives));
        }
        return false;
    }

    private void checkStateChanged(CheckStateChangedEvent event) {
        DataManager.checkSubTree(event);
        this.validatePage();
    }

    protected void validatePage() {
        String errMessage = null;
        String warnMessage = null;
        boolean valid = true;
        File archive = new File(this.getSelectedFile());
        // Could not load outer class - annotation placement on inner may be incorrect
        CollectionsUtils.Pair<ArchiveStatus, @Nullable String> archiveStatus = ImportProcessorDataPage.validateArchive(archive);
        switch ((ArchiveStatus)((Object)archiveStatus.getFirst())) {
            case ARCHIVE_OK: {
                break;
            }
            case ARCHIVE_WARNING: {
                warnMessage = (String)archiveStatus.getSecond();
                break;
            }
            case ARCHIVE_ERROR: {
                valid = false;
                errMessage = (String)archiveStatus.getSecond();
            }
        }
        if (valid) {
            this.getViewer().getTree().setEnabled(true);
            if (this.isRefreshNeeded(archive)) {
                this.runLongOperation(monitor -> {
                    monitor.beginTask(UtilsText.safeString((String)Messages.get().ImportProcessorDataPage_ExtractingArchive), -1);
                    this.extractArchive(archive);
                });
                this.refreshTreeContent();
            }
        } else {
            this.getViewer().getTree().setEnabled(false);
        }
        if (valid && this.getSelection().length == 0) {
            errMessage = Messages.get().ExportProcessorDataPage_NoDataSelected;
            valid = false;
        }
        this.setMessage(warnMessage, 2);
        this.setErrorMessage(errMessage);
        this.setPageComplete(valid);
    }

    private void runLongOperation(IRunnableWithProgress runnable) {
        KExProgressMonitorDialog.run((Shell)this.getShell(), (boolean)false, null, (IRunnableWithProgress)runnable);
    }

    private boolean isRefreshNeeded(File archive) {
        return !archive.equals(this.extractedArchive);
    }

    private void refreshTreeContent() {
        assert (this.workTempDir != null);
        SupportedDerivativesForSwTools supportedDerivatives = new SupportedDerivativesForSwTools(this.workTempDir.toString());
        this.getViewer().setInput((Object)supportedDerivatives);
        this.checkNotConflictingItems((ISupportedDerivativesForSwTools)supportedDerivatives, SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools());
    }

    private void checkNotConflictingItems(ISupportedDerivativesForSwTools tempDerivatives, ISupportedDerivativesForSwTools sharedDerivatives) {
        tempDerivatives.getAllProcessorMasterToolInfos().filter(it -> processorVersionUpdatePredicate.test((IProcessorMasterToolInfo)it, sharedDerivatives)).distinct().map(it -> it.getId()).forEach(it -> {
            boolean bl = this.getViewer().setChecked(it, true);
        });
        tempDerivatives.getAllBoardsInfos().stream().filter(it -> templateVersionUpdatePredicate.test((ITemplateInfo)it, sharedDerivatives.getBoardById(it.getId(), it.getSWToolsDataFolderID()))).forEach(it -> {
            boolean bl = this.getViewer().setChecked(it, true);
        });
        tempDerivatives.getAllKitsInfos().stream().filter(it -> templateVersionUpdatePredicate.test((ITemplateInfo)it, sharedDerivatives.getKitById(it.getId(), it.getSWToolsDataFolderID()))).forEach(it -> {
            boolean bl = this.getViewer().setChecked(it, true);
        });
    }

    private void extractArchive(File archive) {
        if (archive.equals(this.extractedArchive)) {
            return;
        }
        this.extractedArchive = null;
        Path workTempDirLoc = this.workTempDir;
        if (workTempDirLoc == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.get().NewConfigDialog_ErrorDialogTitle, (String)Messages.get().ImportProcessorDataPage_CannotExtractTotemp);
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipInputStream zip = new ZipInputStream(new FileInputStream(archive));){
                this.cleanupTempDir(true);
                ZipUtils.extractZip((ZipInputStream)zip, (File)workTempDirLoc.toFile(), (boolean)true);
                this.extractedArchive = archive;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
        }
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    CollectionsUtils.Pair<ArchiveStatus, @Nullable String> validateArchive(File archive) {
        if (!archive.exists()) {
            return new CollectionsUtils.Pair((Object)ArchiveStatus.ARCHIVE_ERROR, (Object)Messages.get().ExportProcessorDataPage_InvalidFileName);
        }
        try {
            Properties props = DataPackage.getManifestAsproperties((File)archive);
            if (props == null) {
                return new CollectionsUtils.Pair((Object)ArchiveStatus.ARCHIVE_ERROR, (Object)Messages.get().ImportProcessorDataPage_NotDataArchive);
            }
            String archiveDataVersion = props.getProperty("data_version");
            if (UtilsText.isEmpty((String)archiveDataVersion)) {
                return new CollectionsUtils.Pair((Object)ArchiveStatus.ARCHIVE_ERROR, (Object)Messages.get().ImportProcessorDataPage_NotDataArchive);
            }
            if (KExProcessorsProvider.isVersionHigher((String)archiveDataVersion, (String)KExProcessorsProvider.getRestApiDataVersion())) {
                return new CollectionsUtils.Pair((Object)ArchiveStatus.ARCHIVE_ERROR, (Object)Messages.get().ImportProcessorDataPage_IncompatibleData);
            }
            if (KExProcessorsProvider.isVersionHigher((String)KExProcessorsProvider.getRestApiDataVersion(), (String)archiveDataVersion)) {
                return new CollectionsUtils.Pair((Object)ArchiveStatus.ARCHIVE_WARNING, (Object)Messages.get().ImportProcessorDataPage_OldVersionData);
            }
            return new CollectionsUtils.Pair((Object)ArchiveStatus.ARCHIVE_OK, null);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "extracting archive", e);
            return new CollectionsUtils.Pair((Object)ArchiveStatus.ARCHIVE_ERROR, (Object)Messages.get().ExportProcessorDataPage_InvalidFileName);
        }
    }

    public void dispose() {
        JobsHelper.runjob((String)UtilsText.safeString((String)Messages.get().ImportProcessorDataPage_CleaningTemporaryFiles), () -> this.cleanupTempDir(false));
        super.dispose();
    }

    private void cleanupTempDir(boolean contentOnly) {
        if (this.workTempDir != null) {
            UtilsFile.deleteDirectory((File)this.workTempDir.toFile(), (boolean)contentOnly);
        }
    }

    static enum ArchiveStatus {
        ARCHIVE_OK,
        ARCHIVE_WARNING,
        ARCHIVE_ERROR;

    }
}

