/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.wizards.processordata;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.expert.processordb.ISWToolsDataFolderInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.framework.wizards.processordata.ExportImportProcessorDataUtils;
import com.nxp.swtools.framework.wizards.processordata.ExportProcessorDataPage;
import com.nxp.swtools.provider.processors.DataPackage;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.wizards.KExWizard;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ExportProcessorDataWizard
extends KExWizard
implements IExportWizard {
    @Nullable
    ExportProcessorDataPage mainPage;
    protected static final Logger LOGGER = LogManager.getLogger(ExportProcessorDataWizard.class);

    public void init(@Nullable IWorkbench workbench, @Nullable IStructuredSelection selection) {
        this.setWindowTitle(Messages.get().ExportProcessorDataWizard_WindowTitle);
        this.setNeedsProgressMonitor(true);
        this.mainPage = new ExportProcessorDataPage(UtilsText.safeString((String)Messages.get().ExportProcessorDataWizard_WindowTitle));
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.mainPage);
    }

    ExportProcessorDataPage getMainPage() {
        assert (this.mainPage != null);
        return this.mainPage;
    }

    public boolean performFinish() {
        AtomicBoolean result = new AtomicBoolean(true);
        this.getMainPage().selectDependencies();
        Object[] selection = this.getMainPage().getSelection();
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        Collection<ISWToolsDataFolderInfo> dataToExport = ExportImportProcessorDataUtils.convertSelectionToSWToolsData(selection, derivatives);
        Collection components = derivatives.getAllComponentsInfos();
        Shell shell = this.getShell();
        assert (shell != null);
        if (!dataToExport.isEmpty()) {
            String archiveFileName = this.getMainPage().getSelectedFile();
            KEPreferences.setLastSaveFolderPath((String)UtilsText.safeString((String)UtilsFile.getFilePath((String)archiveFileName)));
            if (UtilsText.isEmpty((String)archiveFileName)) {
                assert (false);
                return false;
            }
            String exportDataTaskName = UtilsText.safeString((String)Messages.get().ExportProcessorDataWizard_ExportingDataTask);
            try {
                this.getContainer().run(true, true, monitor -> {
                    File archiveFile = new File(archiveFileName);
                    File parent = archiveFile.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)exportDataTaskName, (int)dataToExport.size());
                    try {
                        Throwable throwable = null;
                        Object var13_15 = null;
                        try (FileOutputStream ous = new FileOutputStream(archiveFile);){
                            result.set(DataPackage.createDataPackage((ISupportedDerivativesForSwTools)derivatives, (OutputStream)ous, (Collection)dataToExport, (Collection)components, (IProgressMonitor)subMon.newChild(dataToExport.size())));
                            if (!result.get() && !archiveFile.delete()) {
                                archiveFile.deleteOnExit();
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        shell.getDisplay().syncExec(() -> MessageDialog.openError((Shell)this.getShell(), (String)Messages.get().NewConfigDialog_ErrorDialogTitle, (String)(String.valueOf(Messages.get().ExportProcessorDataWizard_CannotExportProcessorData) + "\r\n" + e.getMessage())));
                        LOGGER.log(Level.SEVERE, "cannot export data ", e);
                        result.set(false);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOGGER.log(Level.WARNING, "Unable to export processors data ", e);
            }
        }
        return result.get();
    }

    public static void openWizard() {
        ExportProcessorDataWizard wizard = new ExportProcessorDataWizard();
        WizardDialog wd = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        wd.setTitle(wizard.getWindowTitle());
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection());
        wd.open();
    }
}

