/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.ui.newconfig.containers;

import com.nxp.swtools.common.ui.utils.swt.ColumnCenteredImagePainter;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.Triplet;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISWToolsDataFolderInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedToolsByProcessor;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.framework.ui.newconfig.NewConfigWizard;
import com.nxp.swtools.framework.ui.newconfig.ProcessorMergeHelper;
import com.nxp.swtools.framework.ui.newconfig.ProcessorNode;
import com.nxp.swtools.framework.ui.newconfig.ProcessorProvider;
import com.nxp.swtools.framework.ui.newconfig.containers.IProcessorSelectionContainer;
import com.nxp.swtools.framework.ui.newconfig.containers.ProcessorCategoryLabelProvider;
import com.nxp.swtools.kex.api.IProcessorInfo;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.processors.ISWToolsProcessorInfo;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.provider.processors.OnlineDataInfo;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.command.SelectPackageDialog;
import com.nxp.swtools.utils.resources.ToolsImages;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class ProcessorSelectionContainer
implements IProcessorSelectionContainer {
    private static final int COMBO_WIDTH_HINT = 280;
    @NonNull
    private static final String DEFAULT_PACKAGE = "<default>";
    @NonNull
    static final Logger LOGGER = LogManager.getLogger(ProcessorSelectionContainer.class);
    private static final int MIN_VISIBLE_ROWS = 14;
    private static final ProcessorCore CORE_NOT_SELECTED = new ProcessorCore("not_selected", UtilsText.safeString((String)Messages.get().NewConfigDialog_NotSelectedCore), UtilsText.safeString((String)Messages.get().NewConfigDialog_NotSelectedCoreDescription));
    @NonNull
    WritableValue<String> selectedMcu = new WritableValue((Object)"", String.class);
    @NonNull
    WritableValue<String> selectedBoard = new WritableValue((Object)"", String.class);
    @NonNull
    WritableValue<String> selectedKit = new WritableValue((Object)"", String.class);
    @NonNull
    WritableValue<String> selectedTemplate = new WritableValue((Object)"", String.class);
    @NonNull
    WritableValue<String> configurationName = new WritableValue((Object)"", String.class);
    @NonNull
    WritableValue<Object> sdkVersion = new WritableValue(null, String.class);
    IObservableList<Object> sdkVersions = Properties.selfList(ISWToolsProcessorInfo.class).observe(new ArrayList());
    @NonNull
    WritableValue<PackageTriplet> selectedPackage = new WritableValue(null, PackageTriplet.class);
    IObservableList<Object> packages = Properties.selfList(PackageTriplet.class).observe(new ArrayList());
    @NonNull
    WritableValue<ProcessorCore> selectedCore = new WritableValue(null, ProcessorCore.class);
    IObservableList<Object> cores = Properties.selfList(ProcessorCore.class).observe(new ArrayList());
    @NonNull
    final ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
    DataBindingContext ctx = new DataBindingContext();
    @NonNull
    final OnlineDataInfo onlineDataInfo = new OnlineDataInfo();
    boolean switchingProcessor = false;
    @NonNull
    private @NonNull Consumer<@NonNull Boolean> canFinishCallback;
    @NonNull
    private @NonNull Consumer<@NonNull Boolean> doFinishCallback;
    FilteredTree processorFT;
    Label searchLabel;
    private boolean createFromTemplateAllowed = true;
    private static final char[] INVALID_RESOURCE_CHARACTERS = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|', '@'};
    @NonNull
    private static final String UNSUPPORTED_TEMPLATE_TYPE = "unsupported template type";

    public ProcessorSelectionContainer(@NonNull Consumer<@NonNull Boolean> canFinishCallback, @NonNull Consumer<@NonNull Boolean> doFinishCallback) {
        this.configurationName.setValue((Object)"");
        this.selectedMcu.setValue((Object)"");
        this.selectedBoard.setValue((Object)"");
        this.selectedKit.setValue((Object)"");
        this.selectedTemplate.setValue((Object)"");
        this.canFinishCallback = canFinishCallback;
        this.doFinishCallback = doFinishCallback;
    }

    @Override
    public @Nullable String getConfigurationName() {
        return (String)this.configurationName.getValue();
    }

    @Override
    public @Nullable String getSelectedMcu() {
        return (String)this.selectedMcu.getValue();
    }

    @Override
    public @Nullable String getSelectedBoard() {
        return (String)this.selectedBoard.getValue();
    }

    @Override
    public @Nullable String getSelectedKit() {
        return (String)this.selectedKit.getValue();
    }

    @Override
    public @Nullable String getSelectedPackage() {
        PackageTriplet triplet = (PackageTriplet)((Object)this.selectedPackage.getValue());
        String value = triplet != null ? (String)triplet.getFirst() : null;
        return DEFAULT_PACKAGE.equals(value) ? null : value;
    }

    @Override
    public @Nullable ProcessorCore getSelectedCore() {
        ProcessorCore core = (ProcessorCore)this.selectedCore.getValue();
        return core == CORE_NOT_SELECTED ? null : core;
    }

    @Override
    public @Nullable String getSelectedTemplate() {
        return (String)this.selectedTemplate.getValue();
    }

    @Override
    public @Nullable Object getSelectedSdkVersion() {
        return this.sdkVersion.getValue();
    }

    public void setSwitchingProcessor(boolean value) {
        this.switchingProcessor = value;
    }

    @Override
    public boolean isSwitchingProcessor() {
        return this.switchingProcessor;
    }

    public void createControls(@NonNull Composite container) {
        this.createSearchPart(container);
        this.createNamePart(container);
        this.createPackageCodeSdkVersionPart(container);
    }

    private void createSearchPart(@Nullable Composite container) {
        this.searchLabel = new Label(container, 0);
        GridDataFactory.swtDefaults().grab(true, false).applyTo((Control)this.searchLabel);
        ProcessorPatternFilter filter = new ProcessorPatternFilter();
        filter.setPattern("org.eclipse.ui.keys.optimization.false");
        filter.setIncludeLeadingWildcard(true);
        this.processorFT = new FilteredTree(container, 66304, (PatternFilter)filter, true);
        TreeViewer processorTV = this.processorFT.getViewer();
        Tree processorTree = processorTV.getTree();
        this.processorFT.setFocus();
        SWTFactoryProxy.INSTANCE.setTestId((Widget)this.processorFT.getFilterControl(), "NewConfigurationFilterText");
        SWTFactoryProxy.INSTANCE.setTestId((Widget)processorTree, "NewConfigurationTree");
        if (!SWToolsProperties.isDevelopmentWithNoDataUpdateOn()) {
            this.onlineDataInfo.refresh();
        }
        ProcessorProvider processorProvider = new ProcessorProvider(this.onlineDataInfo, p -> true, b -> true, b -> this.isTemplateVisible((ITemplateInfo)b));
        processorProvider.setIsBoardIncluded(!this.switchingProcessor);
        processorTV.setContentProvider((IContentProvider)processorProvider);
        this.createColumns(processorTV);
        assert (this.derivatives != null);
        processorTV.setInput((Object)this.derivatives);
        if (this.switchingProcessor) {
            String selMcu = UtilsText.safeString((String)SWToolsPlatform.getSharedConfigurationSingleton().getCommonConfig().getMcu());
            String selSdkVersion = UtilsText.safeString((String)SWToolsPlatform.getSharedConfigurationSingleton().getCommonConfig().getSdkVersion());
            String selSeries = UtilsText.safeString((String)this.derivatives.getSeries(selMcu, selSdkVersion));
            processorTV.setSelection((ISelection)new TreeSelection(new TreePath(new Object[]{new ProcessorNode(UtilsText.safeString((String)Messages.get().ProcessorProvider_ProcessorsNode)), new ProcessorNode(selSeries), selMcu})), true);
            processorTV.getTree().showSelection();
            this.selectedMcu.setValue((Object)selMcu);
            ProcessorMergeHelper mergeHelper = new ProcessorMergeHelper(this.derivatives, this.onlineDataInfo);
            Map<String, IProcessorMasterToolInfo> sdkMap = mergeHelper.getSdkProcessorMap(selMcu);
            this.sdkVersions.addAll(sdkMap.values());
            this.sdkVersions.stream().filter(s -> selSdkVersion.equals(((IProcessorMasterToolInfo)s).getSWToolsDataFolderID())).findFirst().ifPresent(s -> this.sdkVersion.setValue(s));
        }
        processorTree.addListener(13, event -> {
            TreeItem[] selection = processorTree.getSelection();
            if (selection.length < 1) {
                return;
            }
            Object prevSelectedMcu = this.selectedMcu.getValue();
            Object prevSelectedBoard = this.selectedBoard.getValue();
            Object prevSelectedKit = this.selectedKit.getValue();
            Object prevSelectedTemplate = this.selectedTemplate.getValue();
            Object selectionData = selection[0].getData();
            if (selection[0].getItemCount() == 0 && !(selectionData instanceof ProcessorNode) || this.createFromTemplateAllowed && selectionData instanceof ITemplateInfo) {
                String selText = "";
                if (selectionData instanceof IProcessorMasterToolInfo) {
                    selText = ((IProcessorMasterToolInfo)selectionData).getId();
                }
                String mcu = selText;
                this.sdkVersions.clear();
                this.packages.clear();
                this.cores.clear();
                this.cores.add((Object)CORE_NOT_SELECTED);
                ProcessorMergeHelper mergeHelper = new ProcessorMergeHelper(this.derivatives, this.onlineDataInfo);
                if (selectionData instanceof ITemplateInfo) {
                    ITemplateInfo templInfo = (ITemplateInfo)selectionData;
                    mcu = templInfo.getMasterToolName();
                    this.selectedBoard.setValue((Object)"");
                    this.selectedKit.setValue((Object)"");
                    switch (templInfo.getTemplateType()) {
                        case ttTemplate: {
                            this.selectedTemplate.setValue((Object)templInfo.getId());
                            break;
                        }
                        case ttBoard: {
                            this.selectedBoard.setValue((Object)templInfo.getId());
                            break;
                        }
                        case ttKit: {
                            this.selectedKit.setValue((Object)templInfo.getId());
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    @NonNull Map<String, ITemplateInfo> sdkMap = mergeHelper.getSdkBoardMap(templInfo.getId(), templInfo.getTemplateType());
                    if (ITemplateInfo.TemplateType.ttTemplate == templInfo.getTemplateType()) {
                        sdkMap = ProcessorSelectionContainer.getSdkMapForTemplate(templInfo);
                    }
                    this.sdkVersions.addAll(sdkMap.values());
                } else {
                    this.selectedBoard.setValue((Object)"");
                    this.selectedKit.setValue((Object)"");
                    Map<String, IProcessorMasterToolInfo> sdkMap = mergeHelper.getSdkProcessorMap(mcu);
                    this.sdkVersions.addAll(sdkMap.values());
                }
                this.selectedMcu.setValue((Object)mcu);
                this.sdkVersions.stream().findFirst().ifPresent(s -> this.sdkVersion.setValue(s));
                if (!(selectionData instanceof ITemplateInfo)) {
                    this.packages.addAll(this.getPackagesForProcessor(mcu, this.getSelectedSdk()));
                }
                this.packages.stream().filter(p -> (Boolean)((PackageTriplet)((Object)((Object)((Object)p)))).getThird()).findFirst().ifPresent(s -> this.selectedPackage.setValue((Object)((PackageTriplet)((Object)((Object)((Object)s))))));
                ISWToolsDataFolderInfo selSdk = (ISWToolsDataFolderInfo)this.sdkVersion.getValue();
                if (selSdk != null) {
                    SWToolsPlatform.CoresInfoLoader coresInfo = SWToolsPlatform.getCoresInfo((String)mcu, (String)selSdk.getSWToolsDataFolderID(), (ISupportedDerivativesForSwTools)this.derivatives);
                    if (coresInfo == null && NewConfigWizard.isDownloadOrUpdatePossible()) {
                        coresInfo = SWToolsPlatform.getCoresInfoFromWeb((String)mcu, (String)selSdk.getSWToolsDataFolderID());
                    }
                    if (coresInfo != null) {
                        this.cores.addAll((Collection)coresInfo.cores);
                    }
                }
                if (this.cores.size() == 2) {
                    this.selectedCore.setValue((Object)((ProcessorCore)this.cores.get(1)));
                } else {
                    this.selectedCore.setValue((Object)CORE_NOT_SELECTED);
                }
                this.canFinishCallback.accept(Boolean.TRUE);
            } else {
                this.clearSelection();
            }
            if (prevSelectedBoard.equals(this.configurationName.getValue()) || prevSelectedMcu.equals(this.configurationName.getValue()) || prevSelectedKit.equals(this.configurationName.getValue()) || prevSelectedTemplate.equals(this.configurationName.getValue())) {
                if (!UtilsText.isEmpty((String)((String)this.selectedBoard.getValue()))) {
                    this.configurationName.setValue((Object)((String)this.selectedBoard.getValue()));
                } else if (!UtilsText.isEmpty((String)((String)this.selectedKit.getValue()))) {
                    this.configurationName.setValue((Object)((String)this.selectedKit.getValue()));
                } else if (!UtilsText.isEmpty((String)((String)this.selectedTemplate.getValue()))) {
                    this.configurationName.setValue((Object)((String)this.selectedTemplate.getValue()));
                } else {
                    this.configurationName.setValue((Object)((String)this.selectedMcu.getValue()));
                }
            }
        });
        processorTree.addListener(8, e -> {
            TreeItem item = processorTree.getItem(new Point(e.x, e.y));
            if (item != null && item.getItemCount() >= 0) {
                Object data;
                processorTV.setExpandedState(data, !processorTV.getExpandedState(data = item.getData()));
            }
            if (!(UtilsText.isEmpty((String)((String)this.selectedMcu.getValue())) && UtilsText.isEmpty((String)((String)this.selectedBoard.getValue())) && UtilsText.isEmpty((String)((String)this.selectedKit.getValue())) && UtilsText.isEmpty((String)((String)this.selectedTemplate.getValue())))) {
                this.fireFinishDialog();
            }
        });
        GridData treeData = new GridData();
        treeData.grabExcessHorizontalSpace = true;
        treeData.grabExcessVerticalSpace = true;
        treeData.horizontalAlignment = 4;
        treeData.verticalAlignment = 4;
        treeData.heightHint = processorTree.getItemHeight() > 0 ? processorTree.getItemHeight() * 14 : 224;
        processorTree.setLayoutData((Object)treeData);
        this.setSearchTitle();
        if (this.onlineDataInfo.getOnlineProcessors().isEmpty() && !this.derivatives.getAllProcessorMasterToolInfos().findAny().isPresent()) {
            processorTree.getDisplay().asyncExec(() -> MessageDialog.openError((Shell)processorTree.getShell(), (String)Messages.get().NewConfigDialog_ErrorDialogTitle, (String)Messages.get().NewConfigDialog_OfflineModeNoData));
        }
    }

    protected void createColumns(@NonNull TreeViewer treeViewer) {
        Tree tree = treeViewer.getTree();
        SWTFactoryProxy.INSTANCE.enableHtmlTooltipFor((ColumnViewer)treeViewer);
        tree.setToolTipText("");
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        ProcessorSelectionContainer.createNameColumn(treeViewer, this.derivatives);
        ProcessorSelectionContainer.createProductColumns(treeViewer, this.derivatives, this.onlineDataInfo, () -> this.getSelectedSdk());
        ProcessorSelectionContainer.createStatusColumn(treeViewer, this.derivatives, this.onlineDataInfo);
    }

    public static void createNameColumn(@NonNull TreeViewer treeViewer, @NonNull ISupportedDerivativesForSwTools derivatives) {
        TreeViewerColumn firstColumn = new TreeViewerColumn(treeViewer, 0);
        TreeColumn firstCol = firstColumn.getColumn();
        firstCol.setWidth(300);
        firstCol.setText(Messages.get().NewConfigDialog_Search);
        firstColumn.setLabelProvider((CellLabelProvider)new ProcessorCategoryLabelProvider(derivatives));
    }

    public static void createProductColumns(@NonNull TreeViewer treeViewer, @NonNull ISupportedDerivativesForSwTools derivatives, @NonNull OnlineDataInfo onlineDataInfo, @Nullable Supplier<String> selectedSdkSupplier) {
        Tree tree = treeViewer.getTree();
        for (SwToolsProduct product : SwToolsProductConfiguration.getRegisteredProductsSorted()) {
            if (product.isHeadless()) continue;
            TreeViewerColumn viewerColumn = new TreeViewerColumn(treeViewer, 0);
            TreeColumn column = viewerColumn.getColumn();
            int index = tree.indexOf(column);
            ColumnCenteredImagePainter listener = new ColumnCenteredImagePainter(index, item -> {
                Object element = item.getData();
                String mcu = null;
                String sdkVersion = null;
                if (element instanceof ITemplateInfo) {
                    ITemplateInfo template = (ITemplateInfo)element;
                    switch (template.getTemplateType()) {
                        case ttTemplate: {
                            return null;
                        }
                        case ttBoard: 
                        case ttKit: {
                            mcu = template.getMasterToolName();
                        }
                    }
                } else if (element instanceof IProcessorMasterToolInfo) {
                    mcu = ((IProcessorMasterToolInfo)element).getId();
                }
                if (mcu != null) {
                    String mcuFinal = mcu;
                    Optional<IProcessorInfo> proc = onlineDataInfo.getOnlineProcessorsWeb().stream().filter(p -> Objects.equals(mcuFinal, p.getName())).findFirst();
                    if (proc.isPresent()) {
                        IProcessorInfo p2 = proc.get();
                        Pattern patt = Pattern.compile("sdk\\.[^.]+\\.tools\\." + product.getProductId().toLowerCase());
                        for (String key : p2.getAttributeKeys()) {
                            Matcher m = patt.matcher(key);
                            if (!m.matches() || !Boolean.parseBoolean(p2.getAttribute(key))) continue;
                            return ToolsImages.getImage((String)"icons/check_simple.png");
                        }
                    } else {
                        if (selectedSdkSupplier != null) {
                            sdkVersion = (String)selectedSdkSupplier.get();
                        }
                        Optional<Object> info = null;
                        if (sdkVersion == null) {
                            info = derivatives.getProcessorMasterToolInfos(mcu).findFirst();
                        } else {
                            String sdkVersionFinal = sdkVersion;
                            info = derivatives.getProcessorMasterToolInfos(mcu).filter(i -> sdkVersionFinal.equals(i.getSWToolsDataFolderID())).findFirst();
                        }
                        if (info.isPresent() && SupportedToolsByProcessor.isToolSuported((IProcessorMasterToolInfo)((IProcessorMasterToolInfo)info.get()), (String)product.getProductId())) {
                            return ToolsImages.getImage((String)"icons/check_simple.png");
                        }
                    }
                    return ToolsImages.getImage((String)"icons/remove_cross_simple.png");
                }
                return null;
            });
            tree.addListener(41, (Listener)listener);
            tree.addListener(42, (Listener)listener);
            tree.addListener(40, (Listener)listener);
            column.setText(product.getProductName());
            viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
            column.pack();
        }
    }

    public static void createStatusColumn(@NonNull TreeViewer treeViewer, final @NonNull ISupportedDerivativesForSwTools derivatives, final @NonNull OnlineDataInfo onlineDataInfo) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(treeViewer, 0);
        TreeColumn column = viewerColumn.getColumn();
        column.setText(Messages.get().ProcessorProvider_StatusColumn);
        column.setWidth(100);
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ProcessorNode) {
                    return null;
                }
                if (ProcessorSelectionContainer.isElementAvailableOffline(element, derivatives)) {
                    return ProcessorSelectionContainer.isUpdateAvailable(element, derivatives, onlineDataInfo) ? Messages.get().ProcessorProvider_StatusColumnUpdateAvailable : Messages.get().ProcessorProvider_StatusColumnCached;
                }
                return Messages.get().ProcessorProvider_StatusColumnOnline;
            }

            public String getToolTipText(Object element) {
                if (element instanceof ProcessorNode) {
                    return null;
                }
                if (ProcessorSelectionContainer.isElementAvailableOffline(element, derivatives)) {
                    return ProcessorSelectionContainer.isUpdateAvailable(element, derivatives, onlineDataInfo) ? Messages.get().ProcessorProvider_StatusColumnUpdateAvailableTooltip : Messages.get().ProcessorProvider_StatusColumnCachedTooltip;
                }
                return Messages.get().ProcessorProvider_StatusColumnOnlineTooltip;
            }
        });
    }

    public static boolean isElementAvailableOffline(@Nullable Object element, @NonNull ISupportedDerivativesForSwTools derivatives) {
        if (element instanceof ITemplateInfo) {
            ITemplateInfo template = (ITemplateInfo)element;
            switch (template.getTemplateType()) {
                case ttTemplate: {
                    return true;
                }
                case ttBoard: {
                    return derivatives.getBoardById(template.getId(), template.getSWToolsDataFolderID()) != null;
                }
                case ttKit: {
                    return derivatives.getKitById(template.getId(), template.getSWToolsDataFolderID()) != null;
                }
            }
            assert (false) : "unsupported template type";
        } else if (element instanceof IProcessorMasterToolInfo) {
            IProcessorMasterToolInfo info = (IProcessorMasterToolInfo)element;
            return derivatives.getProcessorMasterToolInfos(info.getId()).findFirst().isPresent();
        }
        return false;
    }

    public static @Nullable String getOfflineElementVersion(@Nullable Object element, @NonNull ISupportedDerivativesForSwTools derivatives) {
        if (element instanceof ITemplateInfo) {
            ITemplateInfo template = (ITemplateInfo)element;
            switch (template.getTemplateType()) {
                case ttTemplate: {
                    return null;
                }
                case ttBoard: {
                    ITemplateInfo brd = derivatives.getBoardById(template.getId(), template.getSWToolsDataFolderID());
                    if (brd != null) {
                        return brd.getVersion();
                    }
                    return null;
                }
                case ttKit: {
                    ITemplateInfo kit = derivatives.getKitById(template.getId(), template.getSWToolsDataFolderID());
                    if (kit != null) {
                        return kit.getVersion();
                    }
                    return null;
                }
            }
            assert (false) : "unsupported template type";
        } else if (element instanceof IProcessorMasterToolInfo) {
            IProcessorMasterToolInfo info = (IProcessorMasterToolInfo)element;
            Optional<@NonNull String> opt = derivatives.getProcessorMasterToolInfos(info.getId()).map(IProcessorMasterToolInfo::getVersion).findFirst();
            if (opt.isPresent()) {
                return opt.get();
            }
        } else assert (false) : "Unsupported type";
        return null;
    }

    public static boolean isUpdateAvailable(@Nullable Object element, @NonNull ISupportedDerivativesForSwTools derivatives, @NonNull OnlineDataInfo onlineDataInfo) {
        if (element instanceof ITemplateInfo) {
            ITemplateInfo template = (ITemplateInfo)element;
            switch (template.getTemplateType()) {
                case ttTemplate: {
                    return false;
                }
                case ttBoard: {
                    return Objects.nonNull(derivatives.getBoardById(template.getId(), template.getSWToolsDataFolderID())) && KExProcessorsProvider.isBoardUpdateAvailable((String)template.getId(), (String)template.getSWToolsDataFolderID(), (Collection)onlineDataInfo.getOnlineBoardsWeb());
                }
                case ttKit: {
                    return Objects.nonNull(derivatives.getKitById(template.getId(), template.getSWToolsDataFolderID())) && KExProcessorsProvider.isKitUpdateAvailable((String)template.getId(), (String)template.getSWToolsDataFolderID(), (Collection)onlineDataInfo.getOnlineKitsWeb());
                }
            }
            assert (false) : "unsupported template type";
        } else if (element instanceof IProcessorMasterToolInfo) {
            IProcessorMasterToolInfo info = (IProcessorMasterToolInfo)element;
            return derivatives.getProcessorMasterToolInfos(info.getId()).anyMatch(p -> KExProcessorsProvider.isProcessorUpdateAvailable((String)p.getId(), (String)p.getSWToolsDataFolderID(), (Collection)onlineDataInfo.getOnlineProcessorsWeb()));
        }
        return false;
    }

    private static @NonNull Map<String, ITemplateInfo> getSdkMapForTemplate(@NonNull ITemplateInfo template) {
        HashMap<String, ITemplateInfo> result = new HashMap<String, ITemplateInfo>();
        ISharedConfiguration config = ProcessorSelectionContainer.getTemplateMexConfig(template);
        if (config != null) {
            String sdk = config.getCommonConfig().getSdkVersion();
            if (!UtilsText.isEmpty((String)sdk)) {
                String sdkName = UtilsText.safeString((String)SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools().getSwtoolsFolderIDName(sdk));
                result.put(sdk, new TemplateInfoProxy(template, sdk, sdkName));
            }
        } else {
            LOGGER.warning("Cannot read MEX template " + template.getRelFileName());
        }
        return result;
    }

    private @NonNull Collection<@NonNull PackageTriplet> getPackagesForProcessor(@NonNull String mcu, @Nullable String version) {
        ArrayList<@NonNull PackageTriplet> result = new ArrayList<PackageTriplet>();
        if (version == null) {
            return result;
        }
        IProcessorMasterToolInfo info = this.derivatives.getProcessorMasterToolInfo(mcu, version);
        if (info == null) {
            PackageTriplet tr;
            Matcher m = Pattern.compile("^sdk\\." + version + "\\.package\\.[^.]+$").matcher("");
            this.onlineDataInfo.getOnlineProcessorsWeb().stream().filter(p -> mcu.equals(p.getName())).filter(p -> Objects.nonNull(p.getAttribute("sdk." + version + ".default.package"))).findFirst().ifPresent(p -> p.getAttributeKeys().stream().filter(a -> m.reset((CharSequence)a).matches()).sorted((a1, a2) -> a1.compareTo((String)a2)).forEach(a -> {
                String packageName = UtilsText.safeString((String)p.getAttribute(a));
                String packageUiName = p.getAttribute(String.valueOf(a) + ".label");
                packageUiName = packageUiName == null ? packageName : MessageFormat.format(com.nxp.swtools.utils.Messages.get().SelectPackageDialog_package, packageName, packageUiName);
                result.add(new PackageTriplet(mcu, version, packageName, packageUiName, UtilsText.safeString((String)p.getAttribute(a)).equals(p.getAttribute("sdk." + version + ".default.package")), Boolean.valueOf(p.getAttribute("sdk." + version + ".packagex." + packageName + ".requiresNDA")), Boolean.valueOf(p.getAttribute("sdk." + version + ".packagex." + packageName + ".deprecated"))));
            }));
            if (result.size() == 1 && !((Boolean)(tr = result.get(0)).getThird()).booleanValue()) {
                LOGGER.warning("Online processor does not contain default package defined");
                result.set(0, new PackageTriplet(mcu, version, (String)tr.getFirst(), (String)tr.getSecond(), Boolean.TRUE, tr.isRequireNDA(), tr.isDeprecated()));
            }
            if (result.isEmpty()) {
                LOGGER.warning("Online processor does not contain any package defined");
                result.add(new PackageTriplet(mcu, version, DEFAULT_PACKAGE, DEFAULT_PACKAGE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE));
            }
            return result;
        }
        SelectPackageDialog.getAvailablePackagesMap((ISupportedDerivativesForSwTools)this.derivatives, (IProcessorMasterToolInfo)info).entrySet().stream().map(map -> new PackageTriplet(mcu, version, (String)map.getValue(), (String)map.getKey(), info.getDefaultPartNumber().equals(map.getValue()), SWToolsPlatform.isPartRequiresNDA((String)mcu, (String)version, (String)((String)map.getValue()), (ISupportedDerivativesForSwTools)this.derivatives), SWToolsPlatform.isPartDeprecated((String)mcu, (String)version, (String)((String)map.getValue()), (ISupportedDerivativesForSwTools)this.derivatives))).forEach(result::add);
        return result;
    }

    private void clearSelection() {
        this.selectedMcu.setValue((Object)"");
        this.selectedBoard.setValue((Object)"");
        this.selectedKit.setValue((Object)"");
        this.selectedTemplate.setValue((Object)"");
        this.sdkVersion.setValue(null);
        this.sdkVersions.clear();
        this.selectedPackage.setValue(null);
        this.packages.clear();
        this.cores.clear();
        this.cores.add((Object)CORE_NOT_SELECTED);
        this.selectedCore.setValue(null);
        this.canFinishCallback.accept(Boolean.FALSE);
    }

    private void fireFinishDialog() {
        this.doFinishCallback.accept(Boolean.TRUE);
    }

    private void createSdkVersionSelectionPart(Composite container) {
        ProcessorMergeHelper helper = new ProcessorMergeHelper(this.derivatives, this.onlineDataInfo);
        if (!this.isVersionComboVisibleForOneOption() && helper.getAllSdks().size() == 1) {
            return;
        }
        Label sdkLabel = new Label(container, 0);
        sdkLabel.setText(Messages.get().NewConfigDialog_SelectVersionCombo);
        CCombo sdkVersionCombo = new CCombo(container, 2056);
        sdkVersionCombo.addListener(24, e -> this.processorFT.getViewer().getTree().redraw());
        ProcessorSelectionContainer.fixCComboBackGround((Composite)sdkVersionCombo);
        ComboViewer cv = new ComboViewer(sdkVersionCombo);
        cv.setContentProvider((IContentProvider)new ObservableListContentProvider());
        cv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ISWToolsDataFolderInfo) {
                    ISWToolsDataFolderInfo info = (ISWToolsDataFolderInfo)element;
                    return info.getSWToolsDataFolderName();
                }
                return super.getText(element);
            }
        });
        cv.setInput(this.sdkVersions);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).hint(280, -1).applyTo((Control)sdkVersionCombo);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)sdkVersionCombo, "NewConfigurationSDK");
        IViewerObservableValue targetCombo = ViewerProperties.singleSelection().observe((Viewer)cv);
        this.ctx.bindValue((IObservableValue)targetCombo, this.sdkVersion);
    }

    private void createNamePart(@NonNull Composite container) {
        Label name = new Label(container, 0);
        name.setText(Messages.get().NewConfigDialog_ConfigName);
        GridData dataFirstName = new GridData();
        dataFirstName.grabExcessHorizontalSpace = true;
        dataFirstName.horizontalAlignment = 4;
        dataFirstName.verticalAlignment = 4;
        Text configName = new Text(container, 2048);
        configName.setLayoutData((Object)dataFirstName);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)configName, "NewConfigurationNameText");
        ISWTObservableValue target = WidgetProperties.text((int)24).observe((Widget)configName);
        this.ctx.bindValue((IObservableValue)target, this.configurationName);
        configName.addListener(24, event -> {
            Object mcuValue = this.selectedMcu.getValue();
            Object boardValue = this.selectedBoard.getValue();
            Object kitValue = this.selectedKit.getValue();
            Object templValue = this.selectedTemplate.getValue();
            boolean isBoardSelected = !UtilsText.isEmpty((String)((String)boardValue)) && boardValue != null;
            boolean isMcuSelected = !UtilsText.isEmpty((String)((String)mcuValue)) && mcuValue != null;
            boolean isKitSelected = !UtilsText.isEmpty((String)((String)kitValue)) && kitValue != null;
            boolean isTemplateSelected = !UtilsText.isEmpty((String)((String)templValue)) && templValue != null;
            this.canFinishCallback.accept(!configName.getText().isEmpty() && (isBoardSelected || isMcuSelected || isKitSelected || isTemplateSelected));
        });
        configName.addListener(25, event -> {
            char[] chars = INVALID_RESOURCE_CHARACTERS;
            int i = 0;
            while (i < chars.length) {
                if (chars[i] == event.character) {
                    event.doit = false;
                    break;
                }
                ++i;
            }
        });
        if (this.switchingProcessor) {
            String previousConfigName = UtilsText.safeString((String)SWToolsPlatform.getSharedConfigurationSingleton().getCommonConfig().getName());
            configName.setText(previousConfigName);
        }
    }

    private void createPackagePart(@Nullable Composite container) {
        Label packagesLabel = new Label(container, 0);
        packagesLabel.setText(com.nxp.swtools.utils.Messages.get().SelectPackageDialog_SelectProcessorPackage);
        CCombo packagesCombo = new CCombo(container, 2056);
        ProcessorSelectionContainer.fixCComboBackGround((Composite)packagesCombo);
        ComboViewer cv = new ComboViewer(packagesCombo);
        cv.setContentProvider((IContentProvider)new ObservableListContentProvider());
        cv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof PackageTriplet) {
                    PackageTriplet triplet = (PackageTriplet)((Object)element);
                    if (triplet.isRequireNDA().booleanValue() || triplet.isDeprecated().booleanValue()) {
                        ArrayList<@NonNull String> flags = new ArrayList<String>();
                        if (triplet.isRequireNDA().booleanValue()) {
                            flags.add(Messages.get().ProcessorSelectionContainer_NDA);
                        }
                        if (triplet.isDeprecated().booleanValue()) {
                            flags.add(Messages.get().ProcessorSelectionContainer_Deprecated);
                        }
                        return String.valueOf((String)triplet.getSecond()) + " (" + UtilsText.join(flags, (String)",") + ")";
                    }
                    return (String)triplet.getSecond();
                }
                return Objects.toString(element);
            }
        });
        cv.setInput(this.packages);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).hint(280, -1).applyTo((Control)packagesCombo);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)packagesCombo, "NewConfigurationPackage");
        IViewerObservableValue targetCombo = ViewerProperties.singleSelection().observe((Viewer)cv);
        this.ctx.bindValue((IObservableValue)targetCombo, this.selectedPackage);
        ISWTObservableValue targetComboEnablement = WidgetProperties.enabled().observe((Widget)packagesCombo);
        IObservableValue modelEnablement = ComputedValue.create(() -> !UtilsText.isEmpty((String)this.getSelectedMcu()) && UtilsText.isEmpty((String)this.getSelectedBoard()) && UtilsText.isEmpty((String)this.getSelectedKit()));
        this.ctx.bindValue((IObservableValue)targetComboEnablement, modelEnablement);
        ISWTObservableValue targetLabelEnablement = WidgetProperties.enabled().observe((Widget)packagesLabel);
        this.ctx.bindValue((IObservableValue)targetLabelEnablement, modelEnablement);
    }

    private void createCoreSelectionPart(@NonNull Composite container) {
        Label packagesLabel = new Label(container, 0);
        packagesLabel.setText(Messages.get().NewConfigDialog_SelectCore_Label);
        CCombo coresCombo = new CCombo(container, 2056);
        ProcessorSelectionContainer.fixCComboBackGround((Composite)coresCombo);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)coresCombo, "NewConfigurationCore");
        ComboViewer cv = new ComboViewer(coresCombo);
        cv.setContentProvider((IContentProvider)new ObservableListContentProvider());
        cv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ProcessorCore) {
                    ProcessorCore core = (ProcessorCore)element;
                    return core.getName();
                }
                return Objects.toString(element);
            }
        });
        cv.setInput(this.cores);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).hint(280, -1).applyTo((Control)coresCombo);
        IViewerObservableValue targetCombo = ViewerProperties.singleSelection().observe((Viewer)cv);
        this.ctx.bindValue((IObservableValue)targetCombo, this.selectedCore);
        ISWTObservableValue targetComboEnablement = WidgetProperties.enabled().observe((Widget)coresCombo);
        IObservableValue modelEnablement = ComputedValue.create(() -> !UtilsText.isEmpty((String)this.getSelectedMcu()) || !UtilsText.isEmpty((String)this.getSelectedBoard()) || !UtilsText.isEmpty((String)this.getSelectedKit()));
        this.ctx.bindValue((IObservableValue)targetComboEnablement, modelEnablement);
        ISWTObservableValue targetLabelEnablement = WidgetProperties.enabled().observe((Widget)packagesLabel);
        this.ctx.bindValue((IObservableValue)targetLabelEnablement, modelEnablement);
    }

    private static void fixCComboBackGround(@NonNull Composite combo) {
        combo.setBackground(combo.getDisplay().getSystemColor(25));
    }

    private void createPackageCodeSdkVersionPart(@NonNull Composite container) {
        Composite panel = new Composite(container, 0);
        panel.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(true).margins(0, 0).create());
        panel.setLayoutData((Object)new GridData(4, 1024, true, false));
        Composite firstCol = new Composite(panel, 0);
        firstCol.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).create());
        firstCol.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createPackagePart(firstCol);
        Composite secondCol = new Composite(panel, 0);
        if (!this.switchingProcessor) {
            secondCol.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).create());
            secondCol.setLayoutData((Object)new GridData(4, 4, true, false));
            this.createCoreSelectionPart(secondCol);
        }
        Composite thirdCol = new Composite(panel, 0);
        thirdCol.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).create());
        thirdCol.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createSdkVersionSelectionPart(thirdCol);
    }

    boolean isVersionComboVisibleForOneOption() {
        return !SWToolsProperties.isPropertyTrue((String)"com.nxp.swtools.framework.hide.sdk.version");
    }

    public boolean isTemplateVisible(@NonNull ITemplateInfo template) {
        if (!this.createFromTemplateAllowed) {
            return false;
        }
        if (template.getTemplateType() != ITemplateInfo.TemplateType.ttTemplate) {
            return this.createFromTemplateAllowed;
        }
        return true;
    }

    private static @Nullable ISharedConfiguration getTemplateMexConfig(@NonNull ITemplateInfo template) {
        assert (template.getTemplateType() == ITemplateInfo.TemplateType.ttTemplate) : "allowed only for user templates";
        File preSetMex = new File(String.valueOf(SupportedDerivativesForSwTools.getUserTemplatesDir()) + File.separator + template.getRelFileName());
        return ConfigurationUtils.loadConfigurationFromFile((File)preSetMex);
    }

    public void setCreateFromTemplateAllowed(boolean value) {
        this.createFromTemplateAllowed = value;
    }

    public @NonNull IProcessorSelectionContainer getImmutableSelection() {
        final String mcuValue = this.getSelectedMcu();
        final String boardValue = this.getSelectedBoard();
        final String kitValue = this.getSelectedKit();
        final String templateValue = this.getSelectedTemplate();
        final String configurationNameValue = this.getConfigurationName();
        final Object sdkVal = this.getSelectedSdkVersion();
        final String sdk = this.getSelectedSdk();
        final String selPackage = this.getSelectedPackage();
        final ProcessorCore selCore = this.getSelectedCore();
        return new IProcessorSelectionContainer(){

            @Override
            public boolean isSwitchingProcessor() {
                return ProcessorSelectionContainer.this.switchingProcessor;
            }

            @Override
            public @Nullable String getSelectedTemplate() {
                return templateValue;
            }

            @Override
            public @Nullable Object getSelectedSdkVersion() {
                return sdkVal;
            }

            @Override
            public @Nullable String getSelectedSdk() {
                return sdk;
            }

            @Override
            public @Nullable String getSelectedMcu() {
                return mcuValue;
            }

            @Override
            public @Nullable String getSelectedKit() {
                return kitValue;
            }

            @Override
            public @Nullable String getSelectedBoard() {
                return boardValue;
            }

            @Override
            public @Nullable String getConfigurationName() {
                return configurationNameValue;
            }

            @Override
            public @Nullable String getSelectedPackage() {
                return selPackage;
            }

            @Override
            public @Nullable ProcessorCore getSelectedCore() {
                return selCore;
            }

            @Override
            public @NonNull OnlineDataInfo getOnlineDataInfo() {
                return ProcessorSelectionContainer.this.onlineDataInfo;
            }
        };
    }

    @Override
    public @Nullable String getSelectedSdk() {
        Object sdkVal = this.getSelectedSdkVersion();
        if (sdkVal instanceof ISWToolsDataFolderInfo) {
            ISWToolsDataFolderInfo sdkInfo = (ISWToolsDataFolderInfo)sdkVal;
            return sdkInfo.getSWToolsDataFolderID();
        }
        return null;
    }

    public @NonNull FilteredTree getTree() {
        assert (this.processorFT != null);
        return this.processorFT;
    }

    public void setSearchTitle() {
        String text = this.switchingProcessor ? Messages.get().NewConfigDialog_SearchForSwitch : Messages.get().NewConfigDialog_Search;
        this.searchLabel.setText(text);
    }

    @Override
    public @NonNull OnlineDataInfo getOnlineDataInfo() {
        return this.onlineDataInfo;
    }

    @NonNullByDefault
    static class PackageTriplet
    extends Triplet<String, String, Boolean> {
        private String sdkVersion;
        private String mcu;
        private Boolean requireNDA;
        private Boolean deprecated;

        public PackageTriplet(String mcu, String sdkVersion, String aPackage, String uiText, Boolean defaultPackage, Boolean requiresNDA, Boolean deprecated) {
            super((Object)aPackage, (Object)uiText, (Object)defaultPackage);
            this.mcu = mcu;
            this.sdkVersion = sdkVersion;
            this.requireNDA = requiresNDA;
            this.deprecated = deprecated;
        }

        public String getSdkVersion() {
            return this.sdkVersion;
        }

        public String getMcu() {
            return this.mcu;
        }

        public Boolean isRequireNDA() {
            return this.requireNDA;
        }

        public Boolean isDeprecated() {
            return this.deprecated;
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + Objects.hash(this.deprecated, this.mcu, this.requireNDA, this.sdkVersion);
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof PackageTriplet)) {
                return false;
            }
            PackageTriplet other = (PackageTriplet)((Object)obj);
            if (!Objects.equals(this.deprecated, other.deprecated)) {
                return false;
            }
            if (!Objects.equals(this.mcu, other.mcu)) {
                return false;
            }
            if (!Objects.equals(this.requireNDA, other.requireNDA)) {
                return false;
            }
            return Objects.equals(this.sdkVersion, other.sdkVersion);
        }
    }

    static class ProcessorPatternFilter
    extends PatternFilter {
        ProcessorPatternFilter() {
        }

        protected boolean isEndLeaf(@NonNull Viewer viewer, @NonNull Object element) {
            Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
            return Objects.isNull(children) || children.length == 0;
        }

        protected boolean isNodeNotForFinish(Object element) {
            return element instanceof ProcessorNode;
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            assert (viewer != null);
            assert (element != null);
            return this.isEndLeaf(viewer, element) && super.isLeafMatch(viewer, element) && !this.isNodeNotForFinish(element);
        }
    }

    static class TemplateInfoProxy
    implements ITemplateInfo {
        @NonNull
        private ITemplateInfo template;
        @NonNull
        private String sdk;
        @NonNull
        private String sdkName;

        public TemplateInfoProxy(@NonNull ITemplateInfo template, @NonNull String sdk, @NonNull String sdkName) {
            this.template = template;
            this.sdk = sdk;
            this.sdkName = sdkName;
        }

        public @NonNull String getSWToolsDataFolderID() {
            return this.sdk;
        }

        public @NonNull String getSWToolsDataFolderName() {
            return this.sdkName;
        }

        public @NonNull String getId() {
            return this.template.getId();
        }

        public @NonNull String getRelFileName() {
            return this.template.getRelFileName();
        }

        public @NonNull String getMasterToolName() {
            return this.template.getMasterToolName();
        }

        public @NonNull String getVersion() {
            return this.template.getVersion();
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull ITemplateInfo.TemplateType getTemplateType() {
            return this.template.getTemplateType();
        }
    }
}

