/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.ui.newconfig.containers;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.framework.ui.newconfig.ProcessorNode;
import com.nxp.swtools.provider.SWToolsPlatform;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.jface.viewers.ColumnLabelProvider;

@NonNullByDefault
public class ProcessorCategoryLabelProvider
extends ColumnLabelProvider {
    private ISupportedDerivativesForSwTools derivatives;

    public ProcessorCategoryLabelProvider(ISupportedDerivativesForSwTools derivatives) {
        this.derivatives = derivatives;
    }

    public @NonNull String getText(Object element) {
        if (element instanceof ProcessorNode) {
            ProcessorNode node = (ProcessorNode)element;
            return node.getName();
        }
        if (element instanceof ITemplateInfo) {
            ITemplateInfo template = (ITemplateInfo)element;
            if (template.getTemplateType() == ITemplateInfo.TemplateType.ttTemplate) {
                return template.getId();
            }
            return MessageFormat.format(Messages.get().ProcessorSelectionContainer_NewConfigurationLabel, template.getId());
        }
        if (element instanceof IProcessorMasterToolInfo) {
            IProcessorMasterToolInfo mcu = (IProcessorMasterToolInfo)element;
            boolean deprecated = SWToolsPlatform.isMcuDeprecated((IProcessorMasterToolInfo)mcu, (ISupportedDerivativesForSwTools)this.derivatives);
            boolean requiresNDA = SWToolsPlatform.isMcuRequiresNDA((IProcessorMasterToolInfo)mcu, (ISupportedDerivativesForSwTools)this.derivatives);
            if (deprecated || requiresNDA) {
                ArrayList<String> flags = new ArrayList<String>();
                if (requiresNDA) {
                    flags.add(Messages.get().ProcessorSelectionContainer_NDA);
                }
                if (deprecated) {
                    flags.add(Messages.get().ProcessorSelectionContainer_Deprecated);
                }
                return MessageFormat.format(Messages.get().ProcessorSelectionContainer_NewConfigurationLabelExtra, mcu.getId(), UtilsText.join(flags, (String)","));
            }
            return MessageFormat.format(Messages.get().ProcessorSelectionContainer_NewConfigurationLabel, mcu.getId());
        }
        if (Objects.isNull(element)) {
            assert (false);
            return "";
        }
        return Objects.toString(element);
    }
}

