/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.ui.newconfig;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.ArraysUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.framework.ui.newconfig.ProcessorMergeHelper;
import com.nxp.swtools.framework.ui.newconfig.ProcessorNode;
import com.nxp.swtools.provider.processors.OnlineDataInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ProcessorProvider
implements ITreeContentProvider {
    @Nullable
    ISupportedDerivativesForSwTools derivatives;
    @NonNull
    OnlineDataInfo onlineDataInfo;
    @NonNull
    private @NonNull Object @NonNull [] rootElements = new Object[0];
    private boolean isBoardIncluded = true;
    @NonNull
    @NonNull Predicate<@NonNull String> processorFilter = b -> true;
    @NonNull
    @NonNull Predicate<@NonNull String> boardKitFilter = b -> true;
    @NonNull
    @NonNull Predicate<? super @NonNull ITemplateInfo> showBoardOrKitTemplate = b -> true;

    public ProcessorProvider(@NonNull OnlineDataInfo onlineDataInfo, @Nullable Predicate<@NonNull String> processorFilter, @Nullable Predicate<@NonNull String> boardKitFilter, @Nullable Predicate<? super @NonNull ITemplateInfo> showBoardOrKitTemplate) {
        this.onlineDataInfo = onlineDataInfo;
        if (processorFilter != null) {
            this.processorFilter = processorFilter;
        }
        if (boardKitFilter != null) {
            this.boardKitFilter = boardKitFilter;
        }
        if (showBoardOrKitTemplate != null) {
            this.showBoardOrKitTemplate = showBoardOrKitTemplate;
        }
    }

    public void setIsBoardIncluded(boolean isBoardIncluded) {
        this.isBoardIncluded = isBoardIncluded;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.derivatives = (ISupportedDerivativesForSwTools)newInput;
        if (newInput == null) {
            this.rootElements = new Object[0];
            return;
        }
        ISupportedDerivativesForSwTools der = this.derivatives;
        assert (der != null);
        ProcessorNode processors = new ProcessorNode(UtilsText.safeString((String)Messages.get().ProcessorProvider_ProcessorsNode));
        processors.setChildrenSupplier(() -> this.getProcessors());
        ProcessorNode boards = new ProcessorNode(UtilsText.safeString((String)Messages.get().ProcessorProvider_BoardsNode));
        boards.setChildrenSupplier(() -> this.getBoards());
        ProcessorNode kits = new ProcessorNode(UtilsText.safeString((String)Messages.get().ProcessorProvider_KitsNode));
        kits.setChildrenSupplier(() -> this.getKits());
        ProcessorNode templates = new ProcessorNode(UtilsText.safeString((String)Messages.get().ProcessorProvider_TemplatesNode));
        templates.setChildrenSupplier(() -> this.getTemplates());
        this.rootElements = this.onlineDataInfo.getOnlineBoards().isEmpty() && der.getAllBoardsInfos().isEmpty() || !this.isBoardIncluded ? new Object[]{processors} : new Object[]{templates, kits, boards, processors};
    }

    public Object[] getElements(Object inputElement) {
        return Arrays.stream(this.rootElements).filter(o -> this.hasChildren(o)).toArray();
    }

    protected Object @NonNull [] getProcessors() {
        ISupportedDerivativesForSwTools der = this.derivatives;
        if (der != null) {
            ProcessorMergeHelper helper = new ProcessorMergeHelper(der, this.onlineDataInfo);
            Collection<String> series = helper.getAllSeries(this.processorFilter);
            return series.stream().map(i -> new ProcessorNode((String)i, (String)i, () -> this.getSeriesProcessors((String)i))).sorted().toArray();
        }
        return new Object[0];
    }

    protected Object @NonNull [] getBoards() {
        ISupportedDerivativesForSwTools der = this.derivatives;
        if (der != null) {
            ProcessorMergeHelper helper = new ProcessorMergeHelper(der, this.onlineDataInfo);
            Collection<ITemplateInfo> allboards = helper.getAllBoardsFilteredById();
            return allboards.stream().filter(b -> this.boardKitFilter.test(b.getId())).sorted((b1, b2) -> b1.getId().compareTo(b2.getId())).toArray();
        }
        return new Object[0];
    }

    protected Object @NonNull [] getKits() {
        ISupportedDerivativesForSwTools der = this.derivatives;
        if (der != null) {
            ProcessorMergeHelper helper = new ProcessorMergeHelper(der, this.onlineDataInfo);
            Collection<ITemplateInfo> allkits = helper.getAllKitsFilteredById();
            return allkits.stream().filter(b -> this.boardKitFilter.test(b.getId())).sorted((b1, b2) -> b1.getId().compareTo(b2.getId())).toArray();
        }
        return new Object[0];
    }

    protected @NonNull Object @NonNull [] getTemplates() {
        ISupportedDerivativesForSwTools der = this.derivatives;
        assert (der != null);
        return der.getAllTemplatesInfos().stream().filter(t -> this.showBoardOrKitTemplate.test((ITemplateInfo)t)).toArray();
    }

    Object @NonNull [] getSeriesProcessors(@NonNull String series) {
        ISupportedDerivativesForSwTools der = this.derivatives;
        assert (der != null);
        ProcessorMergeHelper helper = new ProcessorMergeHelper(der, this.onlineDataInfo);
        return helper.getMasterToolsForSeriesFilteredById(series).stream().filter(i -> this.processorFilter.test(i.getId())).sorted((a, b) -> a.getId().compareTo(b.getId())).toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ProcessorNode) {
            ProcessorNode node = (ProcessorNode)parentElement;
            return node.getChildren();
        }
        return new Object[0];
    }

    public static @NonNull String firstSegmentOfPath(@NonNull String path) {
        int p = path.indexOf(47);
        return p > 0 ? path.substring(0, p) : path;
    }

    public static @NonNull String withoutFirstSegmentOfPath(@NonNull String path) {
        int p = path.indexOf(47);
        return p > 0 ? path.substring(p + 1) : path;
    }

    public Object getParent(Object element) {
        if (Objects.isNull(element)) {
            return null;
        }
        return this.findParentForElement(this.rootElements, element, null);
    }

    private @Nullable Object findParentForElement(@NonNull Object @Nullable [] array, @NonNull Object element, @Nullable Object parentElement) {
        if (array == null || array.length == 0) {
            return null;
        }
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (element.equals(o)) {
                return parentElement;
            }
            Object[] arr = this.getChildren(o);
            Object res = this.findParentForElement(arr, element, o);
            if (res != null) {
                return res;
            }
            ++n2;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ProcessorNode) {
            return !ArraysUtils.isEmpty((Object[])this.getChildren(element));
        }
        if (element instanceof ITemplateInfo) {
            return !ArraysUtils.isEmpty((Object[])this.getChildren(element));
        }
        return false;
    }
}

