/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.ui.newconfig;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.runtime.ExecutableExtensionProvider;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.PEConfiguration;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.logging.UserLogger;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.framework.ui.newconfig.IWizardPageProvider;
import com.nxp.swtools.framework.ui.newconfig.NewConfigWizardPage;
import com.nxp.swtools.framework.ui.newconfig.NewConfigurationModePage;
import com.nxp.swtools.framework.ui.newconfig.NewConfigurationProcessorPage;
import com.nxp.swtools.framework.ui.newconfig.WizardData;
import com.nxp.swtools.framework.ui.newconfig.containers.IProcessorSelectionContainer;
import com.nxp.swtools.kex.api.IProcessorInfo;
import com.nxp.swtools.kex.selector.IMcuSelection;
import com.nxp.swtools.kex.selector.IMcuSelectionWritable;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.change.DefaultConfigChangeContextHelper;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.processors.DownloadStatus;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.ImportToolchainProjectFactory;
import com.nxp.swtools.sdkproject.ToolchainProjectFactory;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.processors.ProcessorDataUpdateUI;
import com.nxp.swtools.utils.tools.Tools;
import com.nxp.swtools.utils.undo.UndoRedoConfig;
import com.nxp.swtools.utils.wizards.KExWizard;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewConfigWizard
extends KExWizard
implements INewWizard {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(NewConfigWizard.class);
    @Nullable
    protected NewConfigurationProcessorPage configurationProcessorPage;
    @NonNull
    protected final WizardData wizardData;
    @NonNull
    protected @NonNull Map<@NonNull String, @NonNull IWizardPageProvider> pageProviders = new HashMap<String, IWizardPageProvider>();
    @Nullable
    protected final UserLogger userLogger;
    public boolean showDashboard;

    public NewConfigWizard(@NonNull WizardData.WizardType wizardType) {
        this.wizardData = new WizardData(wizardType, SharedConfigurationFactory.createSharedConfiguration());
        this.setWindowTitle(this.getWindowTitleForWizardType());
        this.setNeedsProgressMonitor(true);
        this.userLogger = UserLogger.getInstance();
        this.readPageProviders();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    void log2Ui(@NonNull Shell shell, Level level, @Nullable String msg) {
        if (msg == null) {
            assert (false);
            return;
        }
        UserLogger usrLogger = this.userLogger;
        if (usrLogger != null) {
            shell.getDisplay().asyncExec(() -> usrLogger.log(level, msg));
        }
    }

    void logInfo2Ui(@NonNull Shell shell, @Nullable String msg) {
        this.log2Ui(shell, Level.INFO, msg);
    }

    private boolean importToolchainProject(@NonNull Shell shell, @NonNull ISharedConfiguration sharedConfig, @NonNull SubMonitor monitor) {
        Path path;
        try {
            path = Paths.get(this.wizardData.getPath(), new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            ConfigurationUtils.logAndShowError((Shell)shell, (String)Messages.get().DlgModeSelection_ErrPathIsInavalid, null);
            return false;
        }
        monitor.worked(5);
        SubMonitor subSdkPrjMonitor = monitor.newChild(20, 0);
        assert (subSdkPrjMonitor != null);
        IToolchainProjectWithSdk prj = ToolchainProjectFactory.createToolchainProjectForImport((Path)path, (IProgressMonitor)subSdkPrjMonitor);
        if (!prj.wasProjectDetected()) {
            String msg = String.valueOf(Messages.get().DlgModeSelection_ErrNoToolchainPrjDetected) + " " + UtilsText.safeString((String)prj.getProjectDetectionProblem()) + "\n" + "\n" + com.nxp.swtools.sdkproject.Messages.get().SdkProject_TextSupportedToolchainsAre;
            ConfigurationUtils.logAndShowError((Shell)shell, (String)msg, null);
            return false;
        }
        subSdkPrjMonitor.done();
        String mexFilePath = ImportToolchainProjectFactory.getExistingMexPathForProject((String)this.wizardData.getPath());
        AtomicBoolean openMex = new AtomicBoolean(false);
        AtomicBoolean cancel = new AtomicBoolean(false);
        if (mexFilePath != null) {
            if (SWToolsProperties.isHeadlessOn()) {
                openMex.set(true);
            } else {
                String mexFileName = UtilsFile.getFileNameWithExtension((String)mexFilePath);
                shell.getDisplay().syncExec(() -> {
                    String questMsg = String.format(Messages.get().NewConfigWizard_QuestionToOpenMexInsteadImportSources, mexFileName);
                    String title = com.nxp.swtools.common.ui.utils.Messages.get().MessageBoxDialog_Question;
                    String button1Caption = Messages.get().NewConfigWizard_OpenTheConfiguration_Button;
                    String button2Caption = Messages.get().NewConfigWizard_ImportFromSources_Button;
                    MessageDialog dialog = new MessageDialog(shell, title, null, questMsg, 3, 0, new String[]{button1Caption, button2Caption});
                    int res = dialog.open();
                    switch (res) {
                        case 0: {
                            openMex.set(true);
                            break;
                        }
                        case 1: {
                            openMex.set(false);
                            break;
                        }
                        default: {
                            assert (false);
                        }
                        case -1: {
                            cancel.set(true);
                        }
                    }
                });
                if (cancel.get()) {
                    return false;
                }
            }
        } else {
            mexFilePath = String.valueOf(this.wizardData.getPath()) + File.separator + prj.getProjectName() + ".mex";
        }
        if (openMex.get()) {
            monitor.setTaskName(UtilsText.safeString((String)Messages.get().DlgModeSelection_RadioOpenExistingMex));
            AtomicBoolean result = new AtomicBoolean(false);
            SubMonitor subImport = monitor.newChild(75, 0);
            assert (subImport != null);
            assert (mexFilePath != null);
            IRunnableWithProgress runnable = ConfigurationUtils.createRunnableToOpenConfiguration((Shell)shell, (String)mexFilePath, null, (ConfigurationUtils.OpenAction)ConfigurationUtils.OpenAction.OPEN_INSTEAD_IMPORT, (AtomicBoolean)result);
            try {
                runnable.run((IProgressMonitor)subImport);
            }
            catch (InterruptedException | InvocationTargetException e) {
                result.set(false);
                LOGGER.log(Level.SEVERE, "Failed to open selected configuration", e);
            }
            monitor.done();
        } else {
            this.logInfo2Ui(shell, String.valueOf(Messages.get().ImportToolchainProject_LogImportProject) + this.wizardData.getPath());
            SubMonitor subImport = monitor.newChild(60, 0);
            assert (subImport != null);
            ISharedConfiguration importedSharedCfg = SharedConfigurationFactory.createSharedConfiguration();
            String failMsg = ImportToolchainProjectFactory.importToolchainProject((Shell)shell, (ISharedConfiguration)importedSharedCfg, (IToolchainProjectWithSdk)prj, (boolean)false, (IProgressMonitor)subImport);
            if (failMsg != null) {
                this.log2Ui(shell, Level.SEVERE, Messages.get().ImportToolchainProject_ErrImportFailed);
                ConfigurationUtils.logAndShowError((Shell)shell, (String)failMsg, null);
                SharedConfigurationFactory.clearSharedConfig((ISharedConfiguration)sharedConfig);
                return false;
            }
            Tools.disableUnconfiguredTools((ISharedConfiguration)importedSharedCfg);
            subImport.done();
            monitor.worked(5);
            StringBuilder logMsg = new StringBuilder();
            boolean res = ImportToolchainProjectFactory.saveMexAfterProjectImport((ISharedConfiguration)importedSharedCfg, (ISharedConfiguration)sharedConfig, (String)mexFilePath, (Shell)shell, (StringBuilder)logMsg);
            if (logMsg.length() > 0) {
                this.logInfo2Ui(shell, logMsg.toString());
            }
            if (!res) {
                return false;
            }
            monitor.worked(10);
        }
        return true;
    }

    public boolean performFinish() {
        Shell shell = this.getShell();
        assert (shell != null);
        NewConfigurationProcessorPage confPageLoc = this.configurationProcessorPage;
        assert (confPageLoc != null);
        AtomicBoolean result = new AtomicBoolean(false);
        try {
            ISharedConfiguration sharedConfig = SWToolsPlatform.getSharedConfigurationSingleton();
            IProcessorSelectionContainer immutableSelection = this.wizardData.getMode().selectBoardProcessor() ? confPageLoc.getSelectionContainer().getImmutableSelection() : null;
            String taskName = this.wizardData.getMode().getUiCaption();
            this.getContainer().run(true, false, monitor -> {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)taskName, (int)100);
                assert (sub != null);
                boolean preFinishResult = this.performPreFinishContributors(sub);
                if (preFinishResult) {
                    switch (this.wizardData.getMode()) {
                        case CREATE_NEW_CFG: 
                        case SWITCH_PROCESSOR: {
                            assert (immutableSelection != null);
                            boolean createUndoPoint = this.wizardData.wizardType.equals((Object)WizardData.WizardType.SWITCHING_PROCESSOR);
                            if (createUndoPoint) {
                                UndoRedoConfig.startUndoPointForMultiOp((ISharedConfiguration)sharedConfig, (String)taskName);
                            }
                            result.set(NewConfigWizard.createConfiguration(shell, immutableSelection, this.wizardData, sharedConfig, (IProgressMonitor)sub));
                            shell.getDisplay().syncExec(() -> {
                                sharedConfig.setDirty(DefaultConfigChangeContextHelper.processorChanged((ISharedConfiguration)sharedConfig, (String)taskName));
                                if (!createUndoPoint) {
                                    UndoRedoConfig.clearUndoHistory((ISharedConfiguration)sharedConfig);
                                }
                            });
                            if (!createUndoPoint) break;
                            UndoRedoConfig.finishUndoPointForMultiOp((ISharedConfiguration)sharedConfig);
                            break;
                        }
                        case IMPORT_TOOLCHAIN_PROJECT: 
                        case CLONE_EXAMPLE: {
                            result.set(this.importToolchainProject(shell, sharedConfig, sub));
                            break;
                        }
                        case OPEN_EXISTING_CFG: {
                            this.logInfo2Ui(shell, String.valueOf(Messages.get().NewConfigWizard_LogReOpenPrevMex) + this.wizardData.getPath());
                            IRunnableWithProgress runnable = ConfigurationUtils.createRunnableToOpenConfiguration((Shell)shell, (String)this.wizardData.getPath(), null, (ConfigurationUtils.OpenAction)ConfigurationUtils.OpenAction.OPEN_CMD, (AtomicBoolean)result);
                            runnable.run((IProgressMonitor)sub);
                            break;
                        }
                        default: {
                            assert (false);
                            result.set(false);
                        }
                    }
                }
                if (result.get()) {
                    boolean res = this.performFinishContributors(sub);
                    result.set(res);
                }
                sub.done();
                if (!result.get()) {
                    SharedConfigurationFactory.clearSharedConfig((ISharedConfiguration)sharedConfig);
                } else if ((this.wizardData.getMode() == WizardData.Mode.CREATE_NEW_CFG || this.wizardData.getMode() == WizardData.Mode.IMPORT_TOOLCHAIN_PROJECT || this.wizardData.getMode() == WizardData.Mode.CLONE_EXAMPLE) && Tools.getTools().size() > 1) {
                    this.showDashboard = true;
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
        return result.get();
    }

    private @NonNull String getWindowTitleForWizardType() {
        String title;
        switch (this.wizardData.wizardType) {
            case NEW_CONFIGURATION: {
                title = Messages.get().NewConfigDialog_Title;
                break;
            }
            case STARTUP: {
                title = Messages.get().NewConfigDialog_TitleForStartup;
                break;
            }
            case SWITCHING_PROCESSOR: {
                title = Messages.get().NewConfigDialog_TitleForSwitch;
                break;
            }
            default: {
                assert (false);
                title = null;
            }
        }
        return UtilsText.safeString((String)title);
    }

    public void addPages() {
        super.addPages();
        if (!SwToolsProduct.isUctProduct()) {
            NewConfigurationModePage modePageLoc = new NewConfigurationModePage(this.wizardData);
            if (!this.wizardData.wizardType.equals((Object)WizardData.WizardType.SWITCHING_PROCESSOR)) {
                this.addPage((IWizardPage)modePageLoc);
            } else {
                this.wizardData.setMode(WizardData.Mode.SWITCH_PROCESSOR);
            }
        }
        String title = this.getWindowTitleForWizardType();
        NewConfigurationProcessorPage processorPageLoc = this.configurationProcessorPage = new NewConfigurationProcessorPage(title, this.wizardData);
        processorPageLoc.selectionContainer.setSwitchingProcessor(this.wizardData.wizardType.equals((Object)WizardData.WizardType.SWITCHING_PROCESSOR));
        this.addPage((IWizardPage)processorPageLoc);
        this.createPagesFromProviders();
    }

    static boolean createConfiguration(@NonNull Shell shell, @NonNull IProcessorSelectionContainer selectionContainer, @NonNull WizardData wizardData, @NonNull ISharedConfiguration targetConfig, @NonNull IProgressMonitor monitor) {
        ITemplateInfo template;
        DownloadStatus status;
        Object masterToolName;
        SubMonitor subMonitorChild;
        AtomicBoolean alreadyDataUpdated;
        AtomicBoolean templateLoadResult;
        String mcuValue = selectionContainer.getSelectedMcu();
        String boardValue = selectionContainer.getSelectedBoard();
        String kitValue = selectionContainer.getSelectedKit();
        String templateValue = selectionContainer.getSelectedTemplate();
        String configurationName = selectionContainer.getConfigurationName();
        String sdkVersion = UtilsText.safeString((String)selectionContainer.getSelectedSdk());
        String selectedPackage = selectionContainer.getSelectedPackage();
        ProcessorCore selCore = selectionContainer.getSelectedCore();
        if (UtilsText.isEmpty((String)sdkVersion) && UtilsText.isEmpty((String)templateValue)) assert (false);
        Display display = shell.getDisplay();
        assert (display != null);
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        if (!UtilsText.isEmpty((String)templateValue) && templateValue != null) {
            ISharedConfiguration newConfig;
            ITemplateInfo template2 = derivatives.getTemplateById(templateValue);
            ISharedConfiguration iSharedConfiguration = newConfig = !Objects.isNull(wizardData) ? wizardData.newConfiguration : SharedConfigurationFactory.createSharedConfiguration();
            if (template2 == null) {
                LOGGER.log(Level.SEVERE, "Displayed template not found, internal error");
                assert (false);
                return false;
            }
            File preSetMex = new File(String.valueOf(SupportedDerivativesForSwTools.getUserTemplatesDir()) + File.separator + template2.getRelFileName());
            if (preSetMex.exists()) {
                try {
                    Throwable throwable = null;
                    Object var20_26 = null;
                    try (FileInputStream is = new FileInputStream(preSetMex);){
                        SharedConfigurationFactory.loadSharedConfigurationFromXml((ISharedConfiguration)newConfig, (InputStream)is);
                        ICommonConfig mcuSelection = newConfig.getCommonConfig();
                        mcuSelection.setName(configurationName);
                        NewConfigWizard.updateOrDownloadProcessor(display, (IMcuSelection)mcuSelection, selectionContainer.getOnlineDataInfo().getOnlineProcessorsWeb(), (IProgressMonitor)subMonitor.newChild(1));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
                Tools.disableUnconfiguredTools((ISharedConfiguration)newConfig);
                targetConfig.setLocationPath(null);
                targetConfig.setCreatedFromUserTemplate(true);
                display.syncExec(() -> {
                    SharedConfigurationFactory.applyNewConfig((ISharedConfiguration)newConfig, (ISharedConfiguration)targetConfig, (ConfigChangeReason)ConfigChangeReason.NEW_CONFIG);
                    targetConfig.setDirty("McuConfiguration", (Object)targetConfig, wizardData.getMode().getUiCaption());
                });
                SWToolsPlatform.getAnalytics().logUserAction(2, targetConfig.getUUID(), "project_new", UtilsText.safeString((String)targetConfig.getCommonConfig().getMcu()), UtilsText.safeString((String)targetConfig.getCommonConfig().getSdkVersion()));
                return true;
            }
            display.syncExec(() -> MessageDialog.openError((Shell)shell, (String)Messages.get().NewConfigDialog_ErrorDialogTitle, (String)MessageFormat.format("Cannot open file {0}", preSetMex.toString())));
            return false;
        }
        if (!UtilsText.isEmpty((String)kitValue) && kitValue != null) {
            ITemplateInfo kit;
            String kitId = kitValue;
            ITemplateInfo kitOnline = (ITemplateInfo)CollectionsUtils.nullableOptionalGet(selectionContainer.getOnlineDataInfo().getOnlineKits().stream().filter(b -> kitValue.equals(b.getId())).filter(b -> sdkVersion.equals(b.getSWToolsDataFolderID())).findFirst());
            templateLoadResult = new AtomicBoolean();
            alreadyDataUpdated = new AtomicBoolean();
            if (NewConfigWizard.isDownloadOrUpdatePossible()) {
                subMonitorChild = subMonitor.newChild(1, 0);
                assert (subMonitorChild != null);
                ProcessorDataUpdateUI.downloadOrUpdateKit((Display)display, (String)kitId, (String)sdkVersion, (IProgressMonitor)subMonitorChild, (Collection)selectionContainer.getOnlineDataInfo().getOnlineKitsWeb());
                kit = kitOnline;
                if (kit != null) {
                    masterToolName = kit.getMasterToolName();
                    status = NewConfigWizard.updateOrDownloadData(display, (String)masterToolName, sdkVersion, selectionContainer.getOnlineDataInfo().getOnlineProcessorsWeb(), (IProgressMonitor)subMonitor.newChild(1, 0));
                    if (status.isCurrentOrUpdated()) {
                        alreadyDataUpdated.set(true);
                    } else {
                        display.syncExec(() -> NewConfigWizard.showDownloadError(shell, status));
                    }
                }
            } else {
                subMonitor.worked(2);
            }
            if ((template = derivatives.getKitById(kitId, sdkVersion)) == null) {
                return false;
            }
            display.syncExec(() -> templateLoadResult.set(ConfigurationUtils.applyMexTemplate((ISharedConfiguration)targetConfig, (ITemplateInfo)template, (String)configurationName, (ProcessorCore)selCore, selection -> {
                if (!alreadyDataUpdated.get()) {
                    NewConfigWizard.updateOrDownloadProcessor(display, selection, selectionContainer.getOnlineDataInfo().getOnlineProcessorsWeb(), (IProgressMonitor)new NullProgressMonitor());
                }
            })));
            if (templateLoadResult.get()) {
                SWToolsPlatform.getAnalytics().logUserAction(2, targetConfig.getUUID(), "project_new", UtilsText.safeString((String)targetConfig.getCommonConfig().getMcu()), UtilsText.safeString((String)targetConfig.getCommonConfig().getSdkVersion()));
                return true;
            }
            if (kitOnline != null) {
                mcuValue = kitOnline.getMasterToolName();
            } else {
                kit = derivatives.getKitById(kitId, sdkVersion);
                if (kit != null) {
                    mcuValue = kit.getMasterToolName();
                }
            }
        }
        if (!UtilsText.isEmpty((String)boardValue) && boardValue != null) {
            ITemplateInfo board;
            String boardId = boardValue;
            ITemplateInfo boardOnline = (ITemplateInfo)CollectionsUtils.nullableOptionalGet(selectionContainer.getOnlineDataInfo().getOnlineBoards().stream().filter(b -> boardValue.equals(b.getId())).filter(b -> sdkVersion.equals(b.getSWToolsDataFolderID())).findFirst());
            templateLoadResult = new AtomicBoolean();
            alreadyDataUpdated = new AtomicBoolean();
            if (NewConfigWizard.isDownloadOrUpdatePossible()) {
                subMonitorChild = subMonitor.newChild(1, 0);
                assert (subMonitorChild != null);
                ProcessorDataUpdateUI.downloadOrUpdateBoard((Display)display, (String)boardId, (String)sdkVersion, (IProgressMonitor)subMonitorChild, (Collection)selectionContainer.getOnlineDataInfo().getOnlineBoardsWeb());
                board = boardOnline;
                if (board != null) {
                    masterToolName = board.getMasterToolName();
                    status = NewConfigWizard.updateOrDownloadData(display, (String)masterToolName, sdkVersion, selectionContainer.getOnlineDataInfo().getOnlineProcessorsWeb(), (IProgressMonitor)subMonitor.newChild(1, 0));
                    if (status.isCurrentOrUpdated()) {
                        alreadyDataUpdated.set(true);
                    } else {
                        display.syncExec(() -> NewConfigWizard.showDownloadError(shell, status));
                    }
                }
            } else {
                subMonitor.worked(2);
            }
            if ((template = derivatives.getBoardById(boardId, sdkVersion)) == null) {
                return false;
            }
            display.syncExec(() -> templateLoadResult.set(ConfigurationUtils.applyMexTemplate((ISharedConfiguration)targetConfig, (ITemplateInfo)template, (String)configurationName, (ProcessorCore)selCore, selection -> {
                if (!alreadyDataUpdated.get()) {
                    NewConfigWizard.updateOrDownloadProcessor(display, selection, selectionContainer.getOnlineDataInfo().getOnlineProcessorsWeb(), (IProgressMonitor)new NullProgressMonitor());
                }
            })));
            if (templateLoadResult.get()) {
                SWToolsPlatform.getAnalytics().logUserAction(2, targetConfig.getUUID(), "project_new", UtilsText.safeString((String)targetConfig.getCommonConfig().getMcu()), UtilsText.safeString((String)targetConfig.getCommonConfig().getSdkVersion()));
                return true;
            }
            if (boardOnline != null) {
                mcuValue = boardOnline.getMasterToolName();
            } else {
                board = derivatives.getBoardById(boardId, sdkVersion);
                if (board != null) {
                    mcuValue = board.getMasterToolName();
                }
            }
        }
        if (!UtilsText.isEmpty((String)mcuValue) && mcuValue != null) {
            IProcessorMasterToolInfo procLocal;
            ISharedConfiguration newConfig = !selectionContainer.isSwitchingProcessor() ? (!Objects.isNull(wizardData) ? wizardData.newConfiguration : SharedConfigurationFactory.createSharedConfiguration()) : targetConfig;
            String mcu = mcuValue;
            @NonNull IMcuSelectionWritable mcuSelection = (IMcuSelectionWritable)(!selectionContainer.isSwitchingProcessor() ? newConfig.getCommonConfig() : SharedConfigurationFactory.getSharedConfigurationSingleton().getCommonConfig());
            if (UtilsText.isEmpty((String)boardValue)) {
                mcuSelection.setBoard(null);
            } else {
                String boardId = boardValue;
                mcuSelection.setBoard(boardId);
            }
            if (UtilsText.isEmpty((String)kitValue)) {
                mcuSelection.setKit(null);
            } else {
                mcuSelection.setKit(kitValue);
            }
            mcuSelection.setMcu(mcu);
            mcuSelection.setPackage(null);
            mcuSelection.setSdkVersion(sdkVersion);
            mcuSelection.setExample(null);
            DownloadStatus downloadStatus = DownloadStatus.CURRENT;
            if (NewConfigWizard.isDownloadOrUpdatePossible()) {
                downloadStatus = NewConfigWizard.updateOrDownloadData(display, mcu, sdkVersion, selectionContainer.getOnlineDataInfo().getOnlineProcessorsWeb(), (IProgressMonitor)subMonitor.newChild(2, 0));
                DownloadStatus status2 = downloadStatus;
                if (!status2.isCurrentOrUpdated()) {
                    display.syncExec(() -> NewConfigWizard.showDownloadError(shell, status2));
                }
            } else {
                subMonitor.worked(2);
            }
            if ((procLocal = derivatives.getProcessorMasterToolInfo(mcu, sdkVersion)) == null) {
                if (!downloadStatus.isCurrentOrUpdated()) {
                    return false;
                }
                display.syncExec(() -> MessageDialog.openError((Shell)shell, (String)Messages.get().NewConfigDialog_ErrorDialogTitle, (String)Messages.get().NewConfigDialog_CannotDownloadData));
                return false;
            }
            mcuSelection.setPackage(selectedPackage != null ? selectedPackage : procLocal.getDefaultPartNumber());
            File preSetMex = new File(String.valueOf(derivatives.getDataDir()) + File.separator + procLocal.getSubDir() + File.separator + mcuSelection.getPackage() + ".mex");
            if (!selectionContainer.isSwitchingProcessor() && preSetMex.exists()) {
                try {
                    masterToolName = null;
                    Object var23_35 = null;
                    try (InputStream is = UtilsDecryption.getFileInputStream((File)preSetMex);){
                        SharedConfigurationFactory.loadSharedConfigurationFromXml((ISharedConfiguration)newConfig, (InputStream)is);
                        mcuSelection = (IMcuSelectionWritable)newConfig.getCommonConfig();
                    }
                    catch (Throwable throwable) {
                        if (masterToolName == null) {
                            masterToolName = throwable;
                        } else if (masterToolName != throwable) {
                            ((Throwable)masterToolName).addSuppressed(throwable);
                        }
                        throw masterToolName;
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            mcuSelection.setName(configurationName);
            SWToolsPlatform.applyCores((ISharedConfiguration)newConfig, (ISupportedDerivativesForSwTools)derivatives);
            if (!selectionContainer.isSwitchingProcessor()) {
                targetConfig.setLocationPath(null);
            }
            targetConfig.setCreatedFromUserTemplate(false);
            if (!WizardData.Mode.SWITCH_PROCESSOR.equals((Object)wizardData.getMode())) {
                Tools.disableToolsWithUnsupportedProcessor((ISharedConfiguration)newConfig);
                if (selCore != null) {
                    newConfig.getCommonConfig().setSelectedCore(selCore);
                }
            }
            display.syncExec(() -> {
                SharedConfigurationFactory.applyNewConfig((ISharedConfiguration)newConfig, (ISharedConfiguration)targetConfig, (ConfigChangeReason)(selectionContainer.isSwitchingProcessor() ? ConfigChangeReason.MCU_CHANGE : ConfigChangeReason.NEW_CONFIG));
                targetConfig.setDirty("McuConfiguration", (Object)targetConfig, wizardData.getMode().getUiCaption());
            });
            SWToolsPlatform.getAnalytics().logUserAction(2, targetConfig.getUUID(), "project_new", UtilsText.safeString((String)targetConfig.getCommonConfig().getMcu()), UtilsText.safeString((String)targetConfig.getCommonConfig().getSdkVersion()));
            subMonitor.done();
            return true;
        }
        return false;
    }

    private static void showDownloadError(@NonNull Shell shell, @NonNull DownloadStatus status) {
        String message = DownloadStatus.DISK_ERROR == status ? MessageFormat.format(com.nxp.swtools.utils.Messages.get().ConfigurationUtils_DiskOperationError, PEConfiguration.getDataDirectory()) : Messages.get().NewConfigDialog_CannotDownloadData;
        MessageDialog.openError((Shell)shell, (String)Messages.get().NewConfigDialog_ErrorDialogTitle, (String)message);
    }

    public static boolean isDownloadOrUpdatePossible() {
        return !SWToolsProperties.isDevelopmentWithNoDataUpdateOn() && !KExProcessorsProvider.isOffline();
    }

    public static @NonNull DownloadStatus updateOrDownloadProcessor(@NonNull Display display, @NonNull IMcuSelection selection, @NonNull Collection<@NonNull IProcessorInfo> onlineProcessorsWeb, @NonNull IProgressMonitor monitor) {
        return NewConfigWizard.updateOrDownloadData(display, selection.getMcu(), selection.getSdkVersion(), onlineProcessorsWeb, monitor);
    }

    public static @NonNull DownloadStatus updateOrDownloadData(@NonNull Display display, @NonNull String masterToolName, @NonNull String sdkVersion, @NonNull Collection<@NonNull IProcessorInfo> onlineProcessorsWeb, @NonNull IProgressMonitor monitor) {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (NewConfigWizard.isDownloadOrUpdatePossible()) {
            DownloadStatus status = ProcessorDataUpdateUI.downloadOrUpdateProcessor((Display)display, (String)masterToolName, (String)sdkVersion, onlineProcessorsWeb, (IProgressMonitor)subMon.newChild(1, 0));
            if (status.isErrorOrCancelled()) {
                return status;
            }
            status = ProcessorDataUpdateUI.downloadOrUpdateComponents((Display)display, (String)masterToolName, (String)sdkVersion, (IProgressMonitor)subMon.newChild(1, 0));
            return status;
        }
        subMon.done();
        return DownloadStatus.OFFLINE;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage newPage = super.getNextPage(page);
        while (newPage != null) {
            if (newPage instanceof NewConfigWizardPage) {
                NewConfigWizardPage ourWizardPage = (NewConfigWizardPage)newPage;
                if (ourWizardPage.canBeShown()) break;
                newPage = super.getNextPage(newPage);
                continue;
            }
            assert (false) : "All our pages must be extended from NewConfigWizardPage";
        }
        return newPage;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void readPageProviders() {
        @NonNull ExecutableExtensionProvider provider = new ExecutableExtensionProvider("com.nxp.swtools.framework.newconfigwizard", "page", "class", null, null, "priority");
        @NonNull @NonNull Map pagesMap = provider.getExtensionsMap("id");
        for (Map.Entry val : pagesMap.entrySet()) {
            this.pageProviders.put((String)val.getKey(), (IWizardPageProvider)val.getValue());
        }
    }

    private void createPagesFromProviders() {
        for (Map.Entry<String, IWizardPageProvider> val : this.pageProviders.entrySet()) {
            assert (val != null);
            @Nullable IWizardPageProvider value = val.getValue();
            assert (value != null);
            NewConfigWizardPage page = value.createPage(this.wizardData);
            if (page == null) continue;
            this.addPage((IWizardPage)page);
        }
    }

    private boolean performPreFinishContributors(SubMonitor monitor) {
        boolean result = true;
        SubMonitor providerMonitor = monitor.newChild(this.pageProviders.entrySet().size());
        for (Map.Entry<String, IWizardPageProvider> val : this.pageProviders.entrySet()) {
            assert (val != null);
            @Nullable IWizardPageProvider value = val.getValue();
            assert (value != null);
            SubMonitor monit = providerMonitor.newChild(1);
            assert (monit != null);
            result = value.performPreFinish(this.wizardData, (IProgressMonitor)monit);
            if (!result) break;
        }
        return result;
    }

    private boolean performFinishContributors(SubMonitor monitor) {
        boolean result = true;
        SubMonitor providerMonitor = monitor.newChild(this.pageProviders.entrySet().size());
        for (Map.Entry<String, IWizardPageProvider> val : this.pageProviders.entrySet()) {
            assert (val != null);
            @Nullable IWizardPageProvider value = val.getValue();
            assert (value != null);
            SubMonitor monit = providerMonitor.newChild(1);
            assert (monit != null);
            result = value.performFinish(this.wizardData, (IProgressMonitor)monit);
            if (!result) break;
        }
        return result;
    }
}

