/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.ui.downloadmanager;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.dialogs.KExProgressMonitorDialog;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.IConfigComponentInfo;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.framework.ui.newconfig.ProcessorNode;
import com.nxp.swtools.framework.ui.newconfig.ProcessorProvider;
import com.nxp.swtools.framework.ui.newconfig.containers.ProcessorSelectionContainer;
import com.nxp.swtools.framework.wizards.processordata.ExportProcessorDataWizard;
import com.nxp.swtools.framework.wizards.processordata.ImportProcessorDataWizard;
import com.nxp.swtools.provider.processors.DownloadStatus;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.provider.processors.OnlineDataInfo;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.preferences.KEPreferences;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

@NonNullByDefault
public class DataManager
extends Dialog {
    private static final int BTN_IMPORT_ID = 1024;
    private static final int BTN_EXPORT_ID = 1025;
    private static final int BTN_CACHED_ONLY_ID = 1026;
    private static final int BTN_OUTDATE_ID = 1027;
    private static final int BTN_UNSELECT_ALL_ID = 1028;
    private static final int BTN_UPDATE_ID = 1029;
    private static final Logger LOGGER = LogManager.getLogger(DataManager.class);
    final ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
    protected OnlineDataInfo onlineDataInfo = new OnlineDataInfo();
    protected ProcessorProvider processorProvider = new ProcessorProvider(this.onlineDataInfo, p -> true, b -> true, b -> false);
    @Nullable
    private CheckboxTreeViewer viewer;
    @Nullable
    private LocalOnlyFilter treeFilter;

    public DataManager(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        CheckboxTreeViewer viewerLoc = this.viewer = new CheckboxTreeViewer(composite);
        Tree tree = viewerLoc.getTree();
        SWTFactoryProxy.INSTANCE.enableHtmlTooltipFor((ColumnViewer)viewerLoc);
        tree.setToolTipText("");
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).hint(780, 400).applyTo((Control)tree);
        this.onlineDataInfo.refresh();
        this.treeFilter = new LocalOnlyFilter(this.derivatives);
        viewerLoc.addFilter((ViewerFilter)this.treeFilter);
        viewerLoc.setContentProvider((IContentProvider)this.processorProvider);
        ProcessorSelectionContainer.createNameColumn((TreeViewer)viewerLoc, this.derivatives);
        ProcessorSelectionContainer.createProductColumns((TreeViewer)viewerLoc, this.derivatives, this.onlineDataInfo, null);
        ProcessorSelectionContainer.createStatusColumn((TreeViewer)viewerLoc, this.derivatives, this.onlineDataInfo);
        DataManager.createLocalVersionColumn((TreeViewer)viewerLoc, this.derivatives);
        DataManager.createRemoteVersionColumn((TreeViewer)viewerLoc, this.onlineDataInfo);
        viewerLoc.setInput((Object)this.derivatives);
        viewerLoc.expandToLevel(2);
        viewerLoc.addCheckStateListener(DataManager::checkSubTree);
        return composite;
    }

    public static void checkSubTree(CheckStateChangedEvent event) {
        boolean status = event.getChecked();
        Object element = event.getElement();
        CheckboxTreeViewer trView = (CheckboxTreeViewer)event.getSource();
        trView.setGrayed(element, false);
        trView.setSubtreeChecked(element, status);
        ITreeContentProvider contentProvider = (ITreeContentProvider)trView.getContentProvider();
        Object parentElement = contentProvider.getParent(element);
        if (parentElement != null) {
            trView.setGrayed(parentElement, true);
        }
    }

    public static void createLocalVersionColumn(TreeViewer viewer, final ISupportedDerivativesForSwTools derivatives) {
        TreeViewerColumn localColumn = new TreeViewerColumn(viewer, 0);
        TreeColumn localCol = localColumn.getColumn();
        localCol.setText(Messages.get().DataManager_ColumnLocalversion);
        localColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public @Nullable String getText(Object element) {
                block13: {
                    block12: {
                        if (!(element instanceof ITemplateInfo)) break block12;
                        ITemplateInfo template = (ITemplateInfo)element;
                        switch (template.getTemplateType()) {
                            case ttTemplate: {
                                return null;
                            }
                            case ttBoard: {
                                ITemplateInfo board = derivatives.getBoardById(template.getId(), template.getSWToolsDataFolderID());
                                if (board != null) {
                                    return board.getVersion();
                                }
                                break block13;
                            }
                            case ttKit: {
                                ITemplateInfo kit = derivatives.getKitById(template.getId(), template.getSWToolsDataFolderID());
                                if (kit != null) {
                                    return kit.getVersion();
                                }
                                break block13;
                            }
                            default: {
                                if (!$assertionsDisabled) {
                                    throw new AssertionError((Object)"unsupported template type");
                                }
                                break block13;
                            }
                        }
                    }
                    if (element instanceof IProcessorMasterToolInfo) {
                        IProcessorMasterToolInfo info = (IProcessorMasterToolInfo)element;
                        IProcessorMasterToolInfo proc = (IProcessorMasterToolInfo)CollectionsUtils.nullableOptionalGet(derivatives.getProcessorMasterToolInfos(info.getId()).findFirst());
                        if (proc != null) {
                            return proc.getVersion();
                        }
                    } else if (!(element instanceof ProcessorNode) && !$assertionsDisabled) {
                        throw new AssertionError((Object)"Unsupported type");
                    }
                }
                return "-";
            }
        });
        localCol.pack();
    }

    public static void createRemoteVersionColumn(TreeViewer viewer, final OnlineDataInfo onlineDataInfo) {
        TreeViewerColumn remoteColumn = new TreeViewerColumn(viewer, 0);
        TreeColumn remoteCol = remoteColumn.getColumn();
        remoteCol.setText(Messages.get().DataManager_ColumnRemoteVersion);
        remoteColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public @Nullable String getText(Object element) {
                if (element instanceof ITemplateInfo) {
                    ITemplateInfo template = (ITemplateInfo)element;
                    switch (template.getTemplateType()) {
                        case ttTemplate: {
                            return null;
                        }
                        case ttBoard: {
                            return onlineDataInfo.getOnlineBoards().stream().filter(k -> k.getId().equals(template.getId())).findFirst().map(ITemplateInfo::getVersion).orElse(Messages.get().DataManager_NotAvailable);
                        }
                        case ttKit: {
                            return onlineDataInfo.getOnlineKits().stream().filter(k -> k.getId().equals(template.getId())).findFirst().map(ITemplateInfo::getVersion).orElse(Messages.get().DataManager_NotAvailable);
                        }
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)"unsupported template type");
                    }
                } else {
                    if (element instanceof IProcessorMasterToolInfo) {
                        IProcessorMasterToolInfo info = (IProcessorMasterToolInfo)element;
                        String mcu = info.getId();
                        return onlineDataInfo.getOnlineProcessors().stream().filter(p -> p.getId().equals(mcu)).findFirst().map(IProcessorMasterToolInfo::getVersion).orElse(Messages.get().DataManager_NotAvailable);
                    }
                    if (!(element instanceof ProcessorNode) && !$assertionsDisabled) {
                        throw new AssertionError((Object)"Unsupported type");
                    }
                }
                return null;
            }
        });
        remoteCol.pack();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.get().DataManager_DialogTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        assert (parent != null);
        this.createButton(parent, 1024, Messages.get().DataManager_ImportBtn, false).setToolTipText(Messages.get().DataManager_ImportBtnTooltip);
        this.createButton(parent, 1025, Messages.get().DataManager_ExportBtn, false).setToolTipText(Messages.get().DataManager_ExportBtnTooltip);
        this.createToggleButton(parent, 1026, Messages.get().DataManager_CachedOnlyBtn, false).setToolTipText(Messages.get().DataManager_CachedOnlyBtnTooltip);
        this.createButton(parent, 1027, Messages.get().DataManager_OutdatedBtn, false).setToolTipText(Messages.get().DataManager_OutdatedBtnTooltip);
        this.createButton(parent, 1028, Messages.get().DataManager_UnselectAllBtn, false).setToolTipText(Messages.get().DataManager_UnselectAllBtnTooltip);
        Button downloadBtn = this.createButton(parent, 1029, Messages.get().DataManager_UpdateBtn, false);
        downloadBtn.setToolTipText(Messages.get().DataManager_UpdateBtnTooltip);
        if (SWToolsProperties.isDevelopmentWithNoDataUpdateOn()) {
            downloadBtn.setEnabled(false);
        }
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    private Button createToggleButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 2);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        button.addListener(13, event -> {
            Object data = event.widget.getData();
            assert (data != null);
            this.buttonPressed((Integer)data);
        });
        if (defaultButton) {
            Shell shell = parent.getShell();
            shell.setDefaultButton(button);
        }
        this.setButtonLayoutData(button);
        return button;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 12: {
                super.buttonPressed(0);
                break;
            }
            case 1028: {
                this.unselectAll();
                break;
            }
            case 1027: {
                this.selectOutdated(null);
                break;
            }
            case 1026: {
                this.toggleLocalFilter();
                break;
            }
            case 1029: {
                this.updateSelectedData();
                break;
            }
            case 1025: {
                DataManager.openExportWizard();
                break;
            }
            case 1024: {
                this.openImportWizard();
                break;
            }
            default: {
                assert (false) : "Unknown button ID";
                break;
            }
        }
    }

    private void toggleLocalFilter() {
        assert (this.treeFilter != null);
        this.treeFilter.setLocalOnly(!this.treeFilter.isLocalOnly());
        this.getViewer().refresh();
    }

    CheckboxTreeViewer getViewer() {
        assert (this.viewer != null);
        return this.viewer;
    }

    void openImportWizard() {
        ImportProcessorDataWizard.openWizard();
        this.getViewer().refresh();
    }

    static void openExportWizard() {
        ExportProcessorDataWizard.openWizard();
    }

    private void selectOutdated(@Nullable Object element) {
        Object input;
        Object[] elements = element == null ? ((input = this.getViewer().getInput()) != null ? this.processorProvider.getElements(input) : new Object[]{}) : this.processorProvider.getChildren(element);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object el = objectArray[n2];
            if (ProcessorSelectionContainer.isUpdateAvailable(el, this.derivatives, this.onlineDataInfo)) {
                this.getViewer().setChecked(el, true);
            }
            this.selectOutdated(el);
            ++n2;
        }
    }

    private void updateSelectedData() {
        final Shell shell = this.getShell();
        assert (shell != null);
        if (KEPreferences.isOffline()) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.get().DataManager_InformationTitle, (String)Messages.get().DataManager_CannotDownloadInOffline);
            return;
        }
        KExProgressMonitorDialog pmd = new KExProgressMonitorDialog(this.getShell());
        pmd.setCancelable(true);
        pmd.create();
        final String processorsTaskName = Messages.get().ExportProcessorDataWizard_DownloadingProcessors;
        final List<@NonNull Object> toBeUpdated = this.getSelectedElements();
        Collection<@NonNull Object> extras = this.askForDependencies(toBeUpdated);
        toBeUpdated.addAll(extras);
        try {
            pmd.run(true, true, new IRunnableWithProgress(){

                /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    @NonNull Collection componentsOnWeb = KExProcessorsProvider.listComponents();
                    List<@NonNull T> componentSdks = KExProcessorsProvider.listSWTComponents((Collection)componentsOnWeb).stream().map(IConfigComponentInfo::getSdkVersion).distinct().collect(Collectors.toList());
                    SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)processorsTaskName, (int)(toBeUpdated.size() + componentSdks.size() * componentsOnWeb.size()));
                    try {
                        DownloadStatus status;
                        for (Object obj : toBeUpdated) {
                            block21: {
                                block20: {
                                    if (monitor.isCanceled()) {
                                        return;
                                    }
                                    status = new AtomicReference(DownloadStatus.CURRENT);
                                    if (!(obj instanceof ITemplateInfo)) break block20;
                                    ITemplateInfo template = (ITemplateInfo)obj;
                                    switch (template.getTemplateType()) {
                                        case ttBoard: {
                                            status.set(KExProcessorsProvider.downloadOrUpdateBoard((String)template.getId(), (String)template.getSWToolsDataFolderID(), (IProgressMonitor)subMon.newChild(1), (Collection)DataManager.this.onlineDataInfo.getOnlineBoardsWeb()));
                                            break;
                                        }
                                        case ttKit: {
                                            status.set(KExProcessorsProvider.downloadOrUpdateKit((String)template.getId(), (String)template.getSWToolsDataFolderID(), (IProgressMonitor)subMon.newChild(1), (Collection)DataManager.this.onlineDataInfo.getOnlineKitsWeb()));
                                            break;
                                        }
                                        case ttTemplate: {
                                            if (!$assertionsDisabled) {
                                                throw new AssertionError((Object)"user templates should not be here");
                                            } else {
                                                break;
                                            }
                                        }
                                    }
                                    break block21;
                                }
                                if (obj instanceof IProcessorMasterToolInfo) {
                                    IProcessorMasterToolInfo info = (IProcessorMasterToolInfo)obj;
                                    String mcu = info.getId();
                                    DataManager.this.onlineDataInfo.getOnlineProcessors().stream().filter(p -> mcu.equals(p.getId())).forEach(arg_0 -> this.lambda$2((AtomicReference)status, mcu, subMon, arg_0));
                                } else if (!$assertionsDisabled) {
                                    throw new AssertionError((Object)"unknown type of data");
                                }
                            }
                            if (!((DownloadStatus)status.get()).isErrorOrCancelled()) continue;
                            DataManager.this.showErrorForFailedStatus(shell, (DownloadStatus)status.get());
                            return;
                        }
                        for (String sdk : componentSdks) {
                            if (monitor.isCanceled()) {
                            } else {
                                status = KExProcessorsProvider.downloadOrUpdateComponents((String)sdk, null, (IProgressMonitor)subMon.newChild(componentsOnWeb.size()));
                                if (!status.isErrorOrCancelled()) continue;
                                DataManager.this.showErrorForFailedStatus(shell, status);
                            }
                            break;
                        }
                    }
                    finally {
                        DataManager.this.derivatives.refreshSupportedDerivatives();
                    }
                }

                private /* synthetic */ void lambda$2(AtomicReference atomicReference, String string, SubMonitor subMonitor, IProcessorMasterToolInfo p) {
                    atomicReference.set(KExProcessorsProvider.downloadOrUpdateProcessor((String)string, (String)p.getSWToolsDataFolderID(), (Collection)DataManager.this.onlineDataInfo.getOnlineProcessorsWeb(), (IProgressMonitor)subMonitor.newChild(1)));
                }
            });
            this.getViewer().refresh();
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.log(Level.WARNING, "Unable to download processors ", e);
        }
    }

    private Collection<Object> askForDependencies(List<Object> selectedObjects) {
        boolean res;
        List<@NonNull String> missingCpus = DataManager.computeProcessorDependencies(selectedObjects, mcu -> this.derivatives.getProcessorMasterToolInfos(mcu).findFirst().isPresent());
        if (!missingCpus.isEmpty() && (res = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.get().DataManager_QuestionTitleForMissingProcessors, (String)MessageFormat.format(Messages.get().DataManager_MissingProcessorsQuestion, String.join((CharSequence)", ", missingCpus))))) {
            for (String mcu2 : missingCpus) {
                this.getViewer().setChecked((Object)mcu2, true);
            }
            return new ArrayList<Object>(missingCpus);
        }
        return CollectionsUtils.emptyList();
    }

    public static List<String> computeProcessorDependencies(List<Object> selectedObjects, Predicate<String> filterProcessor) {
        List<@NonNull T> mcus = selectedObjects.stream().filter(o -> o instanceof String).map(Object::toString).collect(Collectors.toList());
        ArrayList<@NonNull String> missingCpus = new ArrayList<String>();
        for (Object o2 : selectedObjects) {
            ITemplateInfo template;
            String mcu;
            if (!(o2 instanceof ITemplateInfo) || mcus.contains(mcu = (template = (ITemplateInfo)o2).getMasterToolName()) || filterProcessor.test(mcu)) continue;
            missingCpus.add(mcu);
        }
        return missingCpus;
    }

    void showErrorForFailedStatus(Shell shell, DownloadStatus status) {
        assert (!status.isCurrentOrUpdated());
        String message = ConfigurationUtils.getDownloadStatusError((DownloadStatus)status, null);
        if (message != null) {
            shell.getDisplay().syncExec(() -> MessageDialog.openError((Shell)shell, (String)com.nxp.swtools.utils.Messages.get().ConfigurationUtils_Error, (String)message));
        }
    }

    private List<Object> getSelectedElements() {
        Object[] selectedElements = this.getViewer().getCheckedElements();
        return Arrays.stream(selectedElements).filter(o -> !(o instanceof ProcessorNode)).collect(Collectors.toList());
    }

    private void unselectAll() {
        CheckboxTreeViewer tv = this.getViewer();
        IContentProvider provider = tv.getContentProvider();
        try {
            tv.getTree().setRedraw(false);
            if (provider instanceof ITreeContentProvider) {
                ITreeContentProvider treeProvider = (ITreeContentProvider)provider;
                Object input = tv.getInput();
                assert (input != null);
                Object[] objectArray = treeProvider.getElements(input);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    tv.setSubtreeChecked(o, false);
                    ++n2;
                }
            } else assert (false) : "Expected ITreeContentProvider";
        }
        finally {
            tv.getTree().setRedraw(true);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    static class LocalOnlyFilter
    extends ViewerFilter {
        private ISupportedDerivativesForSwTools suppDerivatives;
        private boolean localOnly = false;

        public LocalOnlyFilter(ISupportedDerivativesForSwTools derivatives) {
            this.suppDerivatives = derivatives;
        }

        public boolean select(Viewer viewerFilter, Object parentElement, Object element) {
            if (!this.localOnly) {
                return true;
            }
            if (element instanceof ProcessorNode) {
                Object[] children;
                ProcessorNode node = (ProcessorNode)element;
                Object[] objectArray = children = node.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (this.select(viewerFilter, element, obj)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            if (element instanceof ITemplateInfo) {
                ITemplateInfo template = (ITemplateInfo)element;
                switch (template.getTemplateType()) {
                    case ttBoard: {
                        return this.suppDerivatives.getAllBoardsInfos().stream().anyMatch(b -> b.getId().equals(template.getId()));
                    }
                    case ttKit: {
                        return this.suppDerivatives.getAllKitsInfos().stream().anyMatch(b -> b.getId().equals(template.getId()));
                    }
                    case ttTemplate: {
                        return true;
                    }
                }
            } else if (element instanceof IProcessorMasterToolInfo) {
                IProcessorMasterToolInfo info = (IProcessorMasterToolInfo)element;
                return this.suppDerivatives.getProcessorMasterToolInfos(info.getId()).findFirst().isPresent();
            }
            return true;
        }

        public boolean isLocalOnly() {
            return this.localOnly;
        }

        public void setLocalOnly(boolean localOnly) {
            this.localOnly = localOnly;
        }
    }
}

