/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.p2;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.net.NetUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.logging.UserLogger;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.utils.dialog.ToolsProgressMonitorDialog;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.Update;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

@NonNullByDefault
public class P2UpdateSites {
    static final String Bundle_ID = "com.nxp.swtools.framework";
    static final Logger LOGGER = LogManager.getLogger(P2UpdateSites.class);
    public static final String FILE_PROTOCOL = "file:";

    private static IProvisioningAgent createAgent() {
        Bundle bundle = Platform.getBundle((String)Bundle_ID);
        assert (bundle != null);
        BundleContext context = bundle.getBundleContext();
        assert (context != null);
        ServiceTracker tracker = new ServiceTracker(context, IProvisioningAgent.class, null);
        tracker.open();
        IProvisioningAgent agent = (IProvisioningAgent)tracker.getService();
        tracker.close();
        return agent;
    }

    public @NonNull File[] getLocalUpdateSites() {
        IProvisioningAgent agent = P2UpdateSites.createAgent();
        if (agent == null) {
            return new File[0];
        }
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            return new File[0];
        }
        URI[] repositoryLocations = manager.getKnownRepositories(4);
        ArrayList<File> locations = new ArrayList<File>(repositoryLocations.length);
        URI[] uRIArray = repositoryLocations;
        int n = repositoryLocations.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            if ("file".equals(uri.getScheme())) {
                locations.add(URIUtil.toFile((URI)uri));
            }
            if ("jar".equals(uri.getScheme())) {
                try {
                    uri = new URI(uri.toString().substring("jar:".length()).replace("!/", "/"));
                    locations.add(URIUtil.toFile((URI)uri));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        File[] sites = locations.toArray(new File[0]);
        assert (sites != null);
        return sites;
    }

    public UpdateStatus checkForUpdates(IProgressMonitor monitor, @Nullable Display display, String[] repositoryLoc, boolean confirmUpdate) {
        Job alreadyRunningJob = this.findUpdateJob();
        if (alreadyRunningJob != null) {
            Shell shell;
            Shell shell2 = shell = display != null ? display.getActiveShell() : null;
            if (shell != null) {
                PlatformUI.getWorkbench().getProgressService().showInDialog(shell, alreadyRunningJob);
            }
            return UpdateStatus.UPDATE_RUNNING;
        }
        IProvisioningAgent agent = P2UpdateSites.createAgent();
        ProvisioningSession session = new ProvisioningSession(agent);
        UpdateOperation operation = new UpdateOperation(session);
        P2UpdateSites.configureUpdate(operation, repositoryLoc);
        Shell shell = display != null ? display.getActiveShell() : null;
        @Nullable IStatus[] status = new IStatus[1];
        if (shell != null) {
            String monitorTaskName = UtilsText.safeString((String)Messages.get().P2UpdateSites_JobTaskCheckUpdates);
            ToolsProgressMonitorDialog pmd = new ToolsProgressMonitorDialog(shell);
            try {
                pmd.run(true, true, m -> {
                    m.beginTask(monitorTaskName, 1);
                    iStatusArray[0] = operation.resolveModal(m);
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                return UpdateStatus.ERROR_OTHER;
            }
            UserLogger.getInstance().info(Messages.get().P2UpdateSites_JobTaskCheckUpdates, null);
        } else {
            status[0] = operation.resolveModal(monitor);
        }
        IStatus iStatus = status[0];
        if (iStatus == null || iStatus.getCode() == 10000) {
            if (display != null) {
                display.syncExec(() -> {
                    String msg = !NetUtils.isNetworkAvailable() ? Messages.get().P2UpdateSites_NoNetwork : (repositoryLoc.length > 0 && !repositoryLoc[0].startsWith(FILE_PROTOCOL) && !KExProcessorsProvider.checkConnectionIsAvailable((String)repositoryLoc[0]) ? Messages.get().P2UpdateSites_ConnectionError : Messages.get().P2UpdateSites_NoUpdatesAvailable);
                    UserLogger.getInstance().warning(msg, null);
                    MessageDialog.openWarning((Shell)display.getActiveShell(), (String)Messages.get().P2UpdateSites_WarningTitle, (String)msg);
                });
            } else {
                System.out.println(Messages.get().P2UpdateSites_NoUpdatesAvailable);
            }
            return UpdateStatus.NOTHING_TO_UPDATE;
        }
        ProvisioningJob provisioningJob = operation.getProvisioningJob(null);
        if (provisioningJob == null) {
            if (display != null && operation.hasResolved()) {
                display.syncExec(() -> {
                    UserLogger.getInstance().error(operation.getResolutionDetails(), null);
                    MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.get().P2UpdateSites_ErrorTitle, (String)operation.getResolutionDetails());
                });
            }
            LOGGER.log(Level.WARNING, "Updates do not work in Eclipse IDE");
            LOGGER.warning("Operation resolve status: " + operation.hasResolved());
            LOGGER.warning("Reason: " + operation.getResolutionDetails());
            return UpdateStatus.ERROR_RUNNING_IN_IDE;
        }
        if (confirmUpdate && display != null) {
            StringBuilder updMessage = new StringBuilder(Messages.get().P2UpdateSites_AvailableUpdates);
            Update[] updateArray = operation.getPossibleUpdates();
            int n = updateArray.length;
            int n2 = 0;
            while (n2 < n) {
                Update update = updateArray[n2];
                String iuName = update.replacement.getProperty("org.eclipse.equinox.p2.name");
                if (iuName != null) {
                    updMessage.append(iuName).append(MessageFormat.format(" {0} ==> {1}\n", update.toUpdate.getVersion(), update.replacement.getVersion()));
                } else {
                    updMessage.append(update.toString());
                }
                ++n2;
            }
            UserLogger.info((String)updMessage.toString(), null, (Display)display);
            updMessage.append(Messages.get().P2UpdateSites_ProceedWithUpdateQuestion);
            boolean[] confirmed = new boolean[1];
            display.syncExec(() -> {
                boolean bl = MessageDialog.openQuestion((Shell)display.getActiveShell(), (String)Messages.get().P2UpdateSites_UpdateQuestion, (String)updMessage.toString());
            });
            if (!confirmed[0]) {
                return UpdateStatus.UPDATE_AVAILABLE_NOT_EXECUTED;
            }
        }
        P2UpdateSites.addProvisioningListener(display, provisioningJob);
        WorkbenchPlugin.getDefault().getPreferenceStore().setValue("RUN_IN_BACKGROUND", false);
        provisioningJob.setUser(true);
        provisioningJob.schedule();
        return UpdateStatus.UPDATE_AVAILABLE_EXECUTED;
    }

    private static void addProvisioningListener(final @Nullable Display display, ProvisioningJob provisioningJob) {
        if (display != null) {
            provisioningJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        display.syncExec(() -> {
                            UserLogger.info((String)Messages.get().P2UpdateSites_FinishUpdate, null, (Display)display);
                            boolean restart = MessageDialog.openQuestion((Shell)display.getActiveShell(), (String)Messages.get().P2UpdateSites_ConfirmationTitle, (String)Messages.get().P2UpdateSites_UpdateInstalledRestartQuestion);
                            if (restart) {
                                PlatformUI.getWorkbench().restart();
                            }
                        });
                    }
                    super.done(event);
                }
            });
        }
    }

    private static UpdateOperation configureUpdate(UpdateOperation operation, String[] repositoriesLoc) {
        URI[] uris = null;
        uris = Arrays.stream(repositoriesLoc).map(loc -> {
            try {
                return new URI((String)loc);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Configure update", e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()).toArray(new URI[0]);
        operation.getProvisioningContext().setArtifactRepositories(uris);
        operation.getProvisioningContext().setMetadataRepositories(uris);
        return operation;
    }

    public @Nullable Job findUpdateJob() {
        IJobManager manager = Job.getJobManager();
        if (manager == null) {
            return null;
        }
        Job[] jobs = manager.find(null);
        return (Job)CollectionsUtils.nullableOptionalGet(Arrays.stream(jobs).filter(j -> j.getState() != 0).filter(ProvisioningJob.class::isInstance).findFirst());
    }

    public boolean isUpdateInProgress() {
        return this.findUpdateJob() != null;
    }

    public static enum UpdateStatus {
        UPDATE_RUNNING,
        NOTHING_TO_UPDATE,
        ERROR_RUNNING_IN_IDE,
        ERROR_OTHER,
        UPDATE_AVAILABLE_NOT_EXECUTED,
        UPDATE_AVAILABLE_EXECUTED;

    }
}

