/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.handlers;

import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.FileAccessFactory;
import com.nxp.swtools.common.utils.files.IAbstractFileAccess;
import com.nxp.swtools.common.utils.files.IFileAccessListener;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.logging.UserLogger;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.change.DefaultConfigChangeContext;
import com.nxp.swtools.provider.configuration.sources.IDestinationPathProvider;
import com.nxp.swtools.provider.configuration.sources.ISourceFileProviderWrapper;
import com.nxp.swtools.provider.configuration.sources.SourceFileProviderFactory;
import com.nxp.swtools.provider.configuration.storage.GeneratedProjectFile;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.toolchainproject.IGeneratedFilesStatusProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.ToolSourceFileProvider;
import com.nxp.swtools.sdkproject.ToolchainProjectDestinationPathProvider;
import com.nxp.swtools.sdkproject.updateprojectcode.UpdateCodeDialog;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.cdt.CDTProjectUtils;
import com.nxp.swtools.utils.command.handlers.UpdateCodeBlocker;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.progress.ProgressUtils;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.tools.ITool;
import com.nxp.swtools.utils.tools.Tools;
import com.nxp.swtools.utils.wizards.exportWizard.ExportUtils;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IEvaluationService;

@NonNullByDefault
public class UpdateCodeHandler
extends AbstractHandler
implements IElementUpdater {
    public static final String COMMAND_ENABLE_SERVICE_PROPERTY = "updateProjectCodeEnabled";
    private static final String COMMAND_ENABLE_SERVICE = "com.nxp.swtools.framework.updateProjectCodeEnabled";
    protected static final Logger LOGGER = LogManager.getLogger(UpdateCodeHandler.class);
    private static final int DIALOG_WAIT_TIMEOUT_MS = 1500;
    private static final String GCC_LANGUAGE_ID = "org.eclipse.cdt.core.gcc";

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.isEnabled()) {
            boolean forceDialog = KEPreferences.showUpdateCodeDialog();
            Command cmd = event.getCommand();
            assert (cmd != null);
            if (cmd.getId().equals("com.nxp.swtools.framework.openProjectUpdateDialogCmd")) {
                forceDialog = true;
            }
            if (forceDialog) {
                Display display = Display.getCurrent();
                assert (display != null);
                UpdateCodeHandler.waitUntilUpdated(SharedConfigurationFactory.getSharedConfigurationSingleton(), 1500);
                UpdateCodeDialog dlg = new UpdateCodeDialog(ShellProvider.getAnyShellParent((Display)display), true);
                if (dlg.open() != 0) {
                    return null;
                }
            }
            this.execUpdateProjectCode();
            if (SWToolsPlatform.isRunningInMCUXpressoIde() && forceDialog && KEPreferences.returnToDevelopAfterUpdateProject()) {
                try {
                    PerspectivesHelper.showPerspective((String)"com.crt.lite.perspective.CRTPerspective");
                }
                catch (WorkbenchException e) {
                    LOGGER.log(Level.SEVERE, "Failed to select 'Develop' perspective", e);
                }
            }
        }
        return null;
    }

    void execUpdateProjectCode() {
        UserLogger.getInstance().info(com.nxp.swtools.sdkproject.Messages.get().UpdPrjCode_ActionCaption);
        UpdateCodeHandler.updateCode(SharedConfigurationFactory.getSharedConfigurationSingleton());
    }

    public static void waitUntilUpdated(ISharedConfiguration shrdConfig, int timeoutMs) {
        ProgressUtils.runWithTimeout(() -> {
            for (ToolSourceFileProvider toolSrcFileProvider : ToolSourceFileProvider.getToolSourceFileProviders()) {
                StorageTool storageTool = toolSrcFileProvider.getStorageTool();
                if (storageTool == null || !storageTool.isEnabled() || !storageTool.getUpdateCode()) continue;
                ITool tool = Tools.getTool((String)toolSrcFileProvider.getToolId());
                assert (tool != null);
                if (!tool.isProcessorSupported(shrdConfig)) continue;
                tool.waitUntilUpdated(shrdConfig);
            }
        }, (long)timeoutMs);
    }

    public static void updateCode(ISharedConfiguration shrdConfig) {
        IProject project;
        IToolchainProjectWithSdk toolchainProject = shrdConfig.getToolchainProject();
        if (toolchainProject == null) {
            assert (false);
            return;
        }
        ProcessorCore selCore = shrdConfig.getCommonConfig().getSelectedCore();
        assert (selCore != null);
        ToolchainProjectDestinationPathProvider destPathProvider = new ToolchainProjectDestinationPathProvider(toolchainProject, "");
        IAbstractFileAccess fileAccess = FileAccessFactory.getFileSystemAccess();
        if (SWToolsPlatform.isRunningInEclipseIde() && (project = ConfigurationUtils.getEclipseProject((ISharedConfiguration)shrdConfig)) != null) {
            fileAccess = FileAccessFactory.getEclipseProjectFileAccess((IProject)project);
            if (KEPreferences.isGeneratedSourceFolder()) {
                fileAccess.addListener(new IFileAccessListener(){

                    public void directoryCreated(java.nio.file.Path path) {
                        IFolder newFolder = project.getFolder((IPath)new Path(path.toString()));
                        if (newFolder != null) {
                            CDTProjectUtils.addSourceEntry((IProject)project, (IFolder)newFolder);
                            CDTProjectUtils.addIncludeEntry((IProject)project, (String)("${ProjDirPath}/" + path.toString()), (String)UpdateCodeHandler.GCC_LANGUAGE_ID, (int)16);
                        }
                    }
                });
            }
        }
        ExportUtils.SetReadOnly makeReadOnly = KEPreferences.areGeneratedReadOnly() ? ExportUtils.SetReadOnly.ENABLE : ExportUtils.SetReadOnly.DISABLE;
        IToolchainProjectProvider projectProvider = shrdConfig.getToolchainProjectProvider();
        assert (projectProvider != null);
        IGeneratedFilesStatusProvider genStatusProvider = projectProvider.getGeneratedFilesStatusProvider();
        assert (genStatusProvider != null);
        genStatusProvider.getGeneratedFiles(true);
        for (ToolSourceFileProvider toolSrcFileProvider : ToolSourceFileProvider.getToolSourceFileProviders()) {
            StorageTool storageTool = toolSrcFileProvider.getStorageTool();
            if (storageTool != null && !storageTool.isEnabled()) continue;
            if (storageTool != null && storageTool.getUpdateCode()) {
                ITool tool = Tools.getTool((String)toolSrcFileProvider.getToolId());
                assert (tool != null);
                if (!tool.isProcessorSupported(shrdConfig)) {
                    UpdateCodeHandler.userLog(Level.SEVERE, toolSrcFileProvider.getToolId(), String.valueOf(com.nxp.swtools.sdkproject.Messages.get().UpdPrjCode_LogToolFailedUpdateSrcFiles) + " - Target processor is not supported");
                    continue;
                }
                tool.waitUntilUpdated(shrdConfig);
                ISourceFileProviderWrapper.ISourceGenerateResult genResult = toolSrcFileProvider.getSourceFileProvider().generate(selCore.getID(), true);
                String problem = genResult.getErrorMessage();
                if (problem == null) {
                    Collection generatedFiles = genResult.getAllGeneratedFiles();
                    ToolchainProjectDestinationPathProvider pathProvider = new ToolchainProjectDestinationPathProvider(toolchainProject, "board");
                    HashMap<@NonNull K, @NonNull V> generate_Files = new HashMap();
                    ArrayList genPrjFiles = new ArrayList();
                    generatedFiles.forEach(sourceFile -> {
                        String filePath = pathProvider.getDestPathProjectRelative(sourceFile.getRelFileName()).toString();
                        IGeneratedFilesStatusProvider.GeneratedFileStatus status = genStatusProvider.getGeneratedFileProjectStatus(filePath, false);
                        if (status == null && genResult.isDerivedSource(sourceFile.getRelFileName())) {
                            status = new IGeneratedFilesStatusProvider.GeneratedFileStatus(IGeneratedFilesStatusProvider.GeneratedFileInfo.MODIFIED, true, tool.getToolId());
                        }
                        assert (status != null);
                        String fileName = UtilsFile.getFileNameWithExtension((String)filePath);
                        boolean fileUpdateEnabled = storageTool.isProjectFileUpdateEnabled(fileName);
                        genPrjFiles.add(new GeneratedProjectFile(filePath, fileUpdateEnabled, genResult.isDerivedSource(sourceFile.getRelFileName())));
                        if (fileUpdateEnabled && genStatusProvider.isNeededUpdateProjectCode(status)) {
                            if (status.statusInfo == IGeneratedFilesStatusProvider.GeneratedFileInfo.DELETE) {
                                if (toolchainProject.deleteFile(Paths.get(filePath, new String[0]))) {
                                    genStatusProvider.requestUpdate();
                                }
                            } else {
                                String content = sourceFile.getAsString();
                                generate_Files.put(filePath, content);
                            }
                        }
                    });
                    genStatusProvider.getGeneratedFiles(false, tool.getToolId()).map(string -> Paths.get(string, new String[0])).filter(p -> {
                        IGeneratedFilesStatusProvider.GeneratedFileStatus status = genStatusProvider.getGeneratedFileProjectStatus(p.toString(), true);
                        return status != null && status.statusInfo == IGeneratedFilesStatusProvider.GeneratedFileInfo.DELETE;
                    }).forEach(relFilePath -> {
                        if (toolchainProject.deleteFile(relFilePath)) {
                            genStatusProvider.requestUpdate();
                        }
                    });
                    if (storageTool.setGeneratedProjectFiles(genPrjFiles)) {
                        shrdConfig.setDirty((IConfigChangeContext)new DefaultConfigChangeContext(IConfigChangeContext.ConfigChangeType.UNKNOWN, toolSrcFileProvider.getToolId(), (Object)storageTool, com.nxp.swtools.sdkproject.Messages.get().UpdPrjCode_SetDirty_UpdPrjGenFiles));
                    }
                    if (generate_Files.isEmpty()) continue;
                    if (!ExportUtils.exportToFolder((IDestinationPathProvider)destPathProvider, (Collection)SourceFileProviderFactory.buildSourceFileList(generate_Files), (IAbstractFileAccess)fileAccess, (String)KEPreferences.getLineEnding(), null, (boolean)true, (ExportUtils.SetReadOnly)makeReadOnly, (boolean)false)) {
                        UpdateCodeHandler.userLog(Level.SEVERE, toolSrcFileProvider.getToolId(), com.nxp.swtools.sdkproject.Messages.get().UpdPrjCode_LogToolFailedUpdateSrcFiles);
                        continue;
                    }
                    String msg = String.valueOf(com.nxp.swtools.sdkproject.Messages.get().UpdPrjCode_LogToolUpdatedSrcFiles) + CollectionsUtils.formatList(generate_Files.keySet(), (String)", ", null);
                    UpdateCodeHandler.userLog(Level.INFO, toolSrcFileProvider.getToolId(), msg);
                    continue;
                }
                UpdateCodeHandler.userLog(Level.SEVERE, toolSrcFileProvider.getToolId(), String.valueOf(com.nxp.swtools.sdkproject.Messages.get().UpdPrjCode_LogToolFailedUpdateSrcFiles) + " - " + problem);
                continue;
            }
            UpdateCodeHandler.userLog(Level.INFO, toolSrcFileProvider.getToolId(), com.nxp.swtools.sdkproject.Messages.get().UpdPrjCode_LogToolUpdateDisabled);
        }
        if (SWToolsProperties.isHeadlessOn()) {
            ConfigurationUtils.saveConfiguration(null, (boolean)false);
        } else {
            Display display = Display.getCurrent();
            assert (display != null);
            ConfigurationUtils.saveConfiguration((Shell)ShellProvider.getAnyShellParent((Display)display), (boolean)false);
            UserLogger.getInstance().info(String.valueOf(com.nxp.swtools.sdkproject.Messages.get().UpdPrjCode_LogMexUpdated) + shrdConfig.getLocationOnDisk());
        }
        toolchainProject.updateProjectSettings(shrdConfig);
    }

    private static void userLog(Level level, String toolId, String msg) {
        assert (level != null);
        if (msg == null) {
            msg = "Unknown error or message not localized";
        }
        if (SWToolsProperties.isHeadlessOn() || Level.SEVERE.equals(level)) {
            LOGGER.log(level, String.valueOf(toolId) + ": " + msg);
        }
        if (!SWToolsProperties.isHeadlessOn()) {
            UserLogger.getInstance().log(level, msg, toolId);
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        UpdateCodeBlocker blocker = UpdateCodeBlocker.getReasonBlockingUpdateProjectCode((ISharedConfiguration)sharedConfig);
        if (blocker != null) {
            element.setTooltip(blocker.description);
            if (blocker.isConfigurationProblem) {
                element.setDisabledIcon(ToolsImages.getImageDescriptorWithUrl((String)"icons/updateProjectCode_Blocked.png"));
                element.setIcon(ToolsImages.getImageDescriptorWithUrl((String)"icons/updateProjectCode_Blocked.png"));
            } else {
                element.setDisabledIcon(ToolsImages.getImageDescriptorWithUrl((String)"icons/updateProjectCode_Disabled.png"));
                element.setIcon(ToolsImages.getImageDescriptorWithUrl((String)"icons/updateProjectCode_Disabled.png"));
            }
        } else {
            boolean isPrjUpdNeeded = false;
            if (sharedConfig.isDirty()) {
                isPrjUpdNeeded = true;
                element.setTooltip(Messages.get().UpdateProjectCode_Modified);
            } else {
                Stream genFilesStrm;
                String toolThatNeedsUpdate;
                IGeneratedFilesStatusProvider genStatusProvider;
                IToolchainProjectProvider prjProvider = sharedConfig.getToolchainProjectProvider();
                if (prjProvider != null && (genStatusProvider = prjProvider.getGeneratedFilesStatusProvider()) != null && (toolThatNeedsUpdate = (String)CollectionsUtils.findAny(genFilesStrm = genStatusProvider.getGeneratedFiles(false).stream(), filePath -> {
                    IGeneratedFilesStatusProvider.GeneratedFileStatus fileSts = genStatusProvider.getGeneratedFileProjectStatus(filePath, false);
                    if (fileSts != null && genStatusProvider.isNeededUpdateProjectCode(fileSts)) {
                        return fileSts.isToolUpdateProjectCodeEnabled(UtilsFile.getFileNameWithExtension((String)filePath));
                    }
                    return false;
                })) != null) {
                    isPrjUpdNeeded = true;
                }
                if (isPrjUpdNeeded) {
                    element.setTooltip(Messages.get().UpdateProjectCode_Modified);
                } else {
                    element.setTooltip(Messages.get().UpdateProjectCode_UpToDate);
                }
            }
            element.setIcon(ToolsImages.getImageDescriptorWithUrl((String)(isPrjUpdNeeded ? "icons/updateProjectCode_Dirty.png" : "icons/updateProjectCode_Updated.png")));
        }
        UpdateCodeHandler.updateEnableState();
    }

    private static void updateEnableState() {
        IEvaluationService evaluationService;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (evaluationService = (IEvaluationService)window.getService(IEvaluationService.class)) != null) {
            evaluationService.requestEvaluation(COMMAND_ENABLE_SERVICE);
        }
    }
}

