/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.handlers;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.framework.Application;
import com.nxp.swtools.provider.SWToolsPlatform;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class SwitchToolCommandHandler
extends AbstractHandler
implements IElementUpdater {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(SwitchToolCommandHandler.class);
    @NonNull
    private static final String SWITCH_TO_PRODUCT_COMMAND_PARAMETER = "com.nxp.swtools.framework.switchToProduct";
    @NonNull
    private static final String SWITCH_TOOL_COMMAND = "com.nxp.swtools.framework.switchTool";
    @Nullable
    private IPerspectiveListener perspectiveListener;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String productID = event.getParameter(SWITCH_TO_PRODUCT_COMMAND_PARAMETER);
        if (productID != null) {
            SwToolsProduct registeredProduct = SwToolsProductConfiguration.getRegisteredProduct((String)productID);
            if (registeredProduct != null) {
                if (SWToolsPlatform.isRunningInEclipseIde() && !Application.isAnyToolPerspectiveOpened()) {
                    BusyIndicator.showWhile((Display)Display.getCurrent(), () -> Application.openAllPerspectives());
                }
                Application.setSelectedTool(registeredProduct);
                SwitchToolCommandHandler.refreshCommand();
            } else {
                LOGGER.severe(String.valueOf(productID) + " - no product with such id found.");
            }
        } else {
            LOGGER.severe("No product found as parameter of the command com.nxp.swtools.framework.switchTool");
        }
        return null;
    }

    public static void refreshCommand() {
        ICommandService commandService;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ICommandService iCommandService = commandService = window != null ? (ICommandService)window.getService(ICommandService.class) : null;
        if (commandService != null) {
            commandService.refreshElements(SWITCH_TOOL_COMMAND, null);
        }
    }

    public boolean isEnabled() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (this.perspectiveListener == null && activeWorkbenchWindow != null) {
            this.perspectiveListener = new IPerspectiveListener(){

                public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                    SwitchToolCommandHandler.refreshCommand();
                }

                public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
                    SwitchToolCommandHandler.refreshCommand();
                }
            };
            activeWorkbenchWindow.addPerspectiveListener(this.perspectiveListener);
        }
        return super.isEnabled();
    }

    public void updateElement(UIElement element, Map parameters) {
        Object commandParameter = parameters.get(SWITCH_TO_PRODUCT_COMMAND_PARAMETER);
        if (commandParameter != null) {
            String productID = UtilsText.safeToString(commandParameter);
            String selectedTool = Application.getSelectedTool();
            boolean checked = Objects.equals(selectedTool, productID);
            element.setChecked(checked);
        } else {
            LOGGER.severe("No product found as parameter of the command com.nxp.swtools.framework.switchTool");
        }
    }

    public void dispose() {
        super.dispose();
        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (win != null) {
            win.removePerspectiveListener(this.perspectiveListener);
        }
    }
}

