/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.handlers;

import com.nxp.swtools.common.ui.utils.swt.UtilsImage;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.framework.handlers.FrameworkAboutDialog;
import java.text.MessageFormat;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.Bundle;

public class FrameworkAboutHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        Shell shell = window.getShell();
        String name = null;
        String version = null;
        String description = null;
        Image icon = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            Bundle bundle;
            name = product.getName();
            if (name == null) {
                name = product.getProperty("appName");
            }
            if ((description = product.getDescription()) == null) {
                description = product.getProperty("aboutText");
            }
            if ((bundle = product.getDefiningBundle()) != null) {
                icon = UtilsImage.getImage((String)UtilsText.safeString((String)bundle.getSymbolicName()), (String)UtilsText.safeString((String)product.getProperty("aboutImage")));
                version = FrameworkAboutHandler.getProductVersion(product, bundle);
            }
        }
        assert (product != null);
        FrameworkAboutDialog dialog = new FrameworkAboutDialog(shell, UtilsText.safeString((String)name), UtilsText.safeString(version), UtilsText.safeString((String)description), icon);
        dialog.open();
        return null;
    }

    public static @NonNull String getProductVersion(@NonNull IProduct product, @NonNull Bundle bundle) {
        String version = product.getProperty("version");
        if (version == null) {
            version = MessageFormat.format("{0}.{1}", Integer.toString(bundle.getVersion().getMajor()), Integer.toString(bundle.getVersion().getMinor()));
        }
        return version;
    }
}

