/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.commands;

import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.framework.ui.newconfig.NewConfigWizard;
import com.nxp.swtools.framework.ui.newconfig.WizardData;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.utils.ConfigurationUtils;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NewConfigurationCommandHandler
extends AbstractHandler {
    @NonNull
    static final Logger LOGGER = LogManager.getLogger(NewConfigurationCommandHandler.class);
    AtomicBoolean dialogShown = new AtomicBoolean(false);

    public void launchWizard( @NonNull WizardData.WizardType wizardType) {
        if (!this.dialogShown.compareAndSet(false, true)) {
            return;
        }
        try {
            int result;
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            ISharedConfiguration configuration = SWToolsPlatform.getSharedConfigurationSingleton();
            if (configuration.isDirty() && shell != null && (result = ConfigurationUtils.saveDirtyConfiguration((Shell)shell, null, null, (boolean)true)) == 256) {
                return;
            }
            NewConfigWizard wizard = new NewConfigWizard(wizardType);
            WizardDialog wd = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            wd.setTitle(wizard.getWindowTitle());
            wd.open();
            if (wizard.showDashboard) {
                UIJobHelper.runUIJob(() -> {
                    if (PerspectivesHelper.getActivePerspectiveId() != null) {
                        PerspectivesHelper.focusView((String)"com.nxp.swtools.dashboard.DashboardView");
                    }
                }, (String)"Open Dashboard", (boolean)false);
            }
        }
        finally {
            this.dialogShown.set(false);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.launchWizard(Objects.isNull(event) ? WizardData.WizardType.STARTUP : WizardData.WizardType.NEW_CONFIGURATION);
        return null;
    }
}

