/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.commands;

import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.framework.commands.ToolUpdateInfo;
import com.nxp.swtools.framework.p2.P2UpdateSites;
import com.nxp.swtools.kex.api.IHttpConnectionHelper;
import com.nxp.swtools.kex.api.MfactApiFactory;
import com.nxp.swtools.kex.exceptions.MfactServerError;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.simpleframework.xml.core.Persister;

public class CheckForUpdates
extends AbstractHandler {
    private static final String TOOL_UPDATE_FILE_NAME = "tool_update.xml";
    static final Logger LOGGER = LogManager.getLogger(CheckForUpdates.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        P2UpdateSites helper = new P2UpdateSites();
        @NonNull String[] repositories = System.getProperty("update.site", "file://tmp/updatesite").split(",");
        P2UpdateSites.UpdateStatus status = helper.checkForUpdates((IProgressMonitor)new NullProgressMonitor(), Display.getCurrent(), repositories, true);
        if (Display.getCurrent() != null) {
            switch (status) {
                case NOTHING_TO_UPDATE: 
                case ERROR_RUNNING_IN_IDE: 
                case ERROR_OTHER: {
                    if (repositories.length <= 0) break;
                    CheckForUpdates.checkNewApplication(repositories[0]);
                    break;
                }
            }
        }
        return null;
    }

    private static void checkNewApplication(@NonNull String repository) {
        if (repository.startsWith("file:")) {
            return;
        }
        IHttpConnectionHelper helper = MfactApiFactory.getHttpConnectionHelper();
        String url = String.valueOf(repository) + (repository.endsWith("/") ? "" : "/") + TOOL_UPDATE_FILE_NAME;
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (InputStream is = helper.getHttpBinaryResponse(url, null, null, KExProcessorsProvider.getProxyConfiguration());){
                Persister serializer = new Persister();
                ToolUpdateInfo message = new ToolUpdateInfo();
                serializer.read((Object)message, is);
                if (message.message != null && !UtilsText.isEmpty((String)message.message)) {
                    MessageDialog.openInformation((Shell)ShellProvider.getAnyShellParent(), (String)Messages.get().CheckForUpdates_NewAppDialogTitle, (String)(String.valueOf(message.message) + "\n" + message.link));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (MfactServerError mfactServerError) {
            LOGGER.fine("No information available about new application");
        }
        catch (SocketException | SocketTimeoutException | UnknownHostException connectionException) {
            LOGGER.log(Level.SEVERE, "Connection error tool_update.xml", connectionException);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Deserializing from tool_update.xml", e);
        }
    }
}

