/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework;

import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.framework.Application;
import com.nxp.swtools.framework.ApplicationWorkbenchWindowAdvisor;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.utils.ConfigurationUtils;
import java.io.File;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static final Logger LOGGER = LogManager.getLogger(ApplicationWorkbenchAdvisor.class);

    public void preStartup() {
        if (OSDetect.isMac()) {
            Display display = Display.getCurrent();
            assert (display != null);
            display.addListener(46, event -> {
                File f = new File(event.text);
                if (f.isFile()) {
                    Application.setMexFileToOpen(f);
                }
            });
        }
        super.preStartup();
    }

    public boolean preShutdown() {
        if (!ApplicationWorkbenchAdvisor.saveWorkOnExit()) {
            return false;
        }
        return super.preShutdown();
    }

    public static boolean saveWorkOnExit() {
        ISharedConfiguration configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (!configuration.isEmpty() && configuration.isDirty() && shell != null && !SWToolsProperties.isPropertyTrue((String)"com.swtools.test.silentMode")) {
            int result;
            String extraInfo = "";
            IPath path = configuration.getLocationPath();
            if (path == null) {
                if (SWToolsPlatform.isRunningInEclipseIde()) {
                    LOGGER.log(Level.SEVERE, "configuration.getLocationPath() is null");
                    assert (false) : "configuration.getLocationPath() is null";
                    return false;
                }
            } else {
                extraInfo = "(" + path.toFile().getName() + ")" + " ";
            }
            return (result = ConfigurationUtils.saveDirtyConfiguration((Shell)shell, (String)Messages.get().ApplicationWorkbenchAdvisor_ConfirmExit, (String)MessageFormat.format(Messages.get().ApplicationWorkbenchAdvisor_ConfirmExitMessage, extraInfo), (boolean)true)) != 256;
        }
        return true;
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new ApplicationWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return null;
    }
}

