/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework;

import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.cmd.CmdArguments;
import com.nxp.swtools.common.utils.cmd.CmdProgressMonitor;
import com.nxp.swtools.common.utils.cmd.CmdSection;
import com.nxp.swtools.common.utils.cmd.ICmdApplication;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.CompactFormatter;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.zip.ZipUtils;
import com.nxp.swtools.configuration.PEConfiguration;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.framework.ApplicationWorkbenchAdvisor;
import com.nxp.swtools.framework.ApplicationWorkbenchWindowAdvisor;
import com.nxp.swtools.framework.KExCmdLine;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.framework.handlers.UpdateCodeHandler;
import com.nxp.swtools.kex.analytics.DesktopAnalytics;
import com.nxp.swtools.kex.analytics.DesktopAnalyticsHelper;
import com.nxp.swtools.kex.analytics.IAnalyticDataProvider;
import com.nxp.swtools.kex.analytics.IAnalytics;
import com.nxp.swtools.kex.api.MfactApiFactory;
import com.nxp.swtools.kex.selector.McuSelectionFactory;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.analytics.GeneralAnalytics;
import com.nxp.swtools.provider.analytics.MouseListenerAnalytics;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.processors.CheckStatus;
import com.nxp.swtools.provider.processors.DataUpdater;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.rcp.analytics.RcpAnalyticsFactory;
import com.nxp.swtools.sdkproject.ImportToolchainProjectFactory;
import com.nxp.swtools.sdkproject.ToolchainProjectFactory;
import com.nxp.swtools.sdkproject.ToolchainProjectUtils;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.logging.SevereLogsDetector;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.tools.Tools;
import com.nxp.swtools.utils.undo.UndoRedoConfig;
import com.nxp.swtools.utils.wizards.importWizard.ImportHelper;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.osgi.framework.Bundle;

@NonNullByDefault
public class Application
implements IApplication {
    private static final Logger LOGGER = LogManager.getLogger(Application.class);
    private static String selectedTool = "";
    private static String VERIFICATION_FLAG = "-verify";
    public static List<@NonNull String> argsList = new ArrayList<String>();
    private static Integer mExitCode = IApplication.EXIT_OK;
    static final Integer EXIT_MISSING_PARAM = 1;
    static final Integer EXIT_TOOL_ERROR = 2;
    static KExCmdLine cmdLine = new KExCmdLine(CollectionsUtils.emptyUnmodifiableList());
    static CmdSection cmdSection = new CmdSection();
    protected static final String MEX_FILE_NAME = "mex_output";
    private static boolean importingAllProjects = false;
    @Nullable
    private static File macMexFileToOpen = null;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static boolean importProject(String prjPath) {
        ImportToolchainProjectFactory.PERFORMANCE_LOGGER.entering(Application.class.getName(), "importProject");
        String prjPath4TestCase = prjPath;
        int pos = prjPath4TestCase.indexOf("boards");
        if (pos > 0) {
            prjPath4TestCase = prjPath4TestCase.substring(pos + 7);
        }
        CompactFormatter.setTestCase((String)("importProject:" + prjPath4TestCase));
        try {
            IToolchainProjectWithSdk project;
            ISharedConfiguration importConfiguration = SharedConfigurationFactory.createSharedConfiguration();
            ISharedConfiguration tgtConfiguration = SharedConfigurationFactory.getSharedConfigurationSingleton();
            IToolchainProjectProvider prjProvider = tgtConfiguration.getToolchainProjectProvider();
            assert (prjProvider != null);
            prjProvider.disableProblemUpdates();
            try {
                Path path;
                try {
                    path = Paths.get(prjPath, new String[0]);
                }
                catch (InvalidPathException e) {
                    LOGGER.log(Level.SEVERE, "Invalid path: " + prjPath, e);
                    prjProvider.enableProblemUpdates();
                    CompactFormatter.setTestCase((String)"");
                    return false;
                }
                assert (path != null);
                project = ToolchainProjectFactory.createToolchainProjectForImport((Path)path, (IProgressMonitor)new NullProgressMonitor());
                if (ImportToolchainProjectFactory.importToolchainProject(null, (ISharedConfiguration)importConfiguration, (IToolchainProjectWithSdk)project, (boolean)false, (IProgressMonitor)new NullProgressMonitor()) != null) {
                    if (importingAllProjects) {
                        LOGGER.warning("Import of toolchain project failed: " + prjPath);
                    } else {
                        LOGGER.severe("[SDK] Import of toolchain project failed, see previous messages for details: " + prjPath);
                    }
                    return false;
                }
                StringBuilder logMsg = new StringBuilder();
                String mexPath = ImportToolchainProjectFactory.getExistingMexPathForProject((String)prjPath);
                if (mexPath == null) {
                    mexPath = String.valueOf(prjPath) + File.separator + project.getProjectName() + ".mex";
                }
                Tools.disableUnconfiguredTools((ISharedConfiguration)importConfiguration);
                boolean res = ImportToolchainProjectFactory.saveMexAfterProjectImport((ISharedConfiguration)importConfiguration, (ISharedConfiguration)tgtConfiguration, (String)mexPath, null, (StringBuilder)logMsg);
                if (logMsg.length() > 0) {
                    LOGGER.info(logMsg.toString());
                } else {
                    if (res) {
                        LOGGER.info("Toolchain project successfuly imported: " + prjPath);
                    }
                    assert (false);
                }
                if (tgtConfiguration.getCommonConfig().getSelectedCore() == null) {
                    LOGGER.severe("[SDK] Core not detected from the toolchain project: " + prjPath);
                } else {
                    UpdateCodeHandler.updateCode(tgtConfiguration);
                }
                IToolchainProjectWithSdk sdkProject = tgtConfiguration.getToolchainProject();
                assert (sdkProject != null);
                sdkProject.logProblemsInSdkComponentDetection();
            }
            finally {
                prjProvider.enableProblemUpdates();
            }
            @NonNull @NonNull Collection problems = ToolchainProjectUtils.getProblemsInSdkProject((ISharedConfiguration)tgtConfiguration, (IToolchainProjectWithSdk)project);
            ValidationEngineFactory.addAndRemoveProblems((String)"McuConfiguration", null, (Collection)problems);
            boolean res = prjProvider.waitUntilProblemsUpdated();
            assert (res);
            ValidationEngineFactory.getValidationService().waitJobFinished(true);
            ValidationEngineFactory.dumpProblems((Logger)LOGGER, (int)2, null);
            ImportToolchainProjectFactory.PERFORMANCE_LOGGER.exiting(Application.class.getName(), "importProject");
        }
        finally {
            CompactFormatter.setTestCase((String)"");
        }
        return true;
    }

    private static boolean importAllProjects(String workspace) {
        SevereLogsDetector severeLogsDetector = new SevereLogsDetector();
        LogManager.addHandler((Handler)severeLogsDetector);
        importingAllProjects = true;
        try {
            File[] files = new File(workspace).listFiles();
            if (files != null) {
                int numProjects = 0;
                int numFailures = 0;
                int numSevere = 0;
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!(!file.isDirectory() || file.getName().endsWith("kds") || file.getName().endsWith("drt") || file.getName().endsWith("mcuxpresso") || file.getName().equals("startup") || file.getName().equals("linker") || file.getName().equals("config_files"))) {
                        LOGGER.info("###> Import toolchain project from: " + file.getAbsolutePath());
                        ++numProjects;
                        if (!Application.importProject(UtilsText.safeString((String)file.getAbsolutePath()))) {
                            ++numFailures;
                        } else if (numSevere < severeLogsDetector.getNumSevere()) {
                            ++numFailures;
                            numSevere = severeLogsDetector.getNumSevere();
                        }
                    }
                    ++n2;
                }
                String resDetail = numFailures == 0 ? String.valueOf(String.valueOf(numProjects)) + " projects SUCCESSFULY imported" : String.valueOf(String.valueOf(numFailures)) + " of " + String.valueOf(numProjects) + " projects FAILED";
                resDetail = "###> Import toolchain projects statistics: " + resDetail;
                LOGGER.info(resDetail);
                System.out.println(resDetail);
                boolean bl = numFailures == 0;
                return bl;
            }
            return false;
        }
        finally {
            importingAllProjects = false;
            LogManager.removeHandler((Handler)severeLogsDetector);
        }
    }

    public Object start(IApplicationContext context) {
        Application.start(Application.parseArgs(context));
        return mExitCode;
    }

    public static void start(List<String> arguments) {
        boolean isHeadless;
        argsList = arguments;
        Application.processArgs();
        Application.setLogger();
        Application.unzipOfflineDataIfNeeded();
        CmdArguments.createCmdOptions();
        cmdLine = new KExCmdLine(argsList);
        cmdLine.parseCmdLine(CmdArguments.cmdOptions);
        Iterator iterator = cmdLine.getSections().iterator();
        if (iterator.hasNext()) {
            CmdSection curSection = (CmdSection)iterator.next();
            if (curSection.hasOption("-updateData")) {
                MfactApiFactory.setHttpTimeouts((int)14000, (int)120000);
                DataUpdater.updateAllData((IProgressMonitor)new CmdProgressMonitor());
            }
            if (curSection.hasOption("-version")) {
                IProduct product = Platform.getProduct();
                Bundle b = product != null ? product.getDefiningBundle() : null;
                String version = b != null ? b.getVersion().toString() : "unknown";
                System.out.println(MessageFormat.format("Tool version: {0}", version));
            }
        }
        if (isHeadless = cmdLine.getSections().stream().anyMatch(section -> section.getOptionValues("-HeadlessTool") != null)) {
            MfactApiFactory.setHttpTimeouts((int)14000, (int)120000);
            System.setProperty("com.nxp.swtools.core.console", Boolean.TRUE.toString());
            System.setProperty("com.swtools.test.silentMode", Boolean.TRUE.toString());
            SWToolsPlatform.initializeAllTools();
        } else if (!cmdLine.getSections().isEmpty()) {
            cmdSection = (CmdSection)cmdLine.getSections().get(0);
            Display display = PlatformUI.createDisplay();
            try {
                int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
                if (returnCode == 1) {
                    mExitCode = IApplication.EXIT_RESTART;
                }
                return;
            }
            finally {
                display.dispose();
            }
        }
        for (CmdSection curSection : cmdLine.getSections()) {
            List filePathsToImport;
            String prjPath;
            if (!Application.getMcuFromCMD(curSection)) {
                Application.loadConfigFromCMD(curSection);
            }
            if (!(prjPath = curSection.getOptionValue("-ImportProject")).isEmpty()) {
                if (prjPath.endsWith("*")) {
                    if (!Application.importAllProjects(prjPath.substring(0, prjPath.length() - 1))) {
                        Application.setExitCode(EXIT_TOOL_ERROR);
                        return;
                    }
                } else if (!Application.importProject(prjPath)) {
                    Application.setExitCode(EXIT_TOOL_ERROR);
                    return;
                }
            } else if (curSection.getOptionValues("-ImportProject") != null) {
                LOGGER.severe("ERROR: Path parameter is empty for -ImportProject");
                Application.setExitCode(EXIT_MISSING_PARAM);
            }
            if ((filePathsToImport = curSection.getOptionValues("-ImportC")) != null) {
                ImportHelper.importCFiles((List)filePathsToImport, (String)curSection.getOptionValue("-HeadlessTool"));
            }
            if (curSection.getOptionValues("-HeadlessTool") == null) continue;
            boolean result = Application.runCmdLineTool(curSection);
            Application.waitForBgJobs();
            Application.setExitCode(result ? Integer.valueOf(0) : EXIT_TOOL_ERROR);
            if (!result) break;
        }
    }

    private static void waitForBgJobs() {
        ISharedConfiguration sharedConfiguration = SharedConfigurationFactory.getSharedConfigurationSingleton();
        Tools.getTools().forEach(t -> {
            boolean bl = t.waitUntilUpdated(sharedConfiguration);
        });
    }

    public static void unzipOfflineDataIfNeeded() {
        ISupportedDerivativesForSwTools sd = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        File dataDir = new File(sd.getDataDir());
        String productId = KExProcessorsProvider.getProductForProcessorFilter();
        File offlineMarkFile = new File(dataDir, "." + productId + "_extracted");
        if ((UtilsFile.isDirEmpty((File)dataDir) || !offlineMarkFile.exists()) && Application.unzipDefaultData(dataDir)) {
            sd.refreshSupportedDerivatives();
            try {
                Files.createFile(offlineMarkFile.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.severe(e.getMessage());
            }
        }
    }

    private static boolean unzipDefaultData(File dataDir) {
        boolean result = false;
        String reason = "";
        String appPath = PEConfiguration.SystemDirectory;
        File zipFile = new File(appPath, "offline_data.zip");
        if (zipFile.exists()) {
            result = ZipUtils.tryExtractZip((File)zipFile, (File)dataDir, (boolean)false, e -> !"npidata.mf".equals(e.getName()));
            if (!result) {
                LOGGER.severe(() -> MessageFormat.format("Could not copy default offline data to data directory. Trying to unzip:''{0}'' to: ''{1}''. Reason: {2}", zipFile.getAbsolutePath(), dataDir.getAbsolutePath(), reason));
            }
        } else {
            LOGGER.info(() -> MessageFormat.format("Zip file with default offline data does not exist. Trying to unzip:''{0}''", zipFile.getAbsolutePath()));
        }
        return result;
    }

    public static void setExitCode(Integer exitCode) {
        if (!Objects.equals(exitCode, 0)) {
            System.setProperty("eclipse.exitdata", "");
        }
        mExitCode = exitCode;
    }

    public static void initializeAnalytics() {
        DesktopAnalytics analytics = RcpAnalyticsFactory.getAnalyticsInstance();
        String machineIdFileName = String.valueOf(System.getProperty("user.home")) + File.separator + ".nxp" + File.separator + ".machineid";
        File machineFile = new File(machineIdFileName);
        try {
            DesktopAnalyticsHelper.initializeMachineHashFromFile((DesktopAnalytics)analytics, (Path)machineFile.toPath());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        analytics.addDataprovider((IAnalyticDataProvider)new GeneralAnalytics(analytics));
        analytics.logSessionStart("", "", "");
        SWToolsPlatform.setAnalytics((IAnalytics)analytics);
        SWToolsPlatform.setSelectedToolProxy(Application::setSelectedTool);
        Display display = Display.getCurrent();
        if (display != null) {
            MouseListenerAnalytics mouseAnalytics = new MouseListenerAnalytics((IAnalytics)analytics);
            analytics.addDataprovider((IAnalyticDataProvider)mouseAnalytics);
            display.addFilter(3, arg_0 -> ((MouseListenerAnalytics)mouseAnalytics).mouseDown(arg_0));
        }
    }

    public static void showAnalyticsInfoDialog() {
        MessageDialogWithToggle dialog;
        Display display = Display.getDefault();
        if (Objects.nonNull(display) && KEPreferences.isAnalyticsEnabled() && KEPreferences.getShowAnalyticsInformationDialog() && !SWToolsProperties.isPropertyTrue((String)"com.swtools.test.silentMode") && (dialog = MessageDialogWithToggle.openInformation((Shell)ShellProvider.getAnyShellParent((Display)display), (String)Messages.get().ApplicationWorkbenchWindowAdvisor_AnalyticsInfoTitle, (String)String.format(Messages.get().ApplicationWorkbenchWindowAdvisor_AnalyticsInfoMessage, Messages.getEditPreferences()), (String)Messages.get().ApplicationWorkbenchWindowAdvisor_AnalyticsInfoToggle, (boolean)true, null, null)).getToggleState()) {
            KEPreferences.setShowAnalyticsInformationDialog((boolean)false);
        }
    }

    public static void uploadAnalytics() {
        if (!KEPreferences.isOffline() && KEPreferences.isAnalyticsEnabled()) {
            RcpAnalyticsFactory.uploadAnalytics();
        }
    }

    public static void stopAnalytics() {
        if (KEPreferences.isAnalyticsEnabled()) {
            RcpAnalyticsFactory.stopAnalytics();
        }
    }

    private static void setLogger() {
        if (SWToolsProperties.isVerificationOn()) {
            LogManager.setForVerification();
        } else {
            java.util.logging.LogManager logMngr = java.util.logging.LogManager.getLogManager();
            String p = logMngr.getProperty("com.nxp.swtools.show_test_case");
            if (p != null && "true".equals(p)) {
                LogManager.addConsoleHandler((Level)Level.SEVERE, (boolean)true);
                LogManager.disableParentHandlers();
            }
        }
    }

    private static List<@NonNull String> parseArgs(IApplicationContext context) {
        Map args = context.getArguments();
        @NonNull String[] apparguments = (String[])args.get("application.args");
        return new ArrayList<String>(Arrays.asList(apparguments));
    }

    private static void processArgs() {
        boolean enabled = argsList.contains(VERIFICATION_FLAG);
        if (enabled) {
            argsList.remove(VERIFICATION_FLAG);
        }
        SWToolsProperties.setVerificationMode((boolean)enabled);
    }

    public void stop() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        display.syncExec(() -> {
            if (!display.isDisposed()) {
                workbench.close();
            }
        });
    }

    public static String getSelectedTool() {
        return selectedTool;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void setSelectedPerspective(@Nullable String perspective) {
        @NonNull Collection registeredProducts = SwToolsProductConfiguration.getRegisteredProducts();
        Optional<@NonNull SwToolsProduct> tool = registeredProducts.stream().filter(x -> x.getPerspectiveID().equals(perspective)).findFirst();
        if (tool.isPresent()) {
            Application.setSelectedTool(tool.get());
        } else {
            LOGGER.warning(() -> "There is no tool that has perspective called '" + perspective + "'");
        }
    }

    public static void setSelectedTool(SwToolsProduct tool) {
        String toolName = tool.getProductName();
        LOGGER.finest(() -> "Switching to the tool " + toolName);
        String toolPerspective = tool.getPerspectiveID();
        selectedTool = toolName;
        PerspectivesHelper.switchPerspective((String)toolPerspective);
        if (!SWToolsPlatform.isRunningInEclipseIde()) {
            ApplicationWorkbenchWindowAdvisor.updateAppTitleBar();
        }
    }

    public static void openAllPerspectives() {
        for (SwToolsProduct tool : SwToolsProductConfiguration.getRegisteredProductsSorted()) {
            if (UtilsText.isEmpty((String)tool.getPerspectiveID())) continue;
            try {
                PerspectivesHelper.showPerspective((String)tool.getPerspectiveID());
            }
            catch (WorkbenchException e) {
                LOGGER.log(Level.SEVERE, "open perspective " + tool.getPerspectiveID(), e);
            }
        }
    }

    public static boolean isAnyToolPerspectiveOpened() {
        return SwToolsProductConfiguration.getRegisteredProducts().stream().anyMatch(tool -> PerspectivesHelper.isPerspectiveOpened((String)tool.getPerspectiveID()));
    }

    public static boolean isAnyToolPerspectiveActive() {
        String activeId = PerspectivesHelper.getActivePerspectiveId();
        if (activeId == null) {
            return false;
        }
        return SwToolsProductConfiguration.getRegisteredProductForPerspective((String)activeId) != null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected static boolean runCmdLineTool(CmdSection section) {
        boolean toolFound = false;
        boolean result = true;
        @NonNull List requestedTools = section.getOptionValues("-HeadlessTool");
        @NonNull Collection registeredProducts = SwToolsProductConfiguration.getRegisteredProducts();
        if (requestedTools == null) {
            return result;
        }
        for (String requestedTool : requestedTools) {
            toolFound = false;
            for (SwToolsProduct product : registeredProducts) {
                if (!product.getProductId().equalsIgnoreCase(requestedTool)) continue;
                result &= Application.runHeadless(product, section);
                toolFound = true;
                Application.waitForBgJobs();
            }
            if (toolFound) continue;
            Object[] availableTools = registeredProducts.stream().map(SwToolsProduct::getProductId).toArray();
            LOGGER.warning(() -> String.format("Requested tool '%s' does not exist. Available tools: %s", requestedTool, Arrays.toString(availableTools)));
            return false;
        }
        Set keys = section.cmdMap.keySet();
        for (String key : keys) {
            String path;
            if (!result) break;
            if (key.equals("-ExportMEX") && !UtilsText.isEmpty((String)(path = section.getOptionValue("-ExportMEX")))) {
                result &= Application.exportMEX(path);
            }
            if (!key.equals("-ExportAll") || UtilsText.isEmpty((String)(path = section.getOptionValue("-ExportAll")))) continue;
            result &= Application.exportMEX(path);
        }
        return result;
    }

    private static boolean exportMEX(String path) {
        boolean result = true;
        ISharedConfiguration configuration = SWToolsPlatform.getSharedConfigurationSingleton();
        String outputFile = null;
        String configName = configuration.getCommonConfig().getName();
        if (!UtilsText.isEmpty((String)configName)) {
            assert (configName != null);
            outputFile = UtilsFile.makeFullPath((String)path, (String)configName);
        } else {
            outputFile = UtilsFile.makeFullPath((String)path, (String)MEX_FILE_NAME);
        }
        outputFile = UtilsFile.changeFileExtension((String)outputFile, (String)".mex");
        File file = new File(outputFile);
        File parentFile = file.getParentFile();
        if (parentFile != null && UtilsFile.checkAndCreateFolder((File)parentFile, (Logger)LOGGER)) {
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (FileOutputStream out = new FileOutputStream(outputFile);){
                    SharedConfigurationFactory.saveSharedConfigurationToXml((ISharedConfiguration)configuration, (OutputStream)out);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOGGER.warning(e.getMessage());
                result = false;
            }
        } else {
            result = false;
            LOGGER.warning("Can not create folder: " + file.getParentFile());
        }
        return result;
    }

    public static void setMexFileToOpen(@Nullable File mexFile) {
        macMexFileToOpen = mexFile;
    }

    public static boolean loadConfigFromCMD(CmdSection cmdLineArgs) {
        String config = cmdLineArgs.getOptionValue("-Load");
        if (config.isEmpty()) {
            if (macMexFileToOpen != null) {
                config = macMexFileToOpen.getAbsolutePath();
            } else {
                return false;
            }
        }
        Shell shell = null;
        if (!SWToolsProperties.isHeadlessOn()) {
            shell = ShellProvider.getAnyShellParent();
        }
        return ConfigurationUtils.openConfiguration((Shell)shell, (String)config, (ConfigurationUtils.OpenAction)ConfigurationUtils.OpenAction.OPEN_CMD);
    }

    protected static boolean runHeadless(SwToolsProduct tool, CmdSection section) {
        boolean result = true;
        ICmdApplication application = tool.getCmdApp();
        if (application != null) {
            try {
                result = application.run(section);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Problem occured while running tool.", e);
            }
        } else {
            LOGGER.warning("No headless entry point for " + tool.getProductName() + " found, tool cannot run.");
            result = false;
        }
        return result;
    }

    public static boolean getMcuFromCMD(CmdSection cmdLineArgs) {
        boolean success;
        String mcu = cmdLineArgs.getOptionValue("-MCU");
        String board = cmdLineArgs.getOptionValue("-Board");
        String kit = cmdLineArgs.getOptionValue("-Kit");
        String sdkVersion = cmdLineArgs.getOptionValue("-SDKversion");
        String partNum = cmdLineArgs.getOptionValue("-PartNum");
        String configName = cmdLineArgs.getOptionValue("-ConfigName");
        if ((UtilsText.isEmpty((String)mcu) && UtilsText.isEmpty((String)board) && UtilsText.isEmpty((String)kit)) ^ UtilsText.isEmpty((String)sdkVersion)) {
            LOGGER.severe("Both '-MCU' and '-SDKversion' are required.");
            return false;
        }
        if (UtilsText.isEmpty((String)sdkVersion)) {
            return false;
        }
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        ISharedConfiguration config = SharedConfigurationFactory.createSharedConfiguration();
        ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        if (!UtilsText.isEmpty((String)kit)) {
            ITemplateInfo kitInfo = Application.getKitOptionallyDownload(kit, sdkVersion, derivatives);
            if (kitInfo == null) {
                return false;
            }
            mcu = kitInfo.getMasterToolName();
            ConfigurationUtils.applyMexTemplate((ISharedConfiguration)config, (ITemplateInfo)kitInfo, (String)configName, null, null);
            if (Application.getBoardOptionallyDownload(Objects.requireNonNull(config.getCommonConfig().getBoard()), sdkVersion, derivatives) == null) {
                return false;
            }
        } else if (!UtilsText.isEmpty((String)board)) {
            ITemplateInfo boardInfo = Application.getBoardOptionallyDownload(board, sdkVersion, derivatives);
            if (boardInfo == null) {
                return false;
            }
            mcu = boardInfo.getMasterToolName();
            ConfigurationUtils.applyMexTemplate((ISharedConfiguration)config, (ITemplateInfo)boardInfo, (String)configName, null, null);
        }
        CheckStatus status = KExProcessorsProvider.checkOrDownloadProcessor((String)mcu, (String)sdkVersion, (boolean)true);
        switch (status.getStatus()) {
            case NO_REQUIREMENT: {
                return false;
            }
            case MISSING: {
                LOGGER.severe("Selected MCU and SDK combination does not exist in your data. MCU: " + mcu + ", SDK: " + sdkVersion);
                return false;
            }
        }
        IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(mcu, sdkVersion);
        assert (info != null);
        boolean bl = success = !UtilsText.isEmpty((String)mcu) && !UtilsText.isEmpty((String)sdkVersion);
        if (success) {
            if (UtilsText.isEmpty((String)partNum)) {
                partNum = info.getDefaultPartNumber();
            }
            if (!UtilsText.isEmpty((String)configName)) {
                config.setConfigurationName(configName);
            }
            config.setMcuIdentification(McuSelectionFactory.createMcuSelectionIdentification((String)mcu, (String)partNum, (String)sdkVersion, (String)UtilsText.safeString((String)board), (String)UtilsText.safeString((String)kit), (String)""));
            SWToolsPlatform.applyCores((ISharedConfiguration)config, (ISupportedDerivativesForSwTools)derivatives);
            SharedConfigurationFactory.applyNewConfig((ISharedConfiguration)config, (ISharedConfiguration)sharedConfig, (ConfigChangeReason)ConfigChangeReason.NEW_CONFIG);
        }
        return success;
    }

    private static @Nullable ITemplateInfo getBoardOptionallyDownload(String board, String sdkVersion, ISupportedDerivativesForSwTools derivatives) {
        Optional status = KExProcessorsProvider.checkOrDownloadBoard((String)board, (String)sdkVersion, (Level)Level.SEVERE);
        if (!status.orElse(Boolean.TRUE).booleanValue()) {
            LOGGER.severe(() -> "Selected BOARD and SDK combination does not exist in your data. BOARD: " + board + ", SDK: " + sdkVersion);
            return null;
        }
        ITemplateInfo boardInfo = derivatives.getBoardById(board, sdkVersion);
        if (boardInfo == null) {
            LOGGER.severe(() -> "Internal error - did not get the board instance:" + board);
            return null;
        }
        return boardInfo;
    }

    private static @Nullable ITemplateInfo getKitOptionallyDownload(String kit, String sdkVersion, ISupportedDerivativesForSwTools derivatives) {
        Optional status = KExProcessorsProvider.checkOrDownloadKit((String)kit, (String)sdkVersion, (Level)Level.SEVERE);
        if (!status.orElse(Boolean.TRUE).booleanValue()) {
            LOGGER.severe(() -> "Selected KIT and SDK combination does not exist in your data. KIT: " + kit + ", SDK: " + sdkVersion);
            return null;
        }
        ITemplateInfo kitInfo = derivatives.getKitById(kit, sdkVersion);
        if (kitInfo == null) {
            LOGGER.severe(() -> "Internal error - did not get the kit instance:" + kit);
            return null;
        }
        return kitInfo;
    }

    public static void registerUndoRedoListener() {
        ISharedConfiguration config = SharedConfigurationFactory.getSharedConfigurationSingleton();
        UndoRedoConfig.registerConfigListener((ISharedConfiguration)config);
    }
}

