/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.sirius.copypaste;

import java.lang.reflect.Field;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.sirius.diagram.ui.tools.internal.clipboard.SiriusClipboardManager;

public class CopyPasteRestorer {
    private static final Class<SiriusClipboardManager> SIRIUS_CLIPBOARD_MANAGER_CLASS = SiriusClipboardManager.class;
    private static Field clipboardField;
    private static Field sourceDomainField;
    private EditingDomain domain;
    private EObject owner;
    private EditingDomain sourceDomain;
    private Collection<?> theRealClipboard;

    static {
        try {
            clipboardField = SIRIUS_CLIPBOARD_MANAGER_CLASS.getDeclaredField("clipboard");
            clipboardField.setAccessible(true);
            sourceDomainField = SIRIUS_CLIPBOARD_MANAGER_CLASS.getDeclaredField("sourceDomain");
            sourceDomainField.setAccessible(true);
        }
        catch (Exception exception) {}
    }

    public CopyPasteRestorer(EditingDomain domain, EObject owner) {
        this.domain = domain;
        this.owner = owner;
        this.init();
    }

    public void restoreInternalObject(EStructuralFeature featureToFind) {
        if (featureToFind == null) {
            return;
        }
        if (!this.isInitedCorrectly()) {
            return;
        }
        EObject containerObject = CopyPasteRestorer.getContainerObject(this.theRealClipboard, this.owner.eContainer());
        if (containerObject == null) {
            return;
        }
        EStructuralFeature nameFeature = this.owner.eClass().getEStructuralFeature("name");
        if (nameFeature == null) {
            return;
        }
        String name = (String)this.owner.eGet(nameFeature);
        EObject objectFromClipboard = this.getEObjectInClipboard(featureToFind, containerObject, nameFeature, name);
        if (objectFromClipboard == null) {
            return;
        }
        this.copyReferences(objectFromClipboard);
    }

    public void restoreContainer() {
        if (!this.isInitedCorrectly()) {
            return;
        }
        if (this.owner.eContainer() == null) {
            EObject containerObject = CopyPasteRestorer.getContainerObject(this.theRealClipboard, this.owner);
            if (containerObject == null) {
                return;
            }
            this.copyReferences(containerObject);
            return;
        }
    }

    private void init() {
        try {
            this.sourceDomain = (EditingDomain)sourceDomainField.get(SiriusClipboardManager.getInstance());
            this.theRealClipboard = (Collection)clipboardField.get(SiriusClipboardManager.getInstance());
        }
        catch (Exception exception) {}
    }

    private boolean isInitedCorrectly() {
        if (clipboardField == null || sourceDomainField == null) {
            return false;
        }
        if (this.sourceDomain == null) {
            return false;
        }
        if (this.sourceDomain == this.domain) {
            return false;
        }
        return this.theRealClipboard != null;
    }

    private EObject getEObjectInClipboard(EStructuralFeature featureToFind, EObject containerObject, EStructuralFeature nameFeature, String name) {
        Object containment = containerObject.eGet(featureToFind);
        if (containment instanceof Collection) {
            return this.getEObjectFromCollection(featureToFind, containerObject, nameFeature, name);
        }
        EObject eObject = (EObject)containment;
        return eObject;
    }

    private EObject getEObjectFromCollection(EStructuralFeature featureToFind, EObject containerObject, EStructuralFeature nameFeature, String name) {
        Collection collection = (Collection)containerObject.eGet(featureToFind);
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        EObject objectFromClipboard = collection.stream().filter(i -> {
            if (!i.getClass().isInstance(this.owner)) {
                return false;
            }
            String iName = (String)i.eGet(nameFeature);
            return name.equals(iName);
        }).findFirst().orElse(null);
        return objectFromClipboard;
    }

    private static EObject getContainerObject(Collection<?> theRealClipboard, EObject eObject) {
        EStructuralFeature containerNameFeature = eObject.eClass().getEStructuralFeature("name");
        if (containerNameFeature == null) {
            return null;
        }
        String containerName = (String)eObject.eGet(containerNameFeature);
        EObject containerObject = theRealClipboard.parallelStream().filter(o -> {
            if (!o.getClass().isInstance(eObject)) {
                return false;
            }
            String oContainerName = (String)((EObject)o).eGet(containerNameFeature);
            return containerName.equals(oContainerName);
        }).findFirst().orElse(null);
        return containerObject;
    }

    private void copyReferences(EObject objectFromClipboard) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        copier.put((Object)objectFromClipboard, (Object)this.owner);
        copier.copyReferences();
    }
}

