/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.sirius;

import com.nxp.s32ds.ext.sirius.SiriusCore;
import com.nxp.s32ds.ext.sirius.internal.Messages;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.osgi.framework.Bundle;

public class SiriusViewpoints {
    public static Set<Viewpoint> registerViewpoints(Bundle bundle, String designPath) {
        if (bundle != null && designPath != null) {
            String symbolicName = bundle.getSymbolicName();
            URL found = FileLocator.find((Bundle)bundle, (IPath)new Path(designPath), null);
            if (found != null) {
                String designFile = found.getFile();
                Set registered = ViewpointRegistry.getInstance().registerFromPlugin(String.valueOf(symbolicName) + designFile);
                return registered;
            }
        }
        String message = NLS.bind((String)Messages.SiriusViewpoints_e_register_viewpoints, (Object)designPath, (Object)bundle);
        Status error = new Status(4, "com.nxp.s32ds.ext.sirius", message);
        SiriusCore.log((IStatus)error);
        return Collections.emptySet();
    }

    public static Set<Viewpoint> collectViewpoints(List<String> viewpointNames) {
        if (viewpointNames == null || viewpointNames.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Viewpoint> collected = new HashSet<Viewpoint>();
        ViewpointRegistry registry = ViewpointRegistry.getInstance();
        Set viewpoints = registry.getViewpoints();
        for (Viewpoint viewpoint : viewpoints) {
            String name = viewpoint.getName();
            if (!viewpointNames.contains(name)) continue;
            collected.add(viewpoint);
        }
        return collected;
    }
}

