/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.clt.isp.clt;

import com.nxp.s32ds.clt.isp.clt.VersionChecker;
import com.nxp.s32ds.ext.emf.clt.CltEmfControlFlowException;
import com.nxp.s32ds.ext.emf.clt.acceleo.CltAcceleoControlFlowListener;
import com.nxp.s32ds.ext.emf.clt.acceleo.CltAcceleoProcessor;
import com.nxp.s32ds.ext.orbit.cli.CliParsedOptions;
import com.nxp.s32ds.gte.isp.IspGraph;
import com.nxp.s32ds.mdt.vpt.isp.core.standalone.IspStandaloneHelper;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

public class CltIspControlFlowListener
extends CltAcceleoControlFlowListener<CltAcceleoProcessor> {
    protected static Logger logger = Logger.getLogger(CltIspControlFlowListener.class);

    public void beforeRun(CliParsedOptions cliParsedOptions) throws CltEmfControlFlowException {
        this.verifyLicense();
        super.beforeRun(cliParsedOptions);
        String vsdkPath = cliParsedOptions.getOptionValue("vsdkpath");
        Path nioVsdkPath = Paths.get(vsdkPath, new String[0]);
        if (!Files.exists(nioVsdkPath, new LinkOption[0])) {
            throw new CltEmfControlFlowException("VSDK path does not exist:" + nioVsdkPath);
        }
        if (!Files.isDirectory(nioVsdkPath, new LinkOption[0])) {
            throw new CltEmfControlFlowException("VSDK path is not a directory: " + nioVsdkPath);
        }
        String wsPath = cliParsedOptions.getOptionValue("wspath");
        if (wsPath != null) {
            Path nioWsPath = Paths.get(wsPath, new String[0]);
            if (!Files.exists(nioWsPath, new LinkOption[0])) {
                throw new CltEmfControlFlowException("Workspace path does not exist:" + nioWsPath);
            }
            if (!Files.isDirectory(nioWsPath, new LinkOption[0])) {
                throw new CltEmfControlFlowException("Workspace path is not a directory: " + nioWsPath);
            }
        }
        if (!(cliParsedOptions.hasOption("emithost") || cliParsedOptions.hasOption("emitstatic") || cliParsedOptions.hasOption("emitdynamic"))) {
            throw new CltEmfControlFlowException("Nothing to emit, provide at least one option from [emithost|emitdynamic|emitstatic|]");
        }
        String vsdkExtPath = cliParsedOptions.getOptionValue("extPath");
        this.initStandaloneRegistries(vsdkPath, wsPath, vsdkExtPath);
    }

    public void beforeLoadResource(CliParsedOptions cliParsedOptions, Path modelPath) throws CltEmfControlFlowException {
        logger.info((Object)"Reading model...");
    }

    public void beforeValidation(CliParsedOptions cliParsedOptions, EObject eObject) throws CltEmfControlFlowException {
        logger.info((Object)"Validating model...");
    }

    public void beforeProcess(CliParsedOptions cliParsedOptions, EObject eObject, CltAcceleoProcessor processor) throws CltEmfControlFlowException {
        if (!(eObject instanceof IspGraph)) {
            throw new CltEmfControlFlowException("Root model object is not IspGraph.");
        }
        IspGraph ispGraph = (IspGraph)eObject;
        if (cliParsedOptions.hasOption("emitstatic") && ispGraph.getHeartBeatSource() == null) {
            throw new CltEmfControlFlowException("The heart beat source should be set for static sequencer generation.");
        }
        logger.info((Object)"Emitting sources...");
    }

    public void afterRun(CliParsedOptions cliParsedOptions) throws CltEmfControlFlowException {
        logger.info((Object)"Done.");
    }

    protected void verifyLicense() throws CltEmfControlFlowException {
        new VersionChecker().verifyLicense();
    }

    protected void initStandaloneRegistries(String vsdkPath, String wsPath, String extPath) {
        IspStandaloneHelper.initialize((String)vsdkPath, (String)wsPath, (String)extPath);
    }
}

