/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.registry.core;

import com.nxp.s32ds.cle.runtime.hardware.internal.registry.core.HardwareRegistryCoreActivator;
import com.nxp.s32ds.cle.runtime.hardware.internal.registry.core.HardwareRegistryCoreMessages;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyFlashDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashAlgorithmDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashProtocolDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.ProtocolDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.ProtocolRegistry;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class FlashDescriptors {
    public static FlashRegistry getFlashRegistry() {
        FlashRegistry flashRegistry = HardwareRegistryCoreActivator.getDefault().getFlashRegistry();
        return flashRegistry;
    }

    public static List<FlashDescriptor> getFlashDescriptors() {
        FlashRegistry flashRegistry = HardwareRegistryCoreActivator.getDefault().getFlashRegistry();
        return flashRegistry.getFlashDescriptors();
    }

    public static FlashDescriptor getFlashDescriptor(String flashId) {
        FlashRegistry flashRegistry = HardwareRegistryCoreActivator.getDefault().getFlashRegistry();
        return flashRegistry.getFlashDescriptor(flashId);
    }

    public static List<FlashAlgorithmDescriptor> getFlashAlgorithmDescriptors() {
        FlashRegistry flashRegistry = HardwareRegistryCoreActivator.getDefault().getFlashRegistry();
        return flashRegistry.getFlashAlgorithmDescriptors();
    }

    public static FlashAlgorithmDescriptor getFlashAlgorithmDescriptor(String flashAlgorithmId) {
        FlashRegistry flashRegistry = HardwareRegistryCoreActivator.getDefault().getFlashRegistry();
        return flashRegistry.getFlashAlgorithmDescriptor(flashAlgorithmId);
    }

    public static List<ProtocolDescriptor> getProtocolDescriptors(String flashId) {
        HardwareRegistryCoreActivator activator = HardwareRegistryCoreActivator.getDefault();
        FlashRegistry flashRegistry = activator.getFlashRegistry();
        ProtocolRegistry protocolRegistry = activator.getProtocolRegistry();
        List flashProtocolDescriptors = flashRegistry.getFlashProtocolDescriptorsByFlashId(flashId);
        LinkedHashSet<String> protocolIds = new LinkedHashSet<String>();
        for (FlashProtocolDescriptor flashProtocolDescriptor : flashProtocolDescriptors) {
            String protocolId = flashProtocolDescriptor.getProtocolId();
            protocolIds.add(protocolId);
        }
        ArrayList<ProtocolDescriptor> result = new ArrayList<ProtocolDescriptor>();
        for (String protocolId : protocolIds) {
            ProtocolDescriptor protocolDescriptor = protocolRegistry.getProtocolDescriptor(protocolId);
            if (protocolDescriptor == null) continue;
            result.add(protocolDescriptor);
        }
        return result;
    }

    public static List<DeviceDescriptor> getDeviceDescriptorsByFlashId(String flashId) {
        HardwareRegistryCoreActivator activator = HardwareRegistryCoreActivator.getDefault();
        FlashRegistry flashRegistry = activator.getFlashRegistry();
        DeviceRegistry deviceRegistry = activator.getDeviceRegistry();
        List flashAlgorithmDescriptors = flashRegistry.getFlashAlgorithmDescriptorsByFlashId(flashId);
        LinkedHashSet<String> deviceIds = new LinkedHashSet<String>();
        for (FlashAlgorithmDescriptor flashAlgorithmDescriptor : flashAlgorithmDescriptors) {
            String deviceCoreId = flashAlgorithmDescriptor.getDeviceId();
            deviceIds.add(deviceCoreId);
        }
        ArrayList<DeviceDescriptor> result = new ArrayList<DeviceDescriptor>();
        for (String deviceId : deviceIds) {
            DeviceDescriptor deviceDescriptor = deviceRegistry.getDeviceDescriptor(deviceId);
            if (deviceDescriptor == null) continue;
            result.add(deviceDescriptor);
        }
        return result;
    }

    public static List<FamilyDescriptor> getFamilyDescriptors(String flashId) {
        HardwareRegistryCoreActivator activator = HardwareRegistryCoreActivator.getDefault();
        FamilyRegistry familyRegistry = activator.getFamilyRegistry();
        List familyFlashDescriptors = familyRegistry.getFamilyFlashDescriptorsByFlashId(flashId);
        LinkedHashSet<String> familyIds = new LinkedHashSet<String>();
        for (FamilyFlashDescriptor familyFlashDescriptor : familyFlashDescriptors) {
            String familyId = familyFlashDescriptor.getFamilyId();
            familyIds.add(familyId);
        }
        ArrayList<FamilyDescriptor> result = new ArrayList<FamilyDescriptor>();
        for (String familyId : familyIds) {
            FamilyDescriptor familyDescriptor = familyRegistry.getFamilyDescriptor(familyId);
            if (familyDescriptor == null) continue;
            result.add(familyDescriptor);
        }
        return result;
    }

    public static String getFlashLabel(FlashDescriptor flashDescriptor) {
        if (flashDescriptor == null) {
            return null;
        }
        List<FamilyDescriptor> familyDescriptors = FlashDescriptors.getFamilyDescriptors(flashDescriptor.getId());
        if (familyDescriptors.size() == 1) {
            FamilyDescriptor familyDescriptor = familyDescriptors.get(0);
            String label = NLS.bind((String)HardwareRegistryCoreMessages.FlashDescriptors_family_flash_label, (Object)familyDescriptor.getName(), (Object)flashDescriptor.getName());
            return label;
        }
        return flashDescriptor.getName();
    }
}

