/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.registry.core;

import com.nxp.s32ds.cle.runtime.hardware.internal.registry.core.HardwareRegistryCoreActivator;
import com.nxp.s32ds.cle.runtime.hardware.internal.registry.core.HardwareRegistryCoreMessages;
import com.nxp.s32ds.cle.runtime.hardware.registry.BoardDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.BoardDeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.BoardRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.CoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.CoreRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashAlgorithmDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashRegistry;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class DeviceDescriptors {
    public static DeviceRegistry getDeviceRegistry() {
        DeviceRegistry deviceRegistry = HardwareRegistryCoreActivator.getDefault().getDeviceRegistry();
        return deviceRegistry;
    }

    public static List<DeviceDescriptor> getDeviceDescriptors() {
        DeviceRegistry deviceRegistry = HardwareRegistryCoreActivator.getDefault().getDeviceRegistry();
        return deviceRegistry.getDeviceDescriptors();
    }

    public static DeviceDescriptor getDeviceDescriptor(String deviceId) {
        DeviceRegistry deviceRegistry = HardwareRegistryCoreActivator.getDefault().getDeviceRegistry();
        return deviceRegistry.getDeviceDescriptor(deviceId);
    }

    public static List<DeviceCoreDescriptor> getDeviceCoreDescriptors() {
        DeviceRegistry deviceRegistry = HardwareRegistryCoreActivator.getDefault().getDeviceRegistry();
        return deviceRegistry.getDeviceCoreDescriptors();
    }

    public static DeviceCoreDescriptor getDeviceCoreDescriptor(String deviceId) {
        DeviceRegistry deviceRegistry = HardwareRegistryCoreActivator.getDefault().getDeviceRegistry();
        return deviceRegistry.getDeviceCoreDescriptor(deviceId);
    }

    public static List<BoardDescriptor> getBoardDescriptors(String deviceId) {
        HardwareRegistryCoreActivator activator = HardwareRegistryCoreActivator.getDefault();
        BoardRegistry boardRegistry = activator.getBoardRegistry();
        List coreIds = boardRegistry.getBoardDeviceDescriptorsByDeviceId(deviceId);
        ArrayList<BoardDescriptor> result = new ArrayList<BoardDescriptor>();
        for (BoardDeviceDescriptor deviceCore : coreIds) {
            BoardDescriptor coreDescriptor = boardRegistry.getBoardDescriptor(deviceCore.getBoardId());
            if (coreDescriptor == null) continue;
            result.add(coreDescriptor);
        }
        return result;
    }

    public static List<CoreDescriptor> getCoreDescriptors(String deviceId) {
        HardwareRegistryCoreActivator activator = HardwareRegistryCoreActivator.getDefault();
        DeviceRegistry deviceRegistry = activator.getDeviceRegistry();
        CoreRegistry coreRegistry = activator.getCoreRegistry();
        List deviceCoreDescriptors = deviceRegistry.getDeviceCoreDescriptorsByDeviceId(deviceId);
        LinkedHashSet<String> coreIds = new LinkedHashSet<String>();
        for (DeviceCoreDescriptor deviceCoreDescriptor : deviceCoreDescriptors) {
            String coreId = deviceCoreDescriptor.getCoreId();
            coreIds.add(coreId);
        }
        ArrayList<CoreDescriptor> result = new ArrayList<CoreDescriptor>();
        for (String coreId : coreIds) {
            CoreDescriptor coreDescriptor = coreRegistry.getCoreDescriptor(coreId);
            if (coreDescriptor == null) continue;
            result.add(coreDescriptor);
        }
        return result;
    }

    public static List<FamilyDescriptor> getFamilyDescriptors(String deviceId) {
        HardwareRegistryCoreActivator activator = HardwareRegistryCoreActivator.getDefault();
        FamilyRegistry familyRegistry = activator.getFamilyRegistry();
        List familyDeviceDescriptors = familyRegistry.getFamilyDeviceDescriptorsByDeviceId(deviceId);
        LinkedHashSet<String> familyIds = new LinkedHashSet<String>();
        for (FamilyDeviceDescriptor familyDeviceDescriptor : familyDeviceDescriptors) {
            String familyId = familyDeviceDescriptor.getFamilyId();
            familyIds.add(familyId);
        }
        ArrayList<FamilyDescriptor> result = new ArrayList<FamilyDescriptor>();
        for (String familyId : familyIds) {
            FamilyDescriptor familyDescriptor = familyRegistry.getFamilyDescriptor(familyId);
            if (familyDescriptor == null) continue;
            result.add(familyDescriptor);
        }
        return result;
    }

    public static List<FlashAlgorithmDescriptor> getFlashAlgorithmDescriptorsByDeviceId(String deviceId) {
        HardwareRegistryCoreActivator activator = HardwareRegistryCoreActivator.getDefault();
        FlashRegistry flashRegistry = activator.getFlashRegistry();
        return flashRegistry.getFlashAlgorithmDescriptorsByDeviceId(deviceId);
    }

    public static List<FlashDescriptor> getFlashDescriptorsByDeviceId(String deviceId) {
        HardwareRegistryCoreActivator activator = HardwareRegistryCoreActivator.getDefault();
        FlashRegistry flashRegistry = activator.getFlashRegistry();
        List flashAlgorithmDescriptors = flashRegistry.getFlashAlgorithmDescriptorsByDeviceId(deviceId);
        LinkedHashSet<String> flashIds = new LinkedHashSet<String>();
        for (FlashAlgorithmDescriptor flashAlgorithmDescriptor : flashAlgorithmDescriptors) {
            String flashId = flashAlgorithmDescriptor.getFlashId();
            flashIds.add(flashId);
        }
        ArrayList<FlashDescriptor> result = new ArrayList<FlashDescriptor>();
        for (String flashId : flashIds) {
            FlashDescriptor flashDescriptor = flashRegistry.getFlashDescriptor(flashId);
            if (flashDescriptor == null) continue;
            result.add(flashDescriptor);
        }
        return result;
    }

    public static String getDeviceLabel(DeviceDescriptor deviceDescriptor) {
        if (deviceDescriptor == null) {
            return null;
        }
        List<FamilyDescriptor> familyDescriptors = DeviceDescriptors.getFamilyDescriptors(deviceDescriptor.getId());
        if (familyDescriptors.size() == 1) {
            FamilyDescriptor familyDescriptor = familyDescriptors.get(0);
            String label = NLS.bind((String)HardwareRegistryCoreMessages.DeviceDescriptors_family_device_label, (Object)familyDescriptor.getName(), (Object)deviceDescriptor.getName());
            return label;
        }
        return deviceDescriptor.getName();
    }

    public static String getDeviceCoreLabel(DeviceCoreDescriptor deviceCoreDescriptor) {
        if (deviceCoreDescriptor == null) {
            return null;
        }
        DeviceDescriptor deviceDescriptor = DeviceDescriptors.getDeviceDescriptor(deviceCoreDescriptor.getDeviceId());
        FamilyDescriptor familyDescriptor = null;
        if (deviceDescriptor != null) {
            List<FamilyDescriptor> familyDescriptors = DeviceDescriptors.getFamilyDescriptors(deviceDescriptor.getId());
            if (!familyDescriptors.isEmpty() && (familyDescriptor = familyDescriptors.get(0)) != null) {
                Object[] bindings = new Object[]{familyDescriptor.getName(), deviceDescriptor.getName(), deviceCoreDescriptor.getName()};
                String label = NLS.bind((String)HardwareRegistryCoreMessages.DeviceDescriptors_family_device_devicecore_label, (Object[])bindings);
                return label;
            }
            Object[] bindings = new Object[]{deviceDescriptor.getName(), deviceCoreDescriptor.getName()};
            String label = NLS.bind((String)HardwareRegistryCoreMessages.DeviceDescriptors_device_devicecore, (Object[])bindings);
            return label;
        }
        return deviceCoreDescriptor.getName();
    }
}

