/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.internal.registry.core;

import com.nxp.s32ds.cle.runtime.hardware.internal.registry.BoardDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.hardware.internal.registry.BoardDeviceDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.hardware.internal.registry.CoreDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.hardware.internal.registry.DeviceCoreDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.hardware.internal.registry.DeviceDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.hardware.internal.registry.FamilyDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.hardware.internal.registry.FamilyDeviceDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.hardware.internal.registry.FamilyFlashDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.hardware.internal.registry.FlashAlgorithmDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.hardware.internal.registry.FlashDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.hardware.internal.registry.FlashProtocolDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.hardware.internal.registry.ProtocolDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.hardware.registry.BoardContributor;
import com.nxp.s32ds.cle.runtime.hardware.registry.BoardDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.BoardDeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.BoardRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.CoreContributor;
import com.nxp.s32ds.cle.runtime.hardware.registry.CoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.CoreRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceContributor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyContributor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyFlashDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashAlgorithmDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashContributor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashProtocolDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.ProtocolContributor;
import com.nxp.s32ds.cle.runtime.hardware.registry.ProtocolDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.ProtocolRegistry;
import com.nxp.s32ds.ext.rcp.runtime.Extensions;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class HardwareRegistryCoreActivator
implements BundleActivator {
    public static final String BUNDLE_SYMBOLIC_NAME = "com.nxp.s32ds.cle.runtime.hardware.registry.core";
    public static final String CONTRIBUTOR_ELEMENT = "contributor";
    public static final String CONTRIBUTOR_CLASS_ATTRIBUTE = "class";
    public static final String BOARDS_EXTENSION_POINT = "boards";
    public static final String BOARD_ELEMENT = "board";
    public static final String BOARD_DEVICE_ELEMENT = "boardDevice";
    public static final String CORES_EXTENSION_POINT = "cores";
    public static final String CORE_ELEMENT = "core";
    public static final String DEVICES_EXTENSION_POINT = "devices";
    public static final String DEVICE_ELEMENT = "device";
    public static final String DEVICE_CORE_ELEMENT = "deviceCore";
    public static final String FAMILIES_EXTENSION_POINT = "families";
    public static final String FAMILY_ELEMENT = "family";
    public static final String FAMILY_DEVICE_ELEMENT = "familyDevice";
    public static final String FAMILY_FLASH_ELEMENT = "familyFlash";
    public static final String FLASHES_EXTENSION_POINT = "flashes";
    public static final String FLASH_ELEMENT = "flash";
    public static final String FLASH_PROTOCOL_ELEMENT = "flashProtocol";
    public static final String FLASH_ALORITHM_ELEMENT = "flashAlgorithm";
    public static final String PROTOCOLS_EXTENSION_POINT = "protocols";
    public static final String PROTOCOL_ELEMENT = "protocol";
    private static HardwareRegistryCoreActivator activator;
    private static BundleContext context;
    private ServiceTracker<BoardRegistry, BoardRegistry> boardRegistryServiceTracker;
    private BoardRegistry boardRegistryService;
    private ServiceTracker<CoreRegistry, CoreRegistry> coreRegistryServiceTracker;
    private CoreRegistry coreRegistryService;
    private ServiceTracker<DeviceRegistry, DeviceRegistry> deviceRegistryServiceTracker;
    private DeviceRegistry deviceRegistryService;
    private ServiceTracker<FamilyRegistry, FamilyRegistry> familyRegistryServiceTracker;
    private FamilyRegistry familyRegistryService;
    private ServiceTracker<FlashRegistry, FlashRegistry> flashRegistryServiceTracker;
    private FlashRegistry flashRegistryService;
    private ServiceTracker<ProtocolRegistry, ProtocolRegistry> protocolRegistryServiceTracker;
    private ProtocolRegistry protocolRegistryService;

    public static HardwareRegistryCoreActivator getDefault() {
        return activator;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        activator = this;
        String boardRegistryClassName = BoardRegistry.class.getName();
        this.boardRegistryServiceTracker = new ServiceTracker(context, boardRegistryClassName, null);
        this.boardRegistryServiceTracker.open();
        this.boardRegistryService = (BoardRegistry)this.boardRegistryServiceTracker.getService();
        String coreRegistryClassName = CoreRegistry.class.getName();
        this.coreRegistryServiceTracker = new ServiceTracker(context, coreRegistryClassName, null);
        this.coreRegistryServiceTracker.open();
        this.coreRegistryService = (CoreRegistry)this.coreRegistryServiceTracker.getService();
        String deviceRegistryClassName = DeviceRegistry.class.getName();
        this.deviceRegistryServiceTracker = new ServiceTracker(context, deviceRegistryClassName, null);
        this.deviceRegistryServiceTracker.open();
        this.deviceRegistryService = (DeviceRegistry)this.deviceRegistryServiceTracker.getService();
        String familyRegistryClassName = FamilyRegistry.class.getName();
        this.familyRegistryServiceTracker = new ServiceTracker(context, familyRegistryClassName, null);
        this.familyRegistryServiceTracker.open();
        this.familyRegistryService = (FamilyRegistry)this.familyRegistryServiceTracker.getService();
        String flashRegistryClassName = FlashRegistry.class.getName();
        this.flashRegistryServiceTracker = new ServiceTracker(context, flashRegistryClassName, null);
        this.flashRegistryServiceTracker.open();
        this.flashRegistryService = (FlashRegistry)this.flashRegistryServiceTracker.getService();
        String protocolRegistryClassName = ProtocolRegistry.class.getName();
        this.protocolRegistryServiceTracker = new ServiceTracker(context, protocolRegistryClassName, null);
        this.protocolRegistryServiceTracker.open();
        this.protocolRegistryService = (ProtocolRegistry)this.protocolRegistryServiceTracker.getService();
        this.registerBoards(this.boardRegistryService);
        this.registerCores(this.coreRegistryService);
        this.registerDevices(this.deviceRegistryService);
        this.registerFamilies(this.familyRegistryService);
        this.registerFlashes(this.flashRegistryService);
        this.registerProtocols(this.protocolRegistryService);
    }

    private void registerBoards(BoardRegistry registry) {
        String ns = BUNDLE_SYMBOLIC_NAME;
        String ep = BOARDS_EXTENSION_POINT;
        String board = BOARD_ELEMENT;
        String id = "id";
        List boardElements = Extensions.getConfigrationElements((String)ns, (String)ep, (String)board, (String[])new String[]{id});
        for (IConfigurationElement element : boardElements) {
            BoardDescriptorImplementation descriptor = new BoardDescriptorImplementation(element);
            registry.addBoardDescriptor((BoardDescriptor)descriptor);
        }
        String boardDevice = BOARD_DEVICE_ELEMENT;
        String boardId = "boardId";
        String deviceId = "deviceId";
        List familyDeviceElements = Extensions.getConfigrationElements((String)ns, (String)ep, (String)boardDevice, (String[])new String[]{boardId, deviceId});
        for (IConfigurationElement element : familyDeviceElements) {
            BoardDeviceDescriptorImplementation reference = new BoardDeviceDescriptorImplementation(element);
            registry.addBoardDeviceDescriptor((BoardDeviceDescriptor)reference);
        }
        String contributor = CONTRIBUTOR_ELEMENT;
        String attribute = CONTRIBUTOR_CLASS_ATTRIBUTE;
        Class<BoardContributor> clazz = BoardContributor.class;
        List executables = Extensions.createSimpleExecutableExtensions((String)ns, (String)ep, (String)contributor, (String)attribute, clazz);
        for (BoardContributor executable : executables) {
            executable.contribute(registry);
        }
    }

    private void registerCores(CoreRegistry registry) {
        String ns = BUNDLE_SYMBOLIC_NAME;
        String ep = CORES_EXTENSION_POINT;
        String core = CORE_ELEMENT;
        String id = "id";
        List coreElements = Extensions.getConfigrationElements((String)ns, (String)ep, (String)core, (String[])new String[]{id});
        for (IConfigurationElement element : coreElements) {
            CoreDescriptorImplementation descriptor = new CoreDescriptorImplementation(element);
            registry.addCoreDescriptor((CoreDescriptor)descriptor);
        }
        String contributor = CONTRIBUTOR_ELEMENT;
        String attribute = CONTRIBUTOR_CLASS_ATTRIBUTE;
        Class<CoreContributor> clazz = CoreContributor.class;
        List executables = Extensions.createSimpleExecutableExtensions((String)ns, (String)ep, (String)contributor, (String)attribute, clazz);
        for (CoreContributor executable : executables) {
            executable.contribute(registry);
        }
    }

    private void registerDevices(DeviceRegistry registry) {
        String ns = BUNDLE_SYMBOLIC_NAME;
        String ep = DEVICES_EXTENSION_POINT;
        String device = DEVICE_ELEMENT;
        String id = "id";
        List deviceElements = Extensions.getConfigrationElements((String)ns, (String)ep, (String)device, (String[])new String[]{id});
        for (IConfigurationElement element : deviceElements) {
            DeviceDescriptorImplementation descriptor = new DeviceDescriptorImplementation(element);
            registry.addDeviceDescriptor((DeviceDescriptor)descriptor);
        }
        String deviceCore = DEVICE_CORE_ELEMENT;
        String deviceId = "deviceId";
        String coreId = "coreId";
        List familyDeviceElements = Extensions.getConfigrationElements((String)ns, (String)ep, (String)deviceCore, (String[])new String[]{deviceId, coreId});
        for (IConfigurationElement element : familyDeviceElements) {
            DeviceCoreDescriptorImplementation reference = new DeviceCoreDescriptorImplementation(element);
            registry.addDeviceCoreDescriptor((DeviceCoreDescriptor)reference);
        }
        String contributor = CONTRIBUTOR_ELEMENT;
        String attribute = CONTRIBUTOR_CLASS_ATTRIBUTE;
        Class<DeviceContributor> clazz = DeviceContributor.class;
        List executables = Extensions.createSimpleExecutableExtensions((String)ns, (String)ep, (String)contributor, (String)attribute, clazz);
        for (DeviceContributor executable : executables) {
            executable.contribute(registry);
        }
    }

    private void registerFamilies(FamilyRegistry registry) {
        String ns = BUNDLE_SYMBOLIC_NAME;
        String ep = FAMILIES_EXTENSION_POINT;
        String family = FAMILY_ELEMENT;
        String id = "id";
        List familyElements = Extensions.getConfigrationElements((String)ns, (String)ep, (String)family, (String[])new String[]{id});
        for (IConfigurationElement element : familyElements) {
            FamilyDescriptorImplementation descriptor = new FamilyDescriptorImplementation(element);
            registry.addFamilyDescriptor((FamilyDescriptor)descriptor);
        }
        this.registerFamilyDevices(registry, ns, ep);
        this.registerFamilyFlashes(registry, ns, ep);
        String contributor = CONTRIBUTOR_ELEMENT;
        String attribute = CONTRIBUTOR_CLASS_ATTRIBUTE;
        Class<FamilyContributor> clazz = FamilyContributor.class;
        List executables = Extensions.createSimpleExecutableExtensions((String)ns, (String)ep, (String)contributor, (String)attribute, clazz);
        for (FamilyContributor executable : executables) {
            executable.contribute(registry);
        }
    }

    private void registerFamilyDevices(FamilyRegistry registry, String ns, String ep) {
        List familyDeviceElements = Extensions.getConfigrationElements((String)ns, (String)ep, (String)FAMILY_DEVICE_ELEMENT, (String[])new String[]{"familyId", "deviceId"});
        for (IConfigurationElement element : familyDeviceElements) {
            FamilyDeviceDescriptorImplementation reference = new FamilyDeviceDescriptorImplementation(element);
            registry.addFamilyDeviceDescriptor((FamilyDeviceDescriptor)reference);
        }
    }

    private void registerFamilyFlashes(FamilyRegistry registry, String ns, String ep) {
        List familyDeviceElements = Extensions.getConfigrationElements((String)ns, (String)ep, (String)FAMILY_FLASH_ELEMENT, (String[])new String[]{"familyId", "flashId"});
        for (IConfigurationElement element : familyDeviceElements) {
            FamilyFlashDescriptorImplementation reference = new FamilyFlashDescriptorImplementation(element);
            registry.addFamilyFlashDescriptor((FamilyFlashDescriptor)reference);
        }
    }

    private void registerFlashes(FlashRegistry registry) {
        String ns = BUNDLE_SYMBOLIC_NAME;
        String ep = FLASHES_EXTENSION_POINT;
        String flash = FLASH_ELEMENT;
        String id = "id";
        List flashElements = Extensions.getConfigrationElements((String)ns, (String)ep, (String)flash, (String[])new String[]{id});
        for (IConfigurationElement element : flashElements) {
            FlashDescriptorImplementation descriptor = new FlashDescriptorImplementation(element);
            registry.addFlashDescriptor((FlashDescriptor)descriptor);
        }
        this.registerFlashProtocols(registry, ns, ep);
        this.registerFlashAlgorithms(registry, ns, ep);
        String contributor = CONTRIBUTOR_ELEMENT;
        String attribute = CONTRIBUTOR_CLASS_ATTRIBUTE;
        Class<FlashContributor> clazz = FlashContributor.class;
        List executables = Extensions.createSimpleExecutableExtensions((String)ns, (String)ep, (String)contributor, (String)attribute, clazz);
        for (FlashContributor executable : executables) {
            executable.contribute(registry);
        }
    }

    private void registerFlashProtocols(FlashRegistry registry, String ns, String ep) {
        List flashProtocolElements = Extensions.getConfigrationElements((String)ns, (String)ep, (String)FLASH_PROTOCOL_ELEMENT, (String[])new String[]{"flashId", "protocolId"});
        for (IConfigurationElement element : flashProtocolElements) {
            FlashProtocolDescriptorImplementation reference = new FlashProtocolDescriptorImplementation(element);
            registry.addFlashProtocolDescriptor((FlashProtocolDescriptor)reference);
        }
    }

    private void registerFlashAlgorithms(FlashRegistry registry, String ns, String ep) {
        List flashAlgorithmElements = Extensions.getConfigrationElements((String)ns, (String)ep, (String)FLASH_ALORITHM_ELEMENT, (String[])new String[]{"id", "flashId", "deviceId"});
        for (IConfigurationElement element : flashAlgorithmElements) {
            FlashAlgorithmDescriptorImplementation reference = new FlashAlgorithmDescriptorImplementation(element);
            registry.addFlashAlgorithmDescriptor((FlashAlgorithmDescriptor)reference);
        }
    }

    private void registerProtocols(ProtocolRegistry registry) {
        String ns = BUNDLE_SYMBOLIC_NAME;
        String ep = PROTOCOLS_EXTENSION_POINT;
        String protocol = PROTOCOL_ELEMENT;
        String id = "id";
        List protocolElements = Extensions.getConfigrationElements((String)ns, (String)ep, (String)protocol, (String[])new String[]{id});
        for (IConfigurationElement element : protocolElements) {
            ProtocolDescriptorImplementation descriptor = new ProtocolDescriptorImplementation(element);
            registry.addProtocolDescriptor((ProtocolDescriptor)descriptor);
        }
        String contributor = CONTRIBUTOR_ELEMENT;
        String attribute = CONTRIBUTOR_CLASS_ATTRIBUTE;
        Class<ProtocolContributor> clazz = ProtocolContributor.class;
        List executables = Extensions.createSimpleExecutableExtensions((String)ns, (String)ep, (String)contributor, (String)attribute, clazz);
        for (ProtocolContributor executable : executables) {
            executable.contribute(registry);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.boardRegistryServiceTracker.close();
        this.boardRegistryServiceTracker = null;
        this.boardRegistryService = null;
        this.coreRegistryServiceTracker.close();
        this.coreRegistryServiceTracker = null;
        this.coreRegistryService = null;
        this.deviceRegistryServiceTracker.close();
        this.deviceRegistryServiceTracker = null;
        this.deviceRegistryService = null;
        this.familyRegistryServiceTracker.close();
        this.familyRegistryServiceTracker = null;
        this.familyRegistryService = null;
        this.flashRegistryServiceTracker.close();
        this.flashRegistryServiceTracker = null;
        this.flashRegistryService = null;
        this.protocolRegistryServiceTracker.close();
        this.protocolRegistryServiceTracker = null;
        this.protocolRegistryService = null;
        activator = null;
        context = null;
    }

    public BoardRegistry getBoardRegistry() {
        return this.boardRegistryService;
    }

    public CoreRegistry getCoreRegistry() {
        return this.coreRegistryService;
    }

    public DeviceRegistry getDeviceRegistry() {
        return this.deviceRegistryService;
    }

    public FamilyRegistry getFamilyRegistry() {
        return this.familyRegistryService;
    }

    public FlashRegistry getFlashRegistry() {
        return this.flashRegistryService;
    }

    public ProtocolRegistry getProtocolRegistry() {
        return this.protocolRegistryService;
    }
}

