/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core.internal.commanderview.handlers;

import com.freescale.s32ds.cdt.core.internal.commanderview.Activator;
import com.freescale.s32ds.cdt.core.internal.commanderview.handlers.BaseProjectContextHandler;
import com.freescale.s32ds.cdt.core.internal.commanderview.handlers.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationSelectionDialog;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class BaseLaunchConfigContextHandler
extends BaseProjectContextHandler {
    @Override
    public boolean isEnabled(Map<String, ?> context) {
        return super.isEnabled(context) && (context.get("launchConfig") != null || (Boolean)context.get("multipleLaunchConfig") != false);
    }

    public void launch(ILaunchGroup group, IProject project, IStructuredSelection selection) {
        ILaunchConfiguration config = BaseLaunchConfigContextHandler.getLaunchConfiguration(group, project, (ISelection)selection, true, null);
        if (config != null) {
            BaseLaunchConfigContextHandler.launch(config, group.getMode());
        }
    }

    public static ILaunchConfiguration getLaunchConfiguration(ILaunchGroup group, IProject project, ISelection selection, boolean prompt, boolean[] multiple) {
        ILaunchConfiguration[] configs = null;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        try {
            configs = launchManager.getLaunchConfigurations();
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        switch (configs.length) {
            case 0: {
                return null;
            }
            case 1: {
                return configs[0];
            }
        }
        if (prompt) {
            return BaseLaunchConfigContextHandler.showConfigurationSelectionDialog(Arrays.asList(configs), group.getMode());
        }
        multiple[0] = true;
        return null;
    }

    protected static ILaunchConfiguration showConfigurationSelectionDialog(List<?> configurations, String mode) {
        ArrayList<ILaunchConfiguration> confsTemp = new ArrayList<ILaunchConfiguration>();
        try {
            for (Object iLaunchConfiguration : configurations) {
                if (!(iLaunchConfiguration instanceof ILaunchConfiguration) || !((ILaunchConfiguration)iLaunchConfiguration).supportsMode(mode)) continue;
                confsTemp.add((ILaunchConfiguration)iLaunchConfiguration);
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        LaunchConfigurationSelectionDialog lsd = new LaunchConfigurationSelectionDialog(DebugUIPlugin.getShell(), confsTemp){

            protected String getViewerLabel() {
                return Messages.BaseLaunchConfigContextHandler_0;
            }
        };
        if (lsd.open() == 0) {
            return (ILaunchConfiguration)lsd.getResult()[0];
        }
        return null;
    }

    public static ILaunchGroup getDebugLaunchGroup() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup("org.eclipse.debug.ui.launchGroup.debug");
    }

    private static void launch(ILaunchConfiguration configuration, String mode) {
        DebugUITools.launch((ILaunchConfiguration)configuration, (String)mode);
    }
}

