/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.validation;

import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.s32debugger.internal.validation.S32DebuggerErrorMessages;
import com.nxp.s32ds.debug.ide.s32debugger.internal.validation.S32DebuggerParametersNamesMessages;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerParams;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerStartupParams;
import com.nxp.s32ds.debug.ide.validation.CommonFieldValidator;
import com.nxp.s32ds.debug.ide.validation.ErrorMessages;
import com.nxp.s32ds.debug.ide.validation.IPValidator;
import com.nxp.s32ds.debug.ide.validation.NumberFieldValidator;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class S32DebuggerAttributesValidator {
    private static final int MINIMAL_JTAG_SPEED_KHZ = 16000;
    private static final int MAXIMUM_JTAG_SPEED_KHZ = 3000000;
    private static final int MAXIMUM_TIME_VALUE = 10000;
    private static final int MAXIMUM_PORT_VALUE = 65535;
    private static final int ZERO_VALUE = 0;
    private String virtualDeviceIP;

    private void processStatus(IStatus status, ArrayList<IStatus> errors) {
        if (!status.isOK()) {
            errors.add(status);
        }
    }

    public String getVirtualDeviceIP() {
        return this.virtualDeviceIP;
    }

    public ArrayList<IStatus> validateDebuggerParameters(S32DebuggerParams debuggerParams, boolean checkForLaunch) {
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        String deviceName = debuggerParams.getDevice();
        this.processStatus(new CommonFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_device, false, false).validate((Object)("Select device".equals(deviceName) ? "" : deviceName)), errors);
        if (debuggerParams.isInitialCore()) {
            if (debuggerParams.isUseEthernet()) {
                String hostOrIP = debuggerParams.getProbeHostnameOrIP();
                this.processStatus(new IPValidator(S32DebuggerParametersNamesMessages.FieldValidator_hostname_or_ip).validate((Object)hostOrIP), errors);
                this.virtualDeviceIP = DebuggerUtils.getVirtualIPFromHostOrIP((String)hostOrIP);
            } else {
                int errorsNumber = errors.size();
                String deviceQualifier = debuggerParams.getDevicePort();
                this.processStatus(new CommonFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_usb_device, false, false).validate((Object)deviceQualifier), errors);
                if (checkForLaunch && errorsNumber == errors.size()) {
                    this.virtualDeviceIP = DebuggerUtils.getVirtualIPFromDevice((String)deviceQualifier);
                    if (this.virtualDeviceIP == null) {
                        errors.add((IStatus)new Status(4, "com.nxp.s32ds.debug.ide.s32debugger.validation", S32DebuggerErrorMessages.S32DebuggerLaunchAttributesReader_wrong_device));
                    }
                }
            }
            this.processStatus(new NumberFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_jtag_speed_khz, 16000, 3000000).validate((Object)debuggerParams.getJtagSpeedKHz()), errors);
            if (debuggerParams.isDoResetAndDelay()) {
                this.processStatus(new NumberFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_delay, 0, 10000).validate((Object)debuggerParams.getDelayInMSeconds()), errors);
            }
        }
        this.processStatus(new NumberFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_remote_timeout, 0, 10000).validate((Object)debuggerParams.getRemoteTimeoutInSeconds()), errors);
        this.processStatus(new NumberFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_gdb_server_port, 0, 65535).validate((Object)debuggerParams.getServerPort()), errors);
        this.processStatus(new NumberFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_semihosting_port, 0, 65535).validate((Object)debuggerParams.getSemihostingPort()), errors);
        this.processStatus(new CommonFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_script, true, false).validate((Object)debuggerParams.getInitializationScript()), errors);
        this.processStatus(new CommonFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_client, true, true).validate((Object)debuggerParams.getClientExecutable()), errors);
        errors.addAll(debuggerParams.getReadErrors());
        return errors;
    }

    public ArrayList<IStatus> validateStartupParameters(S32DebuggerStartupParams startupParams) {
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        if (startupParams.isDoLoadImage() && !startupParams.isUseProjectBinaryForImage()) {
            this.processStatus(new CommonFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_image_binary, true, false).validate((Object)startupParams.getImageFileName()), errors);
        }
        if (startupParams.isDoLoadSymbols() && !startupParams.isUseProjectBinaryForSymbols()) {
            this.processStatus(new CommonFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_symbols_binary, true, false).validate((Object)startupParams.getSymbolsFileName()), errors);
        }
        if (startupParams.isDoSetPcRegister()) {
            this.processStatus(new CommonFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_pc_register_value, false, false).validate((Object)startupParams.getPcRegisterValue()), errors);
        }
        if (startupParams.isDoSetStopAt()) {
            this.processStatus(new CommonFieldValidator(S32DebuggerParametersNamesMessages.FieldValidator_breakpoint_address, false, false).validate((Object)startupParams.getStopAt()), errors);
        }
        errors.addAll(startupParams.getReadErrors());
        return errors;
    }

    public IStatus validateParameters(S32DebuggerParams debuggerParams, S32DebuggerStartupParams startupParams, boolean checkForLaunch) {
        ArrayList debuggerErrors = this.validateDebuggerParameters(debuggerParams, checkForLaunch);
        ArrayList<IStatus> startupErrors = this.validateStartupParameters(startupParams);
        ArrayList errors = debuggerErrors;
        errors.addAll(startupErrors);
        errors = (ArrayList)errors.stream().filter(status -> status.getSeverity() == 4).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            return new MultiStatus("com.nxp.s32ds.debug.ide.s32debugger.validation", 4, errors.toArray(new IStatus[0]), ErrorMessages.LaunchSequence_wrong_attributes, null);
        }
        return Status.OK_STATUS;
    }
}

