/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.icf.vsdk;

import com.nxp.s32ds.mdt.icf.internal.vsdk.IcfVsdkActivator;
import com.nxp.s32ds.mdt.icf.internal.vsdk.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.eclipse.osgi.util.NLS;

public class IcfVsdkProperties {
    private static final String DEFAULT_PATH_TO_HEADER = "isp/inc/seq_graph_meta.h";
    private static final String DEFAULT_VIU_TYPEDEF_NAME = "VIU_CameraType_t";
    private static final String DEFAULT_MIPI_TYPEDEF_NAME = "CSI_CameraType_t";
    private static final String DEFAULT_KERNELS_ROOT = "isp/kernels/generic";
    private static final String PATH_TO_HEADER_KEY = "icf.path.to.header";
    private static final String VIU_TYPEDEF_NAME_KEY = "icf.viu.camera.type";
    private static final String MIPI_TYPEDEF_NAME_KEY = "icf.mipi.camera.type";
    private static final String KERNELS_ROOT_KEY = "icf.kernels.root";
    private String pathToHeader = "isp/inc/seq_graph_meta.h";
    private String viuTypedefName = "VIU_CameraType_t";
    private String mipiTypedefName = "CSI_CameraType_t";
    private String kernelsRoot = "isp/kernels/generic";

    public IcfVsdkProperties() {
    }

    public IcfVsdkProperties(String filename) {
        if (filename == null || filename.trim().isEmpty()) {
            throw new IllegalArgumentException("Argument filename is null.");
        }
        this.readIcfVsdkProperties(filename);
    }

    private void readIcfVsdkProperties(String filename) {
        Path path = Paths.get(filename, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            IcfVsdkActivator.getInstance().logError(NLS.bind((String)Messages.IcfVsdkProperties_file_not_exist_0, (Object)path));
            return;
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            IcfVsdkActivator.getInstance().logError(NLS.bind((String)Messages.IcfVsdkProperties_is_not_a_file_0, (Object)path));
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inStream = Files.newInputStream(path, new OpenOption[0]);){
                Properties props = new Properties();
                props.load(inStream);
                this.pathToHeader = props.getProperty(PATH_TO_HEADER_KEY, DEFAULT_PATH_TO_HEADER);
                this.viuTypedefName = props.getProperty(VIU_TYPEDEF_NAME_KEY, DEFAULT_VIU_TYPEDEF_NAME);
                this.mipiTypedefName = props.getProperty(MIPI_TYPEDEF_NAME_KEY, DEFAULT_MIPI_TYPEDEF_NAME);
                this.kernelsRoot = props.getProperty(KERNELS_ROOT_KEY, DEFAULT_KERNELS_ROOT);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            IcfVsdkActivator.getInstance().logError(e.getMessage(), e);
        }
    }

    public String getPathToHeader() {
        return this.pathToHeader;
    }

    public String getViuTypedefName() {
        return this.viuTypedefName;
    }

    public String getMipiTypedefName() {
        return this.mipiTypedefName;
    }

    public String getKernelsRoot() {
        return this.kernelsRoot;
    }
}

