/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.pi.imports;

import com.freescale.s32ds.cross.core.LaunchSetup;
import com.freescale.s32ds.cross.core.ProjectSettings;
import com.freescale.s32ds.cross.wizard.EmbSysSettingsUtil;
import com.freescale.s32ds.cross.wizard.imports.LaunchConfigUtil;
import com.freescale.s32ds.cross.wizard.pi.ProjectInfoPathProcessor;
import com.freescale.s32ds.cross.wizard.pi.S32DSWizardPiPlugin;
import com.freescale.s32ds.cross.wizard.pi.imports.IOptionProcessor;
import com.freescale.s32ds.cross.wizard.pi.imports.OptionDelta;
import com.freescale.s32ds.cross.wizard.pi.imports.PIReader;
import com.freescale.s32ds.cross.wizard.pi.imports.ProjectInfoImportSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.debug.ui.importexecutable.Messages;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.ui.wizards.CfgHolder;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;

public class ProjectInfoImporter {
    private final ProjectInfoImportSettings settings;

    public ProjectInfoImporter(ProjectInfoImportSettings settings) {
        this.settings = settings;
    }

    public void createProject(IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectName = this.settings.getProjectName();
        IProject project = workspace.getRoot().getProject(projectName);
        IProjectDescription description = ProjectInfoImporter.createNewProjectDescription(projectName, this.settings);
        monitor.beginTask("Create CDT project...", 4000);
        CCorePlugin.getDefault().createCDTProject(description, project, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1000));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.setProjectDescription(project, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1000));
        project.open(128, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1000));
        monitor.worked(2000);
        String dev = this.settings.mapToS32DSdevice();
        String coreId = this.settings.mapToS32DScore();
        ProjectSettings.createHWPrefs((IProject)project, (String)dev, (String)coreId);
        monitor.done();
    }

    private void writeResult(String copyResult, final IProject iProject) {
        try {
            final String string = String.valueOf(iProject.getLocation().toOSString()) + File.separator + "copyErrorLog.txt";
            Files.write(Paths.get(string, new String[0]), copyResult.getBytes(), new OpenOption[0]);
            new UIJob("Open ErrorLog.xml"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        File file = new File(string);
                        IFile ifile = ResourceLookup.selectFileForLocationURI((URI)file.toURI(), (IProject)iProject);
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)ifile);
                        return Status.OK_STATUS;
                    }
                    catch (PartInitException e) {
                        S32DSWizardPiPlugin.log(e);
                        return Status.CANCEL_STATUS;
                    }
                }
            }.schedule();
        }
        catch (IOException e) {
            S32DSWizardPiPlugin.log(e);
        }
    }

    private ICSourceEntry[] getSources(IProject project) {
        ArrayList<String> forSrc = new ArrayList<String>();
        PIReader pi = this.settings.getPiReader();
        for (String srcPath : pi.getSourcePaths()) {
            if (".".equals(srcPath)) {
                forSrc.add("");
                continue;
            }
            forSrc.add(PIReader.makeRelative(srcPath, pi));
        }
        try {
            return ProjectInfoImporter.createSources(forSrc, project);
        }
        catch (CoreException e) {
            S32DSWizardPiPlugin.log(e);
            return new ICSourceEntry[0];
        }
    }

    public static ICSourceEntry[] createSources(List<String> forSrc, IProject project) throws CoreException {
        LinkedHashSet<String> unique = new LinkedHashSet<String>(forSrc);
        ICSourceEntry[] result = new ICSourceEntry[]{};
        for (String src : unique) {
            IPath srcPath = Path.fromOSString((String)src);
            result = CDataUtil.setExcluded((IPath)srcPath, (boolean)true, (boolean)false, (ICSourceEntry[])result);
        }
        return result;
    }

    private static IProjectDescription createNewProjectDescription(String projectName, ProjectInfoImportSettings settings) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription result = workspace.newProjectDescription(projectName);
        result.setComment("Imported from ProjectInfo.xml: " + settings.getPiReader().getDeviceId() + " " + settings.getPiReader().getCoreSet());
        return result;
    }

    private static String copy(IProject project, PIReader pi) {
        int errs = 0;
        StringBuilder sb = new StringBuilder();
        for (String path : pi.getGeneratedFiles()) {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (FileInputStream in = new FileInputStream(ProjectInfoPathProcessor.makeInPath(path, pi).toFile());){
                    IFile outIFile = ProjectInfoPathProcessor.makeOutIFile(project, path, pi);
                    ProjectInfoImporter.createFolders(outIFile.getParent(), (IProgressMonitor)new NullProgressMonitor());
                    outIFile.create((InputStream)in, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                S32DSWizardPiPlugin.logWarning(e.getMessage());
                S32DSWizardPiPlugin.log(e);
                sb.append(String.valueOf(++errs) + "> " + e.getMessage() + '\n');
            }
        }
        return errs == 0 ? null : sb.toString();
    }

    private static void createFolders(IContainer container, IProgressMonitor monitor) throws CoreException {
        if (container.exists()) {
            return;
        }
        if (container instanceof IFolder) {
            ProjectInfoImporter.createFolders(container.getParent(), monitor);
            ((IFolder)container).create(true, true, monitor);
            return;
        }
        throw new CoreException((IStatus)new Status(4, "com.freescale.s32ds.cross.wizard.pi", "Can't create folder for " + container));
    }

    private void setProjectDescription(IProject project, IProgressMonitor monitor) throws CoreException {
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.createProjectDescription(project, false, false);
        ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)project);
        monitor.worked(10);
        this.setDeviceInfo(project, this.settings.getPiReader());
        IProjectType projectType = this.settings.getSelectedProjectType();
        IConfiguration[] icfgs = projectType.getConfigurations();
        CfgHolder cfgHolder = new CfgHolder(icfgs[0].getToolChain(), icfgs[0]);
        IOptionProcessor optionProcessor = this.settings.getSelectedToolChainOptionProcessor(icfgs[0].getToolChain());
        try {
            ManagedProject mProj = new ManagedProject((IResource)project, projectType);
            info.setManagedProject((IManagedProject)mProj);
            monitor.worked(10);
            Configuration cf = (Configuration)cfgHolder.getConfiguration();
            String id = ManagedBuildManager.calculateChildId((String)cf.getId(), null);
            Configuration config = new Configuration(mProj, cf, id, false, true);
            CConfigurationData data = config.getConfigurationData();
            ICConfigurationDescription cfgDes = des.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", data);
            config.setConfigurationDescription(cfgDes);
            config.exportArtifactInfo();
            IBuilder bld = config.getEditableBuilder();
            if (bld != null) {
                bld.setManagedBuildOn(true);
            }
            config.setName("build");
            config.setDescription("ProjectInfo.xml imported configuration");
            config.setArtifactName(mProj.getDefaultArtifactName());
            ICSourceEntry[] srcs = this.createSourceEntry(project);
            config.setSourceEntries(srcs);
            String copyResult = ProjectInfoImporter.copy(project, this.settings.getPiReader());
            if (copyResult != null) {
                this.writeResult(copyResult, project);
            }
            if (optionProcessor != null) {
                ProjectInfoImporter.setOptions(optionProcessor, config, this.settings.getPiReader());
            }
            monitor.worked(50);
            EmbSysSettingsUtil.setEmbsysDescriptionData((IProject)project, (boolean)true, (ICProjectDescription)des);
            mngr.setProjectDescription(project, des);
            if (this.settings.getCreateLaunchConfigurationStatus()) {
                this.createLaunchConfig(project);
            }
        }
        catch (Exception e) {
            S32DSWizardPiPlugin.log(e);
        }
    }

    private ICSourceEntry[] createSourceEntry(IProject project) throws CoreException {
        ICSourceEntry[] srcs;
        ICSourceEntry[] iCSourceEntryArray = srcs = this.getSources(project);
        int n = srcs.length;
        int n2 = 0;
        while (n2 < n) {
            ICSourceEntry dir = iCSourceEntryArray[n2];
            try {
                String str;
                IFolder subFolder;
                IFolder f;
                if (!(dir.getFullPath().isEmpty() || (f = project.getFolder(dir.getFullPath())).exists() || (subFolder = project.getFolder(str = f.getFullPath().lastSegment())).exists())) {
                    subFolder.create(1, true, null);
                }
            }
            catch (IllegalArgumentException e) {
                S32DSWizardPiPlugin.log(e);
            }
            ++n2;
        }
        return srcs;
    }

    private void createLaunchConfig(IProject project) throws CoreException {
        ILaunchConfigurationType configTypeList = this.getSelectedLaunchConfigurationType(this.settings.getDebugConfigurationName());
        ILaunchConfigurationWorkingCopy wc = configTypeList.newInstance(null, project.getName());
        String deviceId = this.settings.getPiReader().getDeviceId();
        String coreSet = this.settings.getPiReader().getCoreSet();
        int coreIndex = LaunchConfigUtil.calcCoreIndex((String)deviceId, (String)coreSet);
        String projectTypeId = this.settings.getSelectedProjectType().getBaseId();
        String execExt = ".elf";
        if (projectTypeId != null && !projectTypeId.isEmpty() && projectTypeId.contains("iar.arm.toolchain")) {
            execExt = ".out";
        }
        LaunchSetup data = new LaunchSetup();
        data.setProgramName("build" + File.separator + project.getName() + execExt);
        data.setFamilyId(deviceId);
        data.setProcessorId(this.settings.mapToS32DSdevice());
        data.setCoreId(this.settings.mapToS32DScore());
        data.setProject(project);
        LaunchConfigUtil.setConfigurationDefaults((ILaunchConfigurationWorkingCopy)wc, (LaunchSetup)data, (int)coreIndex);
        StructuredSelection selection = new StructuredSelection((Object)wc.doSave());
        UIJob openLaunchConfigJob = new UIJob(Messages.AbstractImportExecutableWizard_CreateLaunchConfiguration, (IStructuredSelection)selection){
            private final /* synthetic */ IStructuredSelection val$selection;
            {
                this.val$selection = iStructuredSelection;
                super($anonymous0);
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)CUIPlugin.getActiveWorkbenchShell(), (IStructuredSelection)this.val$selection, (String)"org.eclipse.debug.ui.launchGroup.debug");
                return Status.OK_STATUS;
            }
        };
        openLaunchConfigJob.schedule();
    }

    private ILaunchConfigurationType getSelectedLaunchConfigurationType(String configName) {
        ILaunchConfigurationType result = null;
        ILaunchConfigurationType[] configTypeList = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        int i = 0;
        while (i < configTypeList.length) {
            if (configName.equals(configTypeList[i].getName())) {
                result = configTypeList[i];
                break;
            }
            ++i;
        }
        return result;
    }

    private static void setOptions(IOptionProcessor optionProcessor, Configuration cfg, PIReader piReader) {
        optionProcessor.prepareChanges((IConfiguration)cfg, piReader).forEach(OptionDelta::apply);
    }

    private void setDeviceInfo(IProject project, PIReader projectInfo) throws CoreException {
        QualifiedName qArch = new QualifiedName("register_architecture", "architecture");
        QualifiedName qVendor = new QualifiedName("register_vendor", "vendor");
        QualifiedName qChip = new QualifiedName("register_chip", "chip");
        QualifiedName qCore = new QualifiedName("register_core", "core");
        String deviceName = null;
        String coreSetName = null;
        String mapToS32DSdevice = this.settings.mapToS32DSdevice();
        deviceName = this.settings.getLingvo().mapToLingvo(mapToS32DSdevice, "embsys.Chip");
        if (deviceName == null) {
            deviceName = this.settings.getLingvo().mapToLingvo(mapToS32DSdevice, "cw.Name");
        }
        if (deviceName == null) {
            deviceName = this.settings.getLingvo().mapToLingvo(mapToS32DSdevice, "pi.Device");
        }
        if ((coreSetName = this.settings.getLingvo().mapToLingvo(mapToS32DSdevice, "embsys.Architecture")) == null) {
            coreSetName = this.settings.getLingvo().mapToLingvo("$DEFAULT$", "embsys.Architecture");
        }
        if (coreSetName == null) {
            String mapToS32DScore = this.settings.mapToS32DScore();
            coreSetName = this.settings.getLingvo().mapToLingvo(mapToS32DScore, "cw.Name");
            if (coreSetName == null) {
                coreSetName = this.settings.getLingvo().mapToLingvo(mapToS32DScore, "pi.CoreSet");
            }
        }
        String s32DSCore = String.valueOf(deviceName) + "_" + this.settings.getPiReader().getCoreSet();
        String coreName = this.settings.getLingvo().mapToLingvo(s32DSCore, "embsys.Core");
        project.setPersistentProperty(qArch, coreSetName);
        project.setPersistentProperty(qVendor, EmbSysSettingsUtil.getVendor((String)deviceName));
        project.setPersistentProperty(qChip, deviceName);
        project.setPersistentProperty(qCore, coreName);
    }
}

