/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.pi.imports;

import com.freescale.s32ds.cross.wizard.pi.jaxb.Export;
import com.freescale.s32ds.cross.wizard.pi.jaxb.OptionListType;
import com.freescale.s32ds.cross.wizard.pi.jaxb.PathListType;
import com.freescale.s32ds.cross.wizard.pi.jaxb.PathNameListType;
import com.freescale.s32ds.cross.wizard.pi.jaxb.PathNameType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class PIReader {
    private final String rootFolder;
    private String linkerCommandFile = null;
    private String projectInfoPath = null;
    private final List<String> generatedFiles = new ArrayList<String>();
    private final List<String> libFiles = new ArrayList<String>();
    private final List<String> includePaths = new ArrayList<String>();
    private final List<String> sourcePaths = new ArrayList<String>();
    private final List<String> libPaths = new ArrayList<String>();
    private final List<String> optionsASM = new ArrayList<String>();
    private final List<String> optionsCC = new ArrayList<String>();
    private final List<String> optionsLinker = new ArrayList<String>();
    private final String deviceId;
    private final String coreSet;
    private final String flash;
    private final String ram;
    private final Map<String, List<String>> extraOptions = new HashMap<String, List<String>>();

    public PIReader(String configFile) throws IOException, JAXBException {
        this.rootFolder = new File(configFile).getParentFile().getAbsolutePath();
        Throwable throwable = null;
        Object var3_5 = null;
        try (FileInputStream in = new FileInputStream(Paths.get(configFile, new String[0]).toFile());){
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Export.class});
            Unmarshaller unmarchaller = jc.createUnmarshaller();
            Export export = (Export)unmarchaller.unmarshal((InputStream)in);
            this.coreSet = export.getPROCESSOR().getCores().getCore().get(0).getCoreSet();
            this.deviceId = export.getPROCESSOR().getDeviceID();
            this.ram = export.getPROCESSOR().getSRAMsize();
            this.flash = export.getPROCESSOR().getFLASHsize();
            this.projectInfoPath = export.getPATHS().getProjectInfoPath();
            if (export.getPATHS().getLinkerCommandFile() != null) {
                this.generatedFiles.add(export.getPATHS().getLinkerCommandFile());
            }
            this.addToPathList(export.getPATHS().getIncludePaths(), this.includePaths);
            this.addToPathList(export.getPATHS().getSourceCodePaths(), this.sourcePaths);
            this.addToPathList(export.getPATHS().getLibPaths(), this.libPaths);
            this.addToPathList(export.getFILES().getGeneratedCs(), this.generatedFiles);
            this.addToPathList(export.getFILES().getGeneratedHs(), this.generatedFiles);
            this.addToPathList(export.getFILES().getGeneratedASMs(), this.generatedFiles);
            this.addToPathList(export.getFILES().getLibraries(), this.libFiles);
            this.generatedFiles.addAll(this.libFiles);
            if (export.getOPTIONS().getBuildOptions() != null) {
                this.addToOptionsList(export.getOPTIONS().getBuildOptions().getASMoptList(), this.optionsASM);
                this.addToOptionsList(export.getOPTIONS().getBuildOptions().getCCoptList(), this.optionsCC);
                this.addToOptionsList(export.getOPTIONS().getBuildOptions().getLinkerOptList(), this.optionsLinker);
                this.extractExtraOptions(export.getOPTIONS().getBuildOptions().getASMoptList());
                this.extractExtraOptions(export.getOPTIONS().getBuildOptions().getCCoptList());
                this.extractExtraOptions(export.getOPTIONS().getBuildOptions().getLinkerOptList());
            }
            export.getOPTIONS().getDebugOptions();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void extractExtraOptions(OptionListType cCoptList) {
        for (String option : cCoptList.getOption()) {
            Matcher optMatcher = Pattern.compile("^\\-X(\\w*) (.*)$").matcher(option);
            if (!optMatcher.find()) continue;
            String target = optMatcher.group(1);
            String value = optMatcher.group(2);
            if (!this.extraOptions.containsKey(target)) {
                this.extraOptions.put(target, new ArrayList());
            }
            this.extraOptions.get(target).add(value);
        }
    }

    private void addToOptionsList(OptionListType optionListType, List<String> opts) {
        if (optionListType != null) {
            for (String option : optionListType.getOption()) {
                opts.add(option);
            }
        }
    }

    private void addToPathList(PathNameListType paths, List<String> list) {
        if (paths != null) {
            for (PathNameType path : paths.getPathName()) {
                String rel = PIReader.makeRelative(path.getValue(), this);
                if (list.contains(rel)) continue;
                list.add(rel);
            }
        }
    }

    private void addToPathList(PathListType paths, List<String> list) {
        if (paths != null) {
            for (String path : paths.getPath()) {
                String rel = PIReader.makeRelative(path, this);
                if (list.contains(rel)) continue;
                list.add(rel);
            }
        }
    }

    public static String makeRelative(String path, PIReader pi) {
        Path rf;
        Path result = Paths.get(path, new String[0]);
        if (result.isAbsolute() && result.startsWith(rf = Paths.get(pi.getProjectInfoPath(), new String[0]).getParent())) {
            result = rf.relativize(result);
        }
        return result.toString();
    }

    public String getLinkerCommandFile() {
        return this.linkerCommandFile;
    }

    public List<String> getIncludePaths() {
        return this.includePaths;
    }

    public List<String> getSourcePaths() {
        return this.sourcePaths;
    }

    public List<String> getGeneratedFiles() {
        return this.generatedFiles;
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public String getProjectInfoPath() {
        return this.projectInfoPath;
    }

    public List<String> getOptionsLinker() {
        return this.optionsLinker;
    }

    public List<String> getOptionsCC() {
        return this.optionsCC;
    }

    public List<String> getOptionsASM() {
        return this.optionsASM;
    }

    public List<String> getLibFiles() {
        return this.libFiles;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getCoreSet() {
        return this.coreSet;
    }

    public String getFlash() {
        return this.flash;
    }

    public String getRam() {
        return this.ram;
    }

    public String toString() {
        return "INC= " + Arrays.toString(this.getIncludePaths().toArray()) + '\n' + "SRC= " + Arrays.toString(this.getSourcePaths().toArray()) + '\n' + "LBP= " + Arrays.toString(this.libPaths.toArray()) + '\n' + "GEN= " + Arrays.toString(this.generatedFiles.toArray()) + '\n' + "LD= " + this.getLinkerCommandFile() + '\n' + "ID= " + this.deviceId + '\n' + "CoreSet= " + this.coreSet + '\n' + "FL= " + this.flash + '\n' + "RM= " + this.ram;
    }

    public List<String> getExtraOptions(String taget) {
        return this.extraOptions.containsKey(taget) ? this.extraOptions.get(taget) : Collections.emptyList();
    }
}

