/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apugraph.validation;

import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuGraphSource;
import com.nxp.s32ds.gte.apugraph.ApuKernel;
import com.nxp.s32ds.gte.apugraph.ApuKernelInput;
import com.nxp.s32ds.gte.apugraph.ApuKernelOutput;
import com.nxp.s32ds.gte.apugraph.validation.internal.ValidationMessages;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortInfo;
import com.nxp.s32ds.gte.apukernel.ApuMemoryPart;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;

public class ApuGraphValidationUtil {
    private static final String BUNDLE_NAME = "com.nxp.s32ds.gte.apugraph.validation";
    public static final int MAX_KERNEL_INPUTS = 25;
    public static final int MAX_KERNEL_OUTPUTS = 25;

    public static IStatus numberOfSourcesIsNotExceeded(ApuGraph graph) {
        if (graph.getGraphSources().size() > 100) {
            return new Status(4, BUNDLE_NAME, NLS.bind((String)ValidationMessages.LimitOfSourcesIsExceeded, (Object)100));
        }
        return Status.OK_STATUS;
    }

    public static IStatus numberOfSinksIsNotExceeded(ApuGraph graph) {
        if (graph.getGraphSinks().size() > 100) {
            return new Status(4, BUNDLE_NAME, NLS.bind((String)ValidationMessages.LimitOfSinksIsExceeded, (Object)100));
        }
        return Status.OK_STATUS;
    }

    public static IStatus numberOfConnectionsIsNotExceeded(ApuGraphSource apuGraphSource) {
        if (apuGraphSource.getKernelInputs().size() > 100) {
            return new Status(4, BUNDLE_NAME, NLS.bind((String)ValidationMessages.LimitOfConnectionsIsExceeded, (Object)100));
        }
        return Status.OK_STATUS;
    }

    public static IStatus inputMemoryPartShouldMatchOutput(ApuKernelInput apuKernelInput) {
        ApuKernelOutput output = apuKernelInput.getKernelOutput();
        if (output != null) {
            ApuMemoryPart memoryPart = apuKernelInput.getPortInfo().getPortAttrbutesInfo().getMemoryPart();
            if (output.getPortInfo().getPortAttrbutesInfo().getMemoryPart() != memoryPart) {
                return new Status(4, BUNDLE_NAME, ValidationMessages.MemoryPartsOfPortsAreNotEqual);
            }
        }
        return Status.OK_STATUS;
    }

    public static IStatus outputMemoryPartShouldMatchInput(ApuKernelOutput apuKernelOutput) {
        EList<ApuKernelInput> apuKernelInputs = apuKernelOutput.getKernelInputs();
        if (!apuKernelInputs.isEmpty()) {
            ApuMemoryPart memoryPart = apuKernelOutput.getPortInfo().getPortAttrbutesInfo().getMemoryPart();
            for (ApuKernelInput apuKernelInput : apuKernelInputs) {
                if (apuKernelInput.getPortInfo().getPortAttrbutesInfo().getMemoryPart() == memoryPart) continue;
                return new Status(4, BUNDLE_NAME, ValidationMessages.MemoryPartsOfPortsAreNotEqual);
            }
        }
        return Status.OK_STATUS;
    }

    public static IStatus kernelShouldBeConsistentWithKernelInfo(ApuKernel apuKernel) {
        for (ApuKernelInput input : apuKernel.getKernelInputs()) {
            if (ApuGraphValidationUtil.portInfoExists(input.getPortInfo(), apuKernel)) continue;
            return ApuGraphValidationUtil.errorStatus(ValidationMessages.PortInfoForInputIsNotFound, input.getName());
        }
        for (ApuKernelOutput output : apuKernel.getKernelOutputs()) {
            if (ApuGraphValidationUtil.portInfoExists(output.getPortInfo(), apuKernel)) continue;
            return ApuGraphValidationUtil.errorStatus(ValidationMessages.PortInfoForOutputIsNotFound, output.getName());
        }
        for (ApuKernelPortInfo portInfo : apuKernel.getKernelInfo().getPortInfos()) {
            if (ApuGraphValidationUtil.kernelPortExists(portInfo, apuKernel)) continue;
            return ApuGraphValidationUtil.errorStatus(ValidationMessages.KernelPortForPortInfoIsNotFound, portInfo.getName());
        }
        return Status.OK_STATUS;
    }

    private static boolean portInfoExists(ApuKernelPortInfo portInfo, ApuKernel apuKernel) {
        for (ApuKernelPortInfo info : apuKernel.getKernelInfo().getPortInfos()) {
            if (!portInfo.equals(info)) continue;
            return true;
        }
        return false;
    }

    private static boolean kernelPortExists(ApuKernelPortInfo portInfo, ApuKernel apuKernel) {
        for (ApuKernelInput input : apuKernel.getKernelInputs()) {
            if (!input.getPortInfo().equals(portInfo)) continue;
            return true;
        }
        for (ApuKernelOutput output : apuKernel.getKernelOutputs()) {
            if (!output.getPortInfo().equals(portInfo)) continue;
            return true;
        }
        return false;
    }

    private static IStatus errorStatus(String message, String param) {
        return new Status(4, BUNDLE_NAME, NLS.bind((String)message, (Object)param));
    }
}

