/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apugraph.validation;

import com.nxp.s32ds.gte.apuflow.ApuConsumer;
import com.nxp.s32ds.gte.apuflow.ApuNode;
import com.nxp.s32ds.gte.apuflow.ApuProducer;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuKernel;
import com.nxp.s32ds.gte.apugraph.util.ApuGraphSwitch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class ApuGraphOutputSwitch
extends ApuGraphSwitch<List<EObject>> {
    private static final ApuGraphOutputSwitch INSTANCE = new ApuGraphOutputSwitch();

    private ApuGraphOutputSwitch() {
    }

    public static List<EObject> getOutputs(EObject eObject) {
        return (List)INSTANCE.doSwitch(eObject);
    }

    @Override
    public List<EObject> caseApuGraph(ApuGraph graph) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        TreeIterator treeIterator = graph.eAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject = (EObject)treeIterator.next();
            if (eObject instanceof ApuKernel) {
                List<EObject> eObjectList = ApuGraphOutputSwitch.getOutputs(eObject);
                if (eObjectList.isEmpty()) {
                    list.add(eObject);
                } else {
                    list.addAll(eObjectList.stream().filter(o -> list.contains(o)).collect(Collectors.toList()));
                }
            }
            treeIterator.prune();
        }
        return list;
    }

    @Override
    public List<EObject> caseApuKernel(ApuKernel kernel) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        EList outputs = kernel.getOutputs();
        for (ApuProducer output : outputs) {
            for (ApuConsumer consumer : output.getConsumers()) {
                ApuNode node = consumer.getNode();
                if (node == null || !(node instanceof ApuKernel)) continue;
                list.add((EObject)node);
            }
        }
        return list;
    }

    @Override
    public List<EObject> defaultCase(EObject object) {
        return Collections.emptyList();
    }
}

