/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apugraph.validation;

import com.nxp.s32ds.gte.apuflow.ApuConsumer;
import com.nxp.s32ds.gte.apuflow.ApuNode;
import com.nxp.s32ds.gte.apuflow.ApuProducer;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuKernel;
import com.nxp.s32ds.gte.apugraph.util.ApuGraphSwitch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class ApuGraphInputSwitch
extends ApuGraphSwitch<List<EObject>> {
    private static final ApuGraphInputSwitch INSTANCE = new ApuGraphInputSwitch();

    private ApuGraphInputSwitch() {
    }

    public static List<EObject> getInputs(EObject eObject) {
        return (List)INSTANCE.doSwitch(eObject);
    }

    @Override
    public List<EObject> caseApuGraph(ApuGraph graph) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        TreeIterator treeIterator = graph.eAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject = (EObject)treeIterator.next();
            if (eObject instanceof ApuKernel) {
                List<EObject> eObjectList = ApuGraphInputSwitch.getInputs(eObject);
                if (eObjectList.isEmpty()) {
                    list.add(eObject);
                } else {
                    list.addAll(eObjectList);
                }
            }
            treeIterator.prune();
        }
        return list;
    }

    @Override
    public List<EObject> caseApuKernel(ApuKernel kernel) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        EList inputs = kernel.getInputs();
        for (ApuConsumer input : inputs) {
            ApuProducer producer = input.getProducer();
            if (producer == null) {
                return list;
            }
            ApuNode node = producer.getNode();
            if (node == null || !(node instanceof ApuKernel)) continue;
            list.add((EObject)node);
        }
        return list;
    }

    @Override
    public List<EObject> defaultCase(EObject object) {
        return Collections.emptyList();
    }
}

