/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apugraph.validation;

import com.nxp.s32ds.ext.emf.common.util.CycleUtil;
import com.nxp.s32ds.ext.emf.common.util.InputOutputProvider;
import com.nxp.s32ds.ext.emf.common.util.LoopChecker;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuKernel;
import com.nxp.s32ds.gte.apugraph.validation.ApuGraphInputOutputProvider;
import com.nxp.s32ds.gte.apugraph.validation.internal.ValidationMessages;
import java.util.List;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class Apex2GraphLoopValidator
implements IValidator {
    private static final String BUNDLE_NAME = "com.nxp.s32ds.gte.apugraph";

    public IStatus validate(Object apuGraph) {
        if (!(apuGraph instanceof ApuGraph)) {
            return Status.OK_STATUS;
        }
        return this.doValidate((ApuGraph)apuGraph);
    }

    private IStatus doValidate(ApuGraph apuGraph) {
        LoopChecker loopChecker = new LoopChecker((InputOutputProvider)new ApuGraphInputOutputProvider());
        List loopList = loopChecker.detectLocalCycles((EObject)apuGraph);
        IStatus status = Status.OK_STATUS;
        if (loopList.isEmpty()) {
            return status;
        }
        for (CycleUtil.LocalCycleInfo cycleElements : loopList) {
            if (!(cycleElements.first instanceof ApuKernel) || !(cycleElements.second instanceof ApuKernel)) continue;
            status = new Status(4, BUNDLE_NAME, NLS.bind((String)ValidationMessages.Apex2GraphLoopValidator_loop_occurred_between, (Object)((ApuKernel)cycleElements.first).getName(), (Object)((ApuKernel)cycleElements.second).getName()));
        }
        return status;
    }
}

