/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apugraph.util;

import com.nxp.s32ds.ext.rcp.databinding.validation.CIdentifierValidator;
import com.nxp.s32ds.gte.apuflow.ApuConsumer;
import com.nxp.s32ds.gte.apuflow.ApuContent;
import com.nxp.s32ds.gte.apuflow.ApuDefinition;
import com.nxp.s32ds.gte.apuflow.ApuPort;
import com.nxp.s32ds.gte.apuflow.ApuProducer;
import com.nxp.s32ds.gte.apuflow.ApuUsage;
import com.nxp.s32ds.gte.apuflow.util.ApuFlowValidator;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuGraphPackage;
import com.nxp.s32ds.gte.apugraph.ApuGraphPlugin;
import com.nxp.s32ds.gte.apugraph.ApuGraphPort;
import com.nxp.s32ds.gte.apugraph.ApuGraphSink;
import com.nxp.s32ds.gte.apugraph.ApuGraphSource;
import com.nxp.s32ds.gte.apugraph.ApuGraphs;
import com.nxp.s32ds.gte.apugraph.ApuKernel;
import com.nxp.s32ds.gte.apugraph.ApuKernelInput;
import com.nxp.s32ds.gte.apugraph.ApuKernelOutput;
import com.nxp.s32ds.gte.apugraph.ApuKernelPort;
import com.nxp.s32ds.gte.apugraph.validation.Apex2GraphLoopValidator;
import com.nxp.s32ds.gte.apugraph.validation.ApuGraphValidationUtil;
import com.nxp.s32ds.gte.apugraph.validation.internal.ValidationMessages;
import com.nxp.s32ds.gte.apukernel.ApuDataType;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.gte.apukernel.ApuMemoryPart;
import com.nxp.s32ds.mdt.ide.validation.UniqueValueValidator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.osgi.util.NLS;

public class ApuGraphValidator
extends EObjectValidator {
    public static final ApuGraphValidator INSTANCE = new ApuGraphValidator();
    public static final String DIAGNOSTIC_SOURCE = "com.nxp.s32ds.gte.apugraph";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected ApuFlowValidator apuFlowValidator = ApuFlowValidator.INSTANCE;

    protected EPackage getEPackage() {
        return ApuGraphPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateApuGraph((ApuGraph)value, diagnostics, context);
            }
            case 1: {
                return this.validateApuGraphPort((ApuGraphPort)value, diagnostics, context);
            }
            case 2: {
                return this.validateApuGraphSource((ApuGraphSource)value, diagnostics, context);
            }
            case 3: {
                return this.validateApuGraphSink((ApuGraphSink)value, diagnostics, context);
            }
            case 4: {
                return this.validateApuKernel((ApuKernel)value, diagnostics, context);
            }
            case 5: {
                return this.validateApuKernelPort((ApuKernelPort)value, diagnostics, context);
            }
            case 6: {
                return this.validateApuKernelInput((ApuKernelInput)value, diagnostics, context);
            }
            case 7: {
                return this.validateApuKernelOutput((ApuKernelOutput)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateApuGraph(ApuGraph apuGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)apuGraph, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)apuGraph, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)apuGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)apuGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)apuGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)apuGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)apuGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)apuGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)apuGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuDefinition_must_have_name((ApuDefinition)apuGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuGraph_constraintLoops(apuGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuGraph_validateUnderlying(apuGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuGraph_NameShouldBeValidCIdentifier(apuGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuGraph_MaxSourcesNumberIsNotExceeded(apuGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuGraph_MaxSinksNumberIsNotExceeded(apuGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuGraph_MaxKernelsNumberIsNotExceeded(apuGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuGraph_AtLeastOneKernel(apuGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuGraph_AtLeastOneInput(apuGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuGraph_AtLeastOneOutput(apuGraph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuGraph_NameShouldntBeEmpty(apuGraph, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuGraph_constraintLoops(ApuGraph apuGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Apex2GraphLoopValidator validator = new Apex2GraphLoopValidator();
        IStatus validationResult = validator.validate(apuGraph);
        if (!validationResult.isOK()) {
            String message = validationResult.getMessage();
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{message, ApuGraphValidator.getObjectLabel((EObject)apuGraph, context)}, new Object[]{apuGraph}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuGraph_validateUnderlying(ApuGraph apuGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<ApuKernelInfo> kernelInfos = ApuGraphs.getKernelInfos(apuGraph);
        boolean result = true;
        for (ApuKernelInfo apuKernelInfo : kernelInfos) {
            if (apuKernelInfo.eIsProxy()) {
                ApuKernel kernel = ApuGraphs.getKernel(apuGraph, apuKernelInfo);
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_Cannot_find_related_APU_Kernel", new Object[]{kernel == null ? "UNKNOWN" : kernel.getIdentifier()}, new Object[]{kernel}, context));
                result = false;
                continue;
            }
            boolean bl = result = result && Diagnostician.INSTANCE.validate((EObject)apuKernelInfo, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuGraph_NameShouldBeValidCIdentifier(ApuGraph apuGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuGraph.getName() == null || apuGraph.getName().isEmpty()) {
            return true;
        }
        CIdentifierValidator validator = new CIdentifierValidator();
        IStatus result = validator.validate((Object)apuGraph.getName());
        if (!result.equals(Status.OK_STATUS)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{result.getMessage(), ApuGraphValidator.getObjectLabel((EObject)apuGraph, context)}, new Object[]{apuGraph}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuGraph_MaxSourcesNumberIsNotExceeded(ApuGraph apuGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = ApuGraphValidationUtil.numberOfSourcesIsNotExceeded(apuGraph);
        if (!status.isOK()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{status.getMessage(), ApuGraphValidator.getObjectLabel((EObject)apuGraph, context)}, new Object[]{apuGraph}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuGraph_MaxSinksNumberIsNotExceeded(ApuGraph apuGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = ApuGraphValidationUtil.numberOfSinksIsNotExceeded(apuGraph);
        if (!status.isOK()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{status.getMessage(), ApuGraphValidator.getObjectLabel((EObject)apuGraph, context)}, new Object[]{apuGraph}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuGraph_MaxKernelsNumberIsNotExceeded(ApuGraph apuGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuGraph.getKernels().size() > 100) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{NLS.bind((String)ValidationMessages.LimitOfKernelsIsExceeded, (Object)100), ApuGraphValidator.getObjectLabel((EObject)apuGraph, context)}, new Object[]{apuGraph}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuGraph_AtLeastOneKernel(ApuGraph apuGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuGraph.getKernels().isEmpty()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"APU Graph must have at least one kernel", ApuGraphValidator.getObjectLabel((EObject)apuGraph, context)}, new Object[]{apuGraph}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuGraph_AtLeastOneInput(ApuGraph apuGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuGraph.getGraphSources() == null || apuGraph.getGraphSources().isEmpty()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"APU Graph must have at least one Input", ApuGraphValidator.getObjectLabel((EObject)apuGraph, context)}, new Object[]{apuGraph}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuGraph_AtLeastOneOutput(ApuGraph apuGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuGraph.getGraphSinks() == null || apuGraph.getGraphSinks().isEmpty()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"APU Graph must have at least one Output", ApuGraphValidator.getObjectLabel((EObject)apuGraph, context)}, new Object[]{apuGraph}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuGraph_NameShouldntBeEmpty(ApuGraph apuGraph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String name = apuGraph.getName();
        if (name == null || name.isEmpty()) {
            this.addToDiagnostics("Graph name shouldn't be empty", (EObject)apuGraph, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuGraphPort(ApuGraphPort apuGraphPort, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)apuGraphPort, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)apuGraphPort, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)apuGraphPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)apuGraphPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)apuGraphPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)apuGraphPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)apuGraphPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)apuGraphPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)apuGraphPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuDefinition_must_have_name((ApuDefinition)apuGraphPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuPort_must_have_node((ApuPort)apuGraphPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuGraphPort_NameShouldntBeEmpty(apuGraphPort, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuGraphPort_NameShouldntBeEmpty(ApuGraphPort apuGraphPort, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String name = apuGraphPort.getName();
        if (name == null || name.isEmpty()) {
            this.addToDiagnostics("Graph port's name shouldn't be empty", (EObject)apuGraphPort, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuGraphSource(ApuGraphSource apuGraphSource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)apuGraphSource, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)apuGraphSource, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)apuGraphSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)apuGraphSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)apuGraphSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)apuGraphSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)apuGraphSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)apuGraphSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)apuGraphSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuDefinition_must_have_name((ApuDefinition)apuGraphSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuPort_must_have_node((ApuPort)apuGraphSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuGraphPort_NameShouldntBeEmpty(apuGraphSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuProducer_must_have_consumer((ApuProducer)apuGraphSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuGraphSource_must_have_same_data_type(apuGraphSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuGraphSource_NameShouldBeValidCIdentifier(apuGraphSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuGraphSource_NameShouldBeUnique(apuGraphSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuGraphSource_AllConnectedPortsMustHaveTheSameMemoryPart(apuGraphSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuGraphSource_MaxConnectionNumberNotExceeded(apuGraphSource, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuGraphSource_must_have_same_data_type(ApuGraphSource apuGraphSource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Boolean isError = false;
        if (apuGraphSource.getKernelInputs() != null && apuGraphSource.getKernelInputs().size() > 1) {
            ApuKernelInput kernelInput0 = (ApuKernelInput)apuGraphSource.getKernelInputs().get(0);
            ApuDataType kernelDataType = kernelInput0.getPortInfo().getPortElementsInfo().getE0DataType();
            for (ApuKernelInput it : apuGraphSource.getKernelInputs()) {
                ApuDataType otherType = it.getPortInfo().getPortElementsInfo().getE0DataType();
                if (kernelDataType.equals((Object)otherType)) continue;
                isError = true;
                break;
            }
        }
        if (isError.booleanValue()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"GraphSource must have the same dataType for all Kernel Inputs ", ApuGraphValidator.getObjectLabel((EObject)apuGraphSource, context)}, new Object[]{apuGraphSource}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuGraphSource_NameShouldBeValidCIdentifier(ApuGraphSource apuGraphSource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuGraphSource.getName() == null || apuGraphSource.getName().isEmpty()) {
            return true;
        }
        CIdentifierValidator validator = new CIdentifierValidator();
        IStatus result = validator.validate((Object)apuGraphSource.getName());
        if (!result.equals(Status.OK_STATUS)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{result.getMessage(), ApuGraphValidator.getObjectLabel((EObject)apuGraphSource, context)}, new Object[]{apuGraphSource}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuGraphSource_NameShouldBeUnique(ApuGraphSource apuGraphSource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuGraphSource.getName() == null || apuGraphSource.getName().isEmpty()) {
            return true;
        }
        BasicEList eList = new BasicEList();
        for (EObject eObject : apuGraphSource.getGraph().getGraphSinks()) {
            eList.add((Object)eObject);
        }
        for (EObject eObject : apuGraphSource.getGraph().getGraphSources()) {
            if (eObject.equals(apuGraphSource)) continue;
            eList.add((Object)eObject);
        }
        String message = NLS.bind((String)"Duplicate Input/Output name \"{0}\" in Graph \"{1}\"", (Object)apuGraphSource.getName(), (Object)apuGraphSource.getGraph().getName());
        UniqueValueValidator validator = new UniqueValueValidator((EObject)apuGraphSource, "name", message);
        IStatus status = validator.validate((Object)eList);
        if (!status.equals(Status.OK_STATUS)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{status.getMessage(), ApuGraphValidator.getObjectLabel((EObject)apuGraphSource, context)}, new Object[]{apuGraphSource}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuGraphSource_AllConnectedPortsMustHaveTheSameMemoryPart(ApuGraphSource apuGraphSource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<ApuKernelInput> inputs = apuGraphSource.getKernelInputs();
        if (inputs.size() < 2) {
            return true;
        }
        boolean allIsTheSame = true;
        ApuMemoryPart memoryPart = ((ApuKernelInput)inputs.get(0)).getPortInfo().getPortAttrbutesInfo().getMemoryPart();
        for (ApuKernelInput input : inputs) {
            if (memoryPart == input.getPortInfo().getPortAttrbutesInfo().getMemoryPart()) continue;
            allIsTheSame = false;
        }
        if (!allIsTheSame) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"All connected ports must have the same type of memory part", ApuGraphValidator.getObjectLabel((EObject)apuGraphSource, context)}, new Object[]{apuGraphSource}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuGraphSource_MaxConnectionNumberNotExceeded(ApuGraphSource apuGraphSource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus validationStatus = ApuGraphValidationUtil.numberOfConnectionsIsNotExceeded(apuGraphSource);
        if (!validationStatus.isOK()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_MaxGraphInPortConnectionsNumberExceeded", new Object[]{ApuGraphValidator.getObjectLabel((EObject)apuGraphSource, context)}, new Object[]{apuGraphSource}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuGraphSource_must_to_have_a_inputlink(ApuGraphSource apuGraphSource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<ApuKernelInput> kernelInputs = apuGraphSource.getKernelInputs();
        if (kernelInputs.isEmpty()) {
            return false;
        }
        ApuDataType apuDataType = ((ApuKernelInput)kernelInputs.iterator().next()).getPortInfo().getPortElementsInfo().getE0DataType();
        for (ApuKernelInput apuKernelInput : kernelInputs) {
            if (apuDataType.equals((Object)apuKernelInput.getPortInfo().getPortElementsInfo().getE0DataType())) continue;
            this.setErrorMessageMustHaveComparableDataType(apuGraphSource, diagnostics, context);
            return false;
        }
        return true;
    }

    private void setErrorMessageMustHaveComparableDataType(ApuGraphSource apuGraphSource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"Must have comparable data type", ApuGraphValidator.getObjectLabel((EObject)apuGraphSource, context)}, new Object[]{apuGraphSource}, context));
        }
    }

    public boolean validateApuGraphSink(ApuGraphSink apuGraphSink, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)apuGraphSink, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)apuGraphSink, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)apuGraphSink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)apuGraphSink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)apuGraphSink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)apuGraphSink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)apuGraphSink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)apuGraphSink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)apuGraphSink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuDefinition_must_have_name((ApuDefinition)apuGraphSink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuPort_must_have_node((ApuPort)apuGraphSink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuGraphPort_NameShouldntBeEmpty(apuGraphSink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuConsumer_must_have_producer((ApuConsumer)apuGraphSink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuGraphSink_NameShouldBeValidCIdentifier(apuGraphSink, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuGraphSink_NameShouldBeUnique(apuGraphSink, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuGraphSink_NameShouldBeValidCIdentifier(ApuGraphSink apuGraphSink, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuGraphSink.getName() == null || apuGraphSink.getName().isEmpty()) {
            return true;
        }
        CIdentifierValidator validator = new CIdentifierValidator();
        IStatus result = validator.validate((Object)apuGraphSink.getName());
        if (!result.equals(Status.OK_STATUS)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{result.getMessage(), ApuGraphValidator.getObjectLabel((EObject)apuGraphSink, context)}, new Object[]{apuGraphSink}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuGraphSink_NameShouldBeUnique(ApuGraphSink apuGraphSink, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuGraphSink.getName() == null || apuGraphSink.getName().isEmpty()) {
            return true;
        }
        BasicEList eList = new BasicEList();
        for (EObject eObject : apuGraphSink.getGraph().getGraphSinks()) {
            if (eObject.equals(apuGraphSink)) continue;
            eList.add((Object)eObject);
        }
        for (EObject eObject : apuGraphSink.getGraph().getGraphSources()) {
            eList.add((Object)eObject);
        }
        String message = NLS.bind((String)"Duplicate Input/Output name \"{0}\" in Graph \"{1}\"", (Object)apuGraphSink.getName(), (Object)apuGraphSink.getGraph().getName());
        UniqueValueValidator validator = new UniqueValueValidator((EObject)apuGraphSink, "name", message);
        IStatus status = validator.validate((Object)eList);
        if (!status.equals(Status.OK_STATUS)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{status.getMessage(), ApuGraphValidator.getObjectLabel((EObject)apuGraphSink, context)}, new Object[]{apuGraphSink}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuKernel(ApuKernel apuKernel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)apuKernel, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)apuKernel, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)apuKernel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)apuKernel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)apuKernel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)apuKernel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)apuKernel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)apuKernel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)apuKernel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuUsage_must_have_definition((ApuUsage)apuKernel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuContent_must_have_container((ApuContent)apuKernel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernel_NameShouldBeValidCIdentifier(apuKernel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernel_NameShouldBeUnique(apuKernel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernel_KernelShouldBeConsistentWithKernelInfo(apuKernel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernel_MaxKernelInputsOutputs(apuKernel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernel_NameShouldntBeEmpty(apuKernel, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuKernel_NameShouldBeValidCIdentifier(ApuKernel apuKernel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuKernel.getName() == null || apuKernel.getName().isEmpty()) {
            return true;
        }
        CIdentifierValidator validator = new CIdentifierValidator();
        IStatus result = validator.validate((Object)apuKernel.getName());
        if (!result.equals(Status.OK_STATUS)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{result.getMessage(), ApuGraphValidator.getObjectLabel((EObject)apuKernel, context)}, new Object[]{apuKernel}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuKernel_NameShouldBeUnique(ApuKernel apuKernel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuKernel.getName() == null || apuKernel.getName().isEmpty()) {
            return true;
        }
        BasicEList eList = new BasicEList();
        for (EObject eObject : apuKernel.getGraph().getKernels()) {
            if (eObject.equals(apuKernel)) continue;
            eList.add((Object)eObject);
        }
        String message = NLS.bind((String)"Duplicate Kernel name \"{0}\" in Graph \"{1}\"", (Object)apuKernel.getName(), (Object)apuKernel.getGraph().getName());
        UniqueValueValidator validator = new UniqueValueValidator((EObject)apuKernel, "name", message);
        IStatus status = validator.validate((Object)eList);
        if (!status.equals(Status.OK_STATUS)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{status.getMessage(), ApuGraphValidator.getObjectLabel((EObject)apuKernel, context)}, new Object[]{apuKernel}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuKernel_KernelShouldBeConsistentWithKernelInfo(ApuKernel apuKernel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = ApuGraphValidationUtil.kernelShouldBeConsistentWithKernelInfo(apuKernel);
        if (!status.isOK()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{status.getMessage(), ApuGraphValidator.getObjectLabel((EObject)apuKernel, context)}, new Object[]{apuKernel}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuKernel_MaxKernelInputsOutputs(ApuKernel apuKernel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        result = apuKernel.getKernelInputs().size() <= 25;
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"There shouldn't be more than 25 inputs", ApuGraphValidator.getObjectLabel((EObject)apuKernel, context)}, new Object[]{apuKernel}, context));
        }
        if (!(result = apuKernel.getKernelOutputs().size() <= 25) && diagnostics != null) {
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"There shouldn't be more than 25 outputs", ApuGraphValidator.getObjectLabel((EObject)apuKernel, context)}, new Object[]{apuKernel}, context));
        }
        return result;
    }

    public boolean validateApuKernel_NameShouldntBeEmpty(ApuKernel apuKernel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String name = apuKernel.getName();
        if (name == null || name.isEmpty()) {
            this.addToDiagnostics("Kernel name shouldn't be empty", (EObject)apuKernel, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuKernelPort(ApuKernelPort apuKernelPort, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)apuKernelPort, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)apuKernelPort, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)apuKernelPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)apuKernelPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)apuKernelPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)apuKernelPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)apuKernelPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)apuKernelPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)apuKernelPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuUsage_must_have_definition((ApuUsage)apuKernelPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuPort_must_have_node((ApuPort)apuKernelPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelPort_NameShouldntBeEmpty(apuKernelPort, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuKernelPort_NameShouldntBeEmpty(ApuKernelPort apuKernelPort, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String name = apuKernelPort.getName();
        if (name == null || name.isEmpty()) {
            this.addToDiagnostics("Kernel port's name shouldn't be empty", (EObject)apuKernelPort, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuKernelInput(ApuKernelInput apuKernelInput, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)apuKernelInput, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)apuKernelInput, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)apuKernelInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)apuKernelInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)apuKernelInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)apuKernelInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)apuKernelInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)apuKernelInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)apuKernelInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuUsage_must_have_definition((ApuUsage)apuKernelInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuPort_must_have_node((ApuPort)apuKernelInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelPort_NameShouldntBeEmpty(apuKernelInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuConsumer_must_have_producer((ApuConsumer)apuKernelInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelInput_must_have_same_data_type(apuKernelInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelInput_InputMemoryPartShouldMatchOutput(apuKernelInput, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuKernelInput_must_have_same_data_type(ApuKernelInput apuKernelInput, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ApuDataType InputDataType;
        ApuDataType OutPutDataType;
        ApuKernelOutput kernelOutput = apuKernelInput.getKernelOutput();
        if (kernelOutput != null && !(OutPutDataType = kernelOutput.getPortInfo().getPortElementsInfo().getE0DataType()).equals((Object)(InputDataType = apuKernelInput.getPortInfo().getPortElementsInfo().getE0DataType()))) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"Kernel Input must have the same datatype with Kernel Output", ApuGraphValidator.getObjectLabel((EObject)apuKernelInput, context)}, new Object[]{apuKernelInput}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuKernelInput_InputMemoryPartShouldMatchOutput(ApuKernelInput apuKernelInput, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = ApuGraphValidationUtil.inputMemoryPartShouldMatchOutput(apuKernelInput);
        if (!status.isOK()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(2, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{status.getMessage(), ApuGraphValidator.getObjectLabel((EObject)apuKernelInput, context)}, new Object[]{apuKernelInput}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuKernelOutput(ApuKernelOutput apuKernelOutput, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)apuKernelOutput, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)apuKernelOutput, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)apuKernelOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)apuKernelOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)apuKernelOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)apuKernelOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)apuKernelOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)apuKernelOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)apuKernelOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuUsage_must_have_definition((ApuUsage)apuKernelOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuPort_must_have_node((ApuPort)apuKernelOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelPort_NameShouldntBeEmpty(apuKernelOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuProducer_must_have_consumer((ApuProducer)apuKernelOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelOutput_must_have_same_data_type(apuKernelOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuKernelOutput_OutputMemoryPartShouldMatchInput(apuKernelOutput, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuKernelOutput_must_have_same_data_type(ApuKernelOutput apuKernelOutput, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<ApuKernelInput> apuKernelInputs = apuKernelOutput.getKernelInputs();
        if (!apuKernelInputs.isEmpty()) {
            ApuDataType OutputDataType = apuKernelOutput.getPortInfo().getPortElementsInfo().getE0DataType();
            for (ApuKernelInput apuKernelInput : apuKernelInputs) {
                ApuDataType InputDataType = apuKernelInput.getPortInfo().getPortElementsInfo().getE0DataType();
                if (OutputDataType.equals((Object)InputDataType)) continue;
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"Kernel Output must have the same datatype with Kernel Input", ApuGraphValidator.getObjectLabel((EObject)apuKernelOutput, context)}, new Object[]{apuKernelOutput}, context));
                }
                return false;
            }
        }
        return true;
    }

    public boolean validateApuKernelOutput_OutputMemoryPartShouldMatchInput(ApuKernelOutput apuKernelOutput, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = ApuGraphValidationUtil.outputMemoryPartShouldMatchInput(apuKernelOutput);
        if (!status.isOK()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(2, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{status.getMessage(), ApuGraphValidator.getObjectLabel((EObject)apuKernelOutput, context)}, new Object[]{apuKernelOutput}, context));
            }
            return false;
        }
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return ApuGraphPlugin.INSTANCE;
    }

    private void addToDiagnostics(String msg, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{msg, ApuGraphValidator.getObjectLabel((EObject)eObject, context)}, new Object[]{eObject}, context));
        }
    }
}

