/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apugraph;

import com.nxp.s32ds.gte.apuflow.ApuUsages;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuGraphFactory;
import com.nxp.s32ds.gte.apugraph.ApuGraphSink;
import com.nxp.s32ds.gte.apugraph.ApuGraphSource;
import com.nxp.s32ds.gte.apugraph.ApuKernel;
import com.nxp.s32ds.gte.apugraph.ApuKernelInput;
import com.nxp.s32ds.gte.apugraph.ApuKernelOutput;
import com.nxp.s32ds.gte.apugraph.ApuKernelPort;
import com.nxp.s32ds.gte.apugraph.validation.internal.ValidationMessages;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortInfo;
import com.nxp.s32ds.gte.apukernel.ApuPortType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ApuKernelsReconcileUtil {
    public static void reconcileOutputs(ApuKernel kernel, EList<ApuKernelPortInfo> ports) {
        ApuKernelsReconcileUtil.reconcileOutputs(kernel, ports, false);
    }

    public static void reconcileInputs(ApuKernel kernel, EList<ApuKernelPortInfo> ports) {
        ApuKernelsReconcileUtil.reconcileInputs(kernel, ports, false);
    }

    public static void reconcileOutputs(ApuKernel kernel, EList<ApuKernelPortInfo> ports, boolean withReplace) {
        EList<ApuKernelOutput> kernelOutputs = kernel.getKernelOutputs();
        Map<ApuKernelPortInfo, ApuKernelOutput> outputs = ApuKernelsReconcileUtil.buildPortMap(kernelOutputs);
        HashMap<ApuKernelOutput, ApuGraphSink> sinksMap = new HashMap<ApuKernelOutput, ApuGraphSink>();
        HashMap<ApuKernelOutput, ApuKernelInput> inputsMap = new HashMap<ApuKernelOutput, ApuKernelInput>();
        for (ApuKernelPortInfo portInfo : ports) {
            ApuPortType portType = portInfo.getPortAttrbutesInfo().getPortType();
            if (!ApuPortType.ATTR_OUT.equals((Object)portType)) continue;
            ApuKernelOutput existing = outputs.remove(portInfo);
            if (existing == null) {
                Optional<ApuKernelPortInfo> opt;
                existing = ApuGraphFactory.eINSTANCE.createApuKernelOutput();
                if (withReplace && (opt = outputs.keySet().stream().filter(p -> p.getIdentifier().equals(portInfo.getIdentifier())).findFirst()).isPresent()) {
                    ApuKernelPortInfo same = opt.get();
                    ApuKernelOutput old = outputs.remove(same);
                    for (ApuGraphSink sink : old.getGraphSinks()) {
                        sinksMap.put(existing, sink);
                    }
                    for (ApuKernelInput input : old.getKernelInputs()) {
                        inputsMap.put(existing, input);
                    }
                    kernelOutputs.remove((Object)old);
                }
            }
            existing.setName(portInfo.getIdentifier());
            existing.setPortInfo(portInfo);
            existing.setKernel(kernel);
        }
        if (withReplace) {
            sinksMap.forEach((k, v) -> v.setKernelOutput((ApuKernelOutput)k));
            inputsMap.forEach((k, v) -> v.setKernelOutput((ApuKernelOutput)k));
        }
        Collection<ApuKernelOutput> remains = outputs.values();
        for (ApuKernelOutput remained : remains) {
            kernelOutputs.remove((Object)remained);
        }
    }

    public static void reconcileInputs(ApuKernel kernel, EList<ApuKernelPortInfo> ports, boolean withReplace) {
        EList<ApuKernelInput> kernelInputs = kernel.getKernelInputs();
        Map<ApuKernelPortInfo, ApuKernelInput> inputs = ApuKernelsReconcileUtil.buildPortMap(kernelInputs);
        HashMap<ApuKernelInput, ApuGraphSource> sourcesMap = new HashMap<ApuKernelInput, ApuGraphSource>();
        HashMap<ApuKernelInput, ApuKernelOutput> outputsMap = new HashMap<ApuKernelInput, ApuKernelOutput>();
        for (ApuKernelPortInfo portInfo : ports) {
            ApuPortType portType = portInfo.getPortAttrbutesInfo().getPortType();
            if (!ApuPortType.ATTR_IN.equals((Object)portType)) continue;
            ApuKernelInput existing = inputs.remove(portInfo);
            if (existing == null) {
                Optional<ApuKernelPortInfo> opt;
                existing = ApuGraphFactory.eINSTANCE.createApuKernelInput();
                if (withReplace && (opt = inputs.keySet().stream().filter(p -> p.getIdentifier().equals(portInfo.getIdentifier())).findFirst()).isPresent()) {
                    ApuKernelPortInfo same = opt.get();
                    ApuKernelInput old = inputs.remove(same);
                    sourcesMap.put(existing, old.getGraphSource());
                    outputsMap.put(existing, old.getKernelOutput());
                    kernelInputs.remove((Object)old);
                }
            }
            existing.setName(portInfo.getIdentifier());
            existing.setPortInfo(portInfo);
            existing.setKernel(kernel);
        }
        if (withReplace) {
            sourcesMap.forEach((k, v) -> k.setGraphSource((ApuGraphSource)v));
            outputsMap.forEach((k, v) -> k.setKernelOutput((ApuKernelOutput)v));
        }
        Collection<ApuKernelInput> remains = inputs.values();
        for (ApuKernelInput remained : remains) {
            kernelInputs.remove((Object)remained);
        }
    }

    public static void reconcilePorts(ApuKernel kernel, EList<ApuKernelPortInfo> ports) {
        ApuKernelsReconcileUtil.reconcilePorts(kernel, ports, false);
    }

    public static void reconcilePorts(ApuKernel kernel, EList<ApuKernelPortInfo> ports, boolean withReplace) {
        ApuKernelsReconcileUtil.reconcileInputs(kernel, ports, withReplace);
        ApuKernelsReconcileUtil.reconcileOutputs(kernel, ports, withReplace);
    }

    public static IStatus handleReconcile(ApuKernel apuKernel) {
        try {
            ApuKernelInfo ki = ApuKernelsReconcileUtil.reloadResource(apuKernel);
            ApuKernelsReconcileUtil.reconcileSingleKernel(apuKernel, ki, false);
            ApuKernelsReconcileUtil.reconcileBrokenKernels(apuKernel, ki);
            return Status.OK_STATUS;
        }
        catch (CoreException ex) {
            EcoreUtil.delete((EObject)apuKernel);
            return ex.getStatus();
        }
    }

    public static IStatus cleanupApuGraph(ApuGraph graph) {
        BasicEList toBeDeleted = new BasicEList();
        for (ApuKernel kernel : graph.getKernels()) {
            if (kernel.getKernelInfo().eResource() != null) continue;
            toBeDeleted.add((Object)kernel);
        }
        for (ApuKernel kernel : toBeDeleted) {
            EcoreUtil.delete((EObject)kernel);
        }
        if (!toBeDeleted.isEmpty()) {
            return new Status(2, "com.nxp.s32ds.gte.apugraph", ValidationMessages.ReconcileKernelAction_warning_kernels_have_been_removed_reason);
        }
        return Status.OK_STATUS;
    }

    public static void updateKernelName(ApuKernel apuKernel, ApuKernelInfo ki) {
        String identifier = ki.getIdentifier();
        String orgKernelName = apuKernel.getName();
        int len = orgKernelName.length();
        if (len < 1) {
            return;
        }
        String lastSymbol = orgKernelName.substring(len - 1, len);
        if (!Character.isDigit(lastSymbol.charAt(0))) {
            return;
        }
        String nameBeforePostfix = orgKernelName.substring(0, len - 1);
        if (nameBeforePostfix.equals(identifier)) {
            return;
        }
        ApuGraph graph = apuKernel.getGraph();
        List list = graph.getKernels().stream().map(ApuKernel::getName).collect(Collectors.toList());
        String pattern = String.valueOf(identifier) + "{0}";
        String newName = ApuUsages.composeNextName(list, (String)pattern);
        apuKernel.setName(newName);
    }

    private static void reconcileSingleKernel(ApuKernel apuKernel, ApuKernelInfo ki, boolean replacePorts) {
        EcoreUtil.replace((EObject)apuKernel.getKernelInfo(), (EObject)ki);
        ApuKernelsReconcileUtil.reconcilePorts(apuKernel, (EList<ApuKernelPortInfo>)ki.getPortInfos(), replacePorts);
        ApuKernelsReconcileUtil.updateKernelName(apuKernel, ki);
        apuKernel.setKernelInfo(ki);
    }

    private static void reconcileBrokenKernels(ApuKernel apuKernel, ApuKernelInfo ki) {
        ApuGraph graph = apuKernel.getGraph();
        for (ApuKernel kernel : graph.getKernels()) {
            if (kernel.getKernelInfo().eResource() != null || !ki.getIdentifier().equals(kernel.getKernelInfo().getIdentifier())) continue;
            ApuKernelsReconcileUtil.reconcileSingleKernel(kernel, ki, true);
        }
    }

    private static ApuKernelInfo reloadResource(ApuKernel apuKernel) throws CoreException {
        ApuKernelInfo suspectKernelInfo = apuKernel.getKernelInfo();
        Resource suspectResource = suspectKernelInfo.eResource();
        try {
            String uriFragment = suspectResource.getURIFragment((EObject)suspectKernelInfo);
            suspectResource.unload();
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ENCODING", StandardCharsets.UTF_8.name());
            suspectResource.load(options);
            EObject obj = suspectResource.getEObject(uriFragment);
            if (!(obj instanceof ApuKernelInfo)) {
                throw new CoreException((IStatus)new Status(4, "com.nxp.s32ds.gte.apugraph", ValidationMessages.ReconcileKernelAction_kernel_info_not_found));
            }
            return (ApuKernelInfo)obj;
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, "com.nxp.s32ds.gte.apugraph", ValidationMessages.ReconcileKernelAction_kernel_info_not_found));
        }
    }

    private static <P extends ApuKernelPort> Map<ApuKernelPortInfo, P> buildPortMap(EList<P> list) {
        LinkedHashMap<ApuKernelPortInfo, ApuKernelPort> result = new LinkedHashMap<ApuKernelPortInfo, ApuKernelPort>();
        for (ApuKernelPort port : list) {
            ApuKernelPortInfo portInfo = port.getPortInfo();
            if (portInfo == null) continue;
            result.put(portInfo, port);
        }
        return result;
    }
}

