/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apugraph;

import com.nxp.s32ds.gte.apugraph.ApuGraphFactory;
import com.nxp.s32ds.gte.apugraph.ApuKernel;
import com.nxp.s32ds.gte.apugraph.ApuKernelInput;
import com.nxp.s32ds.gte.apugraph.ApuKernelOutput;
import com.nxp.s32ds.gte.apugraph.ApuKernelPort;
import com.nxp.s32ds.gte.apugraph.ApuKernelsReconcileUtil;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class ApuKernels {
    static final String KERNEL_NAME = "%s_%s";

    public static ApuKernel createKernel(ApuKernelInfo kernelInfo) {
        String identifier = kernelInfo != null ? kernelInfo.getIdentifier() : "";
        String name = String.format(KERNEL_NAME, identifier, 0);
        return ApuKernels.createKernel(kernelInfo, name);
    }

    public static ApuKernel createKernel(ApuKernelInfo kernelInfo, String name) {
        ApuKernel kernel = ApuGraphFactory.eINSTANCE.createApuKernel();
        if (kernelInfo != null) {
            kernel.setName(name);
            kernel.setKernelInfo(kernelInfo);
            ApuKernelsReconcileUtil.reconcilePorts(kernel, (EList<ApuKernelPortInfo>)kernelInfo.getPortInfos());
        }
        return kernel;
    }

    public static List<ApuKernelPort> getKernelPortInfos(ApuKernel kernel) {
        ArrayList<ApuKernelPort> result = new ArrayList<ApuKernelPort>();
        if (kernel == null) {
            return result;
        }
        if (kernel.getKernelInfo() == null) {
            return result;
        }
        EList kernelPortInfos = kernel.getKernelInfo().getPortInfos();
        EList<ApuKernelInput> kernelInputs = kernel.getKernelInputs();
        EList<ApuKernelOutput> kernelOutputs = kernel.getKernelOutputs();
        HashMap<ApuKernelPortInfo, ApuKernelPort> portInfo2port = new HashMap<ApuKernelPortInfo, ApuKernelPort>();
        for (ApuKernelInput input : kernelInputs) {
            portInfo2port.put(input.getPortInfo(), input);
        }
        for (ApuKernelOutput output : kernelOutputs) {
            portInfo2port.put(output.getPortInfo(), output);
        }
        for (ApuKernelPortInfo portInfo : kernelPortInfos) {
            ApuKernelPort port = (ApuKernelPort)portInfo2port.get(portInfo);
            if (port == null) continue;
            result.add(port);
        }
        return result;
    }

    public static String getKernelName(String name, int idx) {
        return String.format(KERNEL_NAME, name, idx);
    }
}

