/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apugraph;

import com.nxp.s32ds.gte.apugraph.ApuKernel;
import com.nxp.s32ds.gte.apugraph.ApuKernelsReconcileUtil;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortInfo;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;

public class ApuKernelReconciler
extends AdapterImpl {
    public void notifyChanged(Notification msg) {
        int featureID;
        if (msg == null || msg.getNotifier() == null) {
            return;
        }
        Object notifier = msg.getNotifier();
        if (notifier instanceof ApuKernel) {
            ApuKernel kernel = (ApuKernel)notifier;
            featureID = msg.getFeatureID(ApuKernel.class);
            switch (featureID) {
                case 2: {
                    this.graphChanged(kernel, msg);
                    break;
                }
            }
        }
        if (notifier instanceof ApuKernelInfo) {
            ApuKernelInfo graph = (ApuKernelInfo)notifier;
            featureID = msg.getFeatureID(ApuKernelInfo.class);
            switch (featureID) {
                case 3: {
                    this.kernelPortInfosChanged(graph, msg);
                    break;
                }
            }
        }
        super.notifyChanged(msg);
    }

    protected void graphChanged(ApuKernel kernel, Notification msg) {
        Object newValue;
        Object oldValue = msg.getOldValue();
        if (oldValue instanceof ApuKernelInfo) {
            ApuKernelInfo oldKernelInfo = (ApuKernelInfo)oldValue;
            oldKernelInfo.eAdapters().remove((Object)this);
        }
        if ((newValue = msg.getNewValue()) instanceof ApuKernelInfo) {
            ApuKernelInfo newKernelInfo = (ApuKernelInfo)newValue;
            newKernelInfo.eAdapters().add((Object)this);
            ApuKernelsReconcileUtil.reconcilePorts(kernel, (EList<ApuKernelPortInfo>)newKernelInfo.getPortInfos());
        }
    }

    protected void kernelPortInfosChanged(ApuKernelInfo kernelInfo, Notification msg) {
        if (this.target instanceof ApuKernel) {
            ApuKernel kernel = (ApuKernel)this.target;
            EList graphSinks = kernelInfo.getPortInfos();
            ApuKernelsReconcileUtil.reconcilePorts(kernel, (EList<ApuKernelPortInfo>)graphSinks);
        }
    }
}

