/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apugraph;

import com.nxp.s32ds.gte.apuflow.ApuDefinitions;
import com.nxp.s32ds.gte.apuflow.ApuUsages;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuGraphFactory;
import com.nxp.s32ds.gte.apugraph.ApuGraphSink;
import com.nxp.s32ds.gte.apugraph.ApuGraphSource;
import com.nxp.s32ds.gte.apugraph.ApuKernel;
import com.nxp.s32ds.gte.apugraph.ApuKernelInput;
import com.nxp.s32ds.gte.apugraph.ApuKernels;
import com.nxp.s32ds.gte.apukernel.ApuDataType;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public class ApuGraphs {
    private static final String SOURCE_BASE = "Input";
    private static final String SINK_BASE = "Output";

    public static ApuGraph createGraph(String identifier) {
        ApuGraph graph = ApuGraphFactory.eINSTANCE.createApuGraph();
        graph.setName(identifier);
        return graph;
    }

    public static ApuGraphSource createGraphSource(ApuGraph graph) {
        String identifier = ApuGraphs.proposeGraphSourceName(graph);
        return ApuGraphs.createGraphSource(graph, identifier);
    }

    public static ApuGraphSource createGraphSource(ApuGraph graph, String identifier) {
        ApuGraphSource graphSource = ApuGraphFactory.eINSTANCE.createApuGraphSource();
        graphSource.setGraph(graph);
        if (identifier != null) {
            graphSource.setName(identifier);
        }
        return graphSource;
    }

    public static ApuGraphSink createGraphSink(ApuGraph graph) {
        String identifier = ApuGraphs.proposeGraphSinkName(graph);
        return ApuGraphs.createGraphSink(graph, identifier);
    }

    public static ApuGraphSink createGraphSink(ApuGraph graph, String identifier) {
        ApuGraphSink graphSink = ApuGraphFactory.eINSTANCE.createApuGraphSink();
        graphSink.setGraph(graph);
        if (identifier != null) {
            graphSink.setName(identifier);
        }
        return graphSink;
    }

    public static void addKernel(ApuGraph graph, ApuKernelInfo kernelInfo) {
        if (graph == null) {
            throw new IllegalArgumentException("kernelInfo argument is null");
        }
        if (kernelInfo == null) {
            throw new IllegalArgumentException("kernelInfo argument is null");
        }
        String identifier = kernelInfo.getIdentifier();
        List list = graph.getKernels().stream().map(ApuKernel::getName).collect(Collectors.toList());
        String pattern = String.valueOf(identifier) + "{0}";
        String name = ApuUsages.composeNextName(list, (String)pattern);
        ApuKernel kernel = ApuKernels.createKernel(kernelInfo, name);
        kernel.setGraph(graph);
    }

    public static EList<ApuKernelInfo> getKernelInfos(ApuGraph graph) {
        BasicEList list = new BasicEList();
        if (graph == null) {
            return list;
        }
        HashSet<String> keys = new HashSet<String>();
        EList<ApuKernel> apuKernels = graph.getKernels();
        for (ApuKernel apuKernel : apuKernels) {
            String identifier;
            ApuKernelInfo kernelInfo = apuKernel.getKernelInfo();
            if (kernelInfo == null || keys.contains(identifier = kernelInfo.getIdentifier())) continue;
            keys.add(identifier);
            list.add((Object)kernelInfo);
        }
        return list;
    }

    public static ApuKernel getKernel(ApuGraph graph, ApuKernelInfo info) {
        return graph.getKernels().stream().filter(k -> k.getKernelInfo() == info).findAny().orElse(null);
    }

    public static String proposeGraphSourceName(ApuGraph graph) {
        if (graph == null) {
            return ApuDefinitions.proposeName((String)SOURCE_BASE, Collections.emptySet());
        }
        return ApuDefinitions.proposeName((String)SOURCE_BASE, graph.getGraphSources());
    }

    public static String proposeGraphSinkName(ApuGraph graph) {
        if (graph == null) {
            return ApuDefinitions.proposeName((String)SINK_BASE, Collections.emptySet());
        }
        return ApuDefinitions.proposeName((String)SINK_BASE, graph.getGraphSinks());
    }

    public static ApuDataType getApuDataTypeOfSource(ApuGraphSource graphSource) {
        try {
            EList<ApuKernelInput> kernelInputs = graphSource.getKernelInputs();
            if (kernelInputs.isEmpty()) {
                return ApuDataType.D08S;
            }
            return ((ApuKernelInput)kernelInputs.get(0)).getPortInfo().getPortElementsInfo().getE0DataType();
        }
        catch (NullPointerException nullPointerException) {
            return ApuDataType.D08S;
        }
    }

    public static ApuDataType getApuDataTypeOfSink(ApuGraphSink graphSink) {
        try {
            return graphSink.getKernelOutput().getPortInfo().getPortElementsInfo().getE0DataType();
        }
        catch (NullPointerException nullPointerException) {
            return ApuDataType.D08S;
        }
    }

    public static void update(ApuGraph graph) {
        String name = graph.getName();
        graph.setName(name.concat("_temp"));
        graph.setName(name);
    }
}

