/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.apex2.internal.ui;

import com.nxp.s32ds.ext.ide.resources.WorkspaceResources;
import com.nxp.s32ds.ext.rcp.runtime.Log;
import com.nxp.s32ds.mdt.ide.core.MdtIdeCore;
import com.nxp.s32ds.mdt.vpt.apex2.core.launch.Apex2LaunchParams;
import com.nxp.s32ds.mdt.vpt.apex2.core.launch.Apex2LaunchUtil;
import com.nxp.s32ds.mdt.vpt.apex2.core.launch.Apex2SourceType;
import com.nxp.s32ds.mdt.vpt.apex2.internal.ui.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class Apex2MainTab
extends AbstractLaunchConfigurationTab {
    private Apex2SourceType sourceType;
    protected Text sourceField;
    protected Text outputField;
    protected boolean emitKernelFlag = true;
    protected Text kernelDirField;
    protected boolean emitGraphFlag = true;
    protected Text graphDirField;
    protected boolean emitHostFlag = true;
    protected Text hostDirField;
    protected boolean emitTestFlag = true;
    protected Text testDirField;
    protected boolean previousTestButtonSelection = true;
    protected boolean previousHostButtonSelection = true;
    protected Button programRadio;
    protected Button graphRadio;
    protected Button fileOutputButton;
    protected Button variablesOutputButton;
    protected Button emitKernelButton;
    protected Button emitGraphButton;
    protected Button emitHostButton;
    protected Button emitTestButton;
    protected boolean fInitializing = false;
    protected WidgetListener fListener = new WidgetListener();
    private Button workspaceOutputButton;
    private Button workspaceProgramButton;

    protected void handleFileProgramButtonSelected() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(Messages.Apex2MainTab_select_file);
        dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
        dialog.setFilterExtensions(new String[]{"*.apuprogram"});
        String text = dialog.open();
        if (text != null) {
            this.sourceField.setText(text);
        }
    }

    protected void handleFileOutputButtonSelected() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 8192);
        dialog.setText(Messages.Apex2MainTab_select_file);
        dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
        String text = dialog.open();
        if (text != null) {
            this.outputField.setText(text);
        }
    }

    protected void handleFileKernelButtonSelected() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 8192);
        dialog.setText(Messages.Apex2MainTab_select_file);
        dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
        String text = dialog.open();
        if (text != null) {
            this.kernelDirField.setText(text);
        }
    }

    protected void handleFileGraphButtonSelected() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 8192);
        dialog.setText(Messages.Apex2MainTab_select_file);
        dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
        String text = dialog.open();
        if (text != null) {
            this.graphDirField.setText(text);
        }
    }

    protected void handleFileHostButtonSelected() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 8192);
        dialog.setText(Messages.Apex2MainTab_select_file);
        dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
        String text = dialog.open();
        if (text != null) {
            this.hostDirField.setText(text);
        }
    }

    private void handleVariablesButtonSelected(Text textField) {
        String variable = this.getVariable();
        if (variable != null) {
            textField.insert(variable);
        }
    }

    private String getVariable() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        return dialog.getVariableExpression();
    }

    protected void handleEmitKernelButtonSelected() {
        this.emitKernelFlag = this.emitKernelButton.getSelection();
        this.kernelDirField.setEnabled(this.emitKernelFlag);
    }

    protected void handleEmitGraphButtonSelected() {
        this.emitGraphFlag = this.emitGraphButton.getSelection();
        this.graphDirField.setEnabled(this.emitGraphFlag);
    }

    protected void handleEmitHostButtonSelected() {
        this.emitHostFlag = this.emitHostButton.getSelection();
        this.hostDirField.setEnabled(this.emitHostFlag);
    }

    protected void handleEmitTestButtonSelected() {
        this.emitTestFlag = this.emitTestButton.getSelection();
        this.testDirField.setEnabled(this.emitTestFlag);
    }

    protected void handleProgramRadioButtonSelected() {
        if (this.programRadio.getSelection()) {
            this.emitHostButton.setSelection(this.previousHostButtonSelection);
            this.emitHostFlag = this.previousHostButtonSelection;
            this.emitTestButton.setSelection(this.previousTestButtonSelection);
            this.emitTestFlag = this.previousTestButtonSelection;
            this.sourceType = Apex2SourceType.PROGRAM;
            this.enableHostProject(true);
        }
    }

    protected void handleGraphRadioButtonSelected() {
        if (this.graphRadio.getSelection()) {
            this.previousHostButtonSelection = this.emitHostButton.getSelection();
            this.previousTestButtonSelection = this.emitTestButton.getSelection();
            this.sourceType = Apex2SourceType.GRAPH;
            this.enableHostProject(false);
            this.emitHostFlag = false;
            this.emitTestFlag = false;
        }
    }

    protected void handleBrowseWorkspaceFileSelected(Text text) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider());
        dialog.setTitle(NLS.bind((String)Messages.Apex2MainTab_select_0_file, (Object)this.sourceType.getFileType()));
        dialog.setMessage(Messages.Apex2MainTab_select_a_file_to_process);
        dialog.setEmptyListMessage(Messages.Apex2MainTab_there_is_no_file_to_process);
        List collectFiles = Collections.emptyList();
        try {
            collectFiles = WorkspaceResources.collectFiles((String[])new String[]{this.sourceType.getFileType()});
        }
        catch (CoreException e) {
            dialog.setMessage(e.getStatus().getMessage());
            Log.log((IStatus)e.getStatus());
        }
        dialog.setElements(collectFiles.toArray());
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection == null || selection.length == 0 || !(selection[0] instanceof IFile)) {
                    return new Status(4, "com.nxp.s32ds.mdt.vpt.apex2.ui", Messages.Apex2MainTab_select_valid_file);
                }
                return Status.OK_STATUS;
            }
        });
        int buttonId = dialog.open();
        if (buttonId == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            String arg = resource.getFullPath().toString();
            text.setText(arg);
        }
    }

    protected void handleBrowseWorkspaceFolderSelected(Text text) {
        ContainerSelectionDialog containerDialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.Apex2MainTab_select_folder);
        containerDialog.showClosedProjects(false);
        containerDialog.open();
        Object[] resource = containerDialog.getResult();
        String str = null;
        if (resource != null && resource.length > 0) {
            str = MdtIdeCore.toWorkspaceVariabled((String)((IPath)resource[0]).toString());
        }
        if (str != null) {
            text.setText(str);
        }
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        mainComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        this.createSourceTypeComponent(mainComposite);
        this.createProgramComponent(mainComposite);
        this.createOutputComponent(mainComposite);
        this.createKernelComponent(mainComposite);
        this.createGraphComponent(mainComposite);
        this.createHostComponent(mainComposite);
        this.createTestComponent(mainComposite);
        Dialog.applyDialogFont((Control)parent);
    }

    protected void createProgramComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.Apex2MainTab_program);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.sourceField = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.sourceField.setLayoutData((Object)gridData);
        this.sourceField.addModifyListener((ModifyListener)this.fListener);
        this.workspaceProgramButton = this.createBrowseWorkspace((Composite)group);
    }

    protected void createOutputComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.Apex2MainTab_output);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.outputField = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.outputField.setLayoutData((Object)gridData);
        this.outputField.addModifyListener((ModifyListener)this.fListener);
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        gridData = new GridData(128);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.workspaceOutputButton = this.createBrowseWorkspace(buttonComposite);
        this.fileOutputButton = this.createPushButton(buttonComposite, Messages.Apex2MainTab_browse_filesystem, null);
        this.fileOutputButton.addSelectionListener((SelectionListener)this.fListener);
        this.variablesOutputButton = this.createPushButton(buttonComposite, Messages.Apex2MainTab_variables, null);
        this.variablesOutputButton.addSelectionListener((SelectionListener)this.fListener);
    }

    protected void createSourceTypeComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.Apex2MainTab_source_type);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        group.setLayoutData((Object)layoutData);
        this.programRadio = new Button((Composite)group, 16);
        this.programRadio.setText(Messages.Apex2MainTab_source_program);
        this.programRadio.addSelectionListener((SelectionListener)this.fListener);
        this.graphRadio = new Button((Composite)group, 16);
        this.graphRadio.setText(Messages.Apex2MainTab_source_graph);
        GridData graphRadioData = new GridData();
        graphRadioData.horizontalIndent = 5;
        this.graphRadio.setLayoutData((Object)graphRadioData);
        this.graphRadio.addSelectionListener((SelectionListener)this.fListener);
    }

    private void enableHostProject(boolean enable) {
        this.emitHostButton.setEnabled(enable);
        this.emitTestButton.setEnabled(enable);
        this.hostDirField.setEnabled(this.emitHostButton.getSelection());
        this.testDirField.setEnabled(this.emitTestButton.getSelection());
        if (!enable) {
            this.emitHostButton.setSelection(false);
            this.emitTestButton.setSelection(false);
        }
    }

    protected void createKernelComponent(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        group.setLayout((Layout)layout);
        this.emitKernelButton = this.createCheckButton(group, Messages.Apex2MainTab_emit_kernel);
        this.emitKernelButton.addSelectionListener((SelectionListener)this.fListener);
        Composite composite = new Composite(group, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        composite.setLayoutData((Object)gridData);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.kernelDirField = new Text(composite, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.kernelDirField.setLayoutData((Object)gridData);
        this.kernelDirField.addModifyListener((ModifyListener)this.fListener);
    }

    private Button createBrowseWorkspace(Composite composite) {
        Button button = this.createPushButton(composite, Messages.Apex2MainTab_browse_workspace, null);
        button.addSelectionListener((SelectionListener)this.fListener);
        return button;
    }

    protected void createGraphComponent(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        group.setLayout((Layout)layout);
        this.emitGraphButton = this.createCheckButton(group, Messages.Apex2MainTab_emit_graph);
        this.emitGraphButton.addSelectionListener((SelectionListener)this.fListener);
        Composite composite = new Composite(group, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        composite.setLayoutData((Object)gridData);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.graphDirField = new Text(composite, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.graphDirField.setLayoutData((Object)gridData);
        this.graphDirField.addModifyListener((ModifyListener)this.fListener);
    }

    protected void createHostComponent(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        group.setLayout((Layout)layout);
        this.emitHostButton = this.createCheckButton(group, Messages.Apex2MainTab_emit_host);
        this.emitHostButton.addSelectionListener((SelectionListener)this.fListener);
        Composite composite = new Composite(group, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        composite.setLayoutData((Object)gridData);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.hostDirField = new Text(composite, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.hostDirField.setLayoutData((Object)gridData);
        this.hostDirField.addModifyListener((ModifyListener)this.fListener);
    }

    protected void createTestComponent(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        group.setLayout((Layout)layout);
        this.emitTestButton = this.createCheckButton(group, Messages.Apex2MainTab_emit_test);
        this.emitTestButton.addSelectionListener((SelectionListener)this.fListener);
        Composite composite = new Composite(group, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        composite.setLayoutData((Object)gridData);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.testDirField = new Text(composite, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.testDirField.setLayoutData((Object)gridData);
        this.testDirField.addModifyListener((ModifyListener)this.fListener);
    }

    public String getName() {
        return Messages.Apex2MainTab_name;
    }

    public Image getImage() {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        try {
            URL url = new URL("platform:/plugin/com.nxp.s32ds.vgt.ide.ui/icons/full/eview16/emit_src_code16.png");
            desc = ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            Log.log((String)"com.nxp.s32ds.mdt.vpt.apex2.ui", (String)Messages.Apex2MainTab_error_loading_image, (Throwable)e);
        }
        return desc.createImage();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fInitializing = true;
        try {
            Apex2LaunchParams params = Apex2LaunchParams.getParams((ILaunchConfiguration)configuration);
            this.updateSource(params.getSourcePath());
            this.updateOutput(params.getOutputPath());
            this.updateKernelEmitFlag(params.isEmitKernel());
            this.updateKernelDir(params.getKernelDir());
            this.updateGraphEmitFlag(params.isEmitGraph());
            this.updateGraphDir(params.getGraphDir());
            this.updateHostEmitFlag(params.isEmitHost());
            this.updateSourceType(params.getSourceType());
            this.updateHostDir(params.getHostDir());
            this.updateTestEmitFlag(params.isEmitTest());
            this.updateTestDir(params.getTestDir());
        }
        catch (CoreException e) {
            Log.log((IStatus)e.getStatus());
        }
        this.fInitializing = false;
        this.setDirty(false);
    }

    protected void updateSource(String string) {
        this.sourceField.setText(string);
    }

    protected void updateOutput(String string) {
        this.outputField.setText(string);
    }

    protected void updateKernelEmitFlag(boolean b) {
        this.emitKernelFlag = b;
        this.emitKernelButton.setSelection(this.emitKernelFlag);
        this.kernelDirField.setEnabled(this.emitKernelFlag);
    }

    protected void updateKernelDir(String string) {
        this.kernelDirField.setText(string);
    }

    protected void updateGraphEmitFlag(boolean b) {
        this.emitGraphFlag = b;
        this.emitGraphButton.setSelection(this.emitGraphFlag);
        this.graphDirField.setEnabled(this.emitGraphFlag);
    }

    protected void updateGraphDir(String string) {
        this.graphDirField.setText(string);
    }

    protected void updateHostEmitFlag(boolean b) {
        this.emitHostFlag = b;
        this.emitHostButton.setSelection(this.emitHostFlag);
        this.hostDirField.setEnabled(this.emitHostFlag);
    }

    protected void updateTestEmitFlag(boolean b) {
        this.emitTestFlag = b;
        this.emitTestButton.setSelection(this.emitTestFlag);
        this.testDirField.setEnabled(this.emitTestFlag);
    }

    protected void updateHostDir(String string) {
        this.hostDirField.setText(string);
    }

    protected void updateTestDir(String string) {
        this.testDirField.setText(string);
    }

    protected void updateSourceType(Apex2SourceType type) {
        this.sourceType = type;
        switch (this.sourceType) {
            case GRAPH: {
                this.graphRadio.setSelection(true);
                this.programRadio.setSelection(false);
                this.enableHostProject(false);
                break;
            }
            case PROGRAM: {
                this.graphRadio.setSelection(false);
                this.programRadio.setSelection(true);
                this.enableHostProject(true);
                break;
            }
            default: {
                Log.log((IStatus)new Status(4, "com.nxp.s32ds.mdt.vpt.apex2.ui", Messages.Apex2MainTab_unknown_source_type));
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        Apex2LaunchParams params = new Apex2LaunchParams();
        params.setSourcePath(this.sourceField.getText().trim());
        params.setOutputPath(this.outputField.getText().trim());
        params.setEmitKernel(this.emitKernelFlag);
        params.setKernelDir(this.kernelDirField.getText().trim());
        params.setEmitGraph(this.emitGraphFlag);
        params.setGraphDir(this.graphDirField.getText().trim());
        params.setEmitHost(this.emitHostFlag);
        params.setHostDir(this.hostDirField.getText().trim());
        params.setSourceType(this.sourceType);
        params.setEmitTest(this.emitTestFlag);
        params.setTestDir(this.testDirField.getText().trim());
        params.applyParams(configuration);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        Apex2LaunchParams.applyDefaults((ILaunchConfigurationWorkingCopy)configuration);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        return this.validateProgram() && this.validateOutput();
    }

    private boolean validateProgram() {
        try {
            String graph = this.sourceField.getText().trim();
            Apex2LaunchUtil.checkModelFile((String)graph, (Apex2SourceType)this.sourceType);
            return true;
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getStatus().getMessage());
            return false;
        }
    }

    private boolean validateOutput() {
        try {
            String output = this.outputField.getText().trim();
            Apex2LaunchUtil.getOutput((String)output);
            return true;
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getStatus().getMessage());
            return false;
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        private void update() {
            if (!Apex2MainTab.this.fInitializing) {
                Apex2MainTab.this.setDirty(true);
                Apex2MainTab.this.updateLaunchConfigurationDialog();
            }
        }

        public void modifyText(ModifyEvent e) {
            this.update();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            super.widgetDefaultSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            Apex2MainTab.this.setDirty(true);
            Object source = e.getSource();
            if (source == Apex2MainTab.this.workspaceProgramButton) {
                Apex2MainTab.this.handleBrowseWorkspaceFileSelected(Apex2MainTab.this.sourceField);
            } else if (source == Apex2MainTab.this.workspaceOutputButton) {
                Apex2MainTab.this.handleBrowseWorkspaceFolderSelected(Apex2MainTab.this.outputField);
            } else if (source == Apex2MainTab.this.fileOutputButton) {
                Apex2MainTab.this.handleFileOutputButtonSelected();
            } else if (source == Apex2MainTab.this.variablesOutputButton) {
                Apex2MainTab.this.handleVariablesButtonSelected(Apex2MainTab.this.outputField);
            } else if (source == Apex2MainTab.this.emitKernelButton) {
                Apex2MainTab.this.handleEmitKernelButtonSelected();
                this.update();
            } else if (source == Apex2MainTab.this.emitHostButton) {
                Apex2MainTab.this.handleEmitHostButtonSelected();
                this.update();
            } else if (source == Apex2MainTab.this.emitGraphButton) {
                Apex2MainTab.this.handleEmitGraphButtonSelected();
                this.update();
            } else if (source == Apex2MainTab.this.emitTestButton) {
                Apex2MainTab.this.handleEmitTestButtonSelected();
                this.update();
            } else if (source == Apex2MainTab.this.programRadio) {
                Apex2MainTab.this.handleProgramRadioButtonSelected();
                this.update();
            } else if (source == Apex2MainTab.this.graphRadio) {
                Apex2MainTab.this.handleGraphRadioButtonSelected();
                this.update();
            }
        }
    }
}

