/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek.view;

import com.freescale.s32ds.debug.ka.osek.implementation.OrtiImplObject;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObject;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObjectAttribute;
import com.freescale.s32ds.debug.ka.osek.orti.model.OrtiAttributeTraceElement;
import com.freescale.s32ds.debug.ka.osek.orti.model.OrtiImplementation;
import com.freescale.s32ds.debug.ka.osek.orti.model.TraceElementViewNode;
import com.freescale.s32ds.debug.ka.osek.orti.model.TraceModel;
import com.freescale.s32ds.debug.ka.osek.utils.OrtiGlobal;
import com.freescale.s32ds.debug.ka.osek.utils.OrtiImageResources;
import com.freescale.s32ds.debug.ka.osek.view.AbstractOsekView;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class OsekTraceView
extends AbstractOsekView {
    private TreeViewer fAttrTree;
    private TableViewer fTraceView;
    private Spinner fSpinSampleTime;
    private Spinner fSpinSlots;
    private TraceModel fTrace;
    private Menu fTraceViewMenu;
    private Job fSendParamsJob;

    public OsekTraceView(Composite parent, int style, OrtiImplementation ortii) {
        super(parent, style, ortii);
        this.fTrace = ortii.getTrace();
        this.updateColumns();
        this.fTraceView.setInput((Object)this.fTrace);
        this.fAttrTree.setInput((Object)this.fTrace);
        this.updatePanel();
        this.fSendParamsJob = new Job("Send Trace Params"){

            protected IStatus run(IProgressMonitor monitor) {
                if (OsekTraceView.this.fTrace != null) {
                    OsekTraceView.this.fTrace.SendTraceParameters();
                }
                return Status.OK_STATUS;
            }
        };
        this.fSendParamsJob.setSystem(true);
    }

    @Override
    protected Composite createLeftSidePanel() {
        Composite lpanel = new Composite((Composite)this, 0);
        GridLayout grlay = new GridLayout();
        grlay.marginHeight = 1;
        grlay.marginWidth = 1;
        lpanel.setLayout((Layout)grlay);
        lpanel.setBackground(this.getDisplay().getSystemColor(29));
        Label label = new Label(lpanel, 0);
        label.setText("Traceable attributes:");
        GridData grdata = new GridData(4, 2, true, false);
        grdata.verticalIndent = 1;
        label.setLayoutData((Object)grdata);
        label.setBackground(this.getDisplay().getSystemColor(29));
        label = new Label(lpanel, 258);
        label.setBackground(this.getDisplay().getSystemColor(29));
        label.setLayoutData((Object)new GridData(4, 2, true, false));
        this.fAttrTree = new TreeViewer(lpanel, 32);
        this.fAttrTree.setAutoExpandLevel(3);
        this.fAttrTree.setContentProvider((IContentProvider)new TraceTreeContentProvider());
        this.fAttrTree.setLabelProvider((IBaseLabelProvider)new TraceTreeLabelProvider());
        Tree tree = this.fAttrTree.getTree();
        tree.setBackground(this.getDisplay().getSystemColor(29));
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    TreeItem item = (TreeItem)e.item;
                    OsekTraceView.this.handleTreeItemSelection(item);
                }
            }
        });
        return lpanel;
    }

    @Override
    protected Composite createRightSidePanel() {
        Composite rpanel = new Composite((Composite)this, 0);
        GridLayout grlay = new GridLayout();
        grlay.marginHeight = 1;
        grlay.marginWidth = 1;
        grlay.verticalSpacing = 0;
        rpanel.setLayout((Layout)grlay);
        Composite ctrlpan = new Composite(rpanel, 16);
        GridData grdata = new GridData(4, 2, false, false);
        ctrlpan.setBackground(this.getDisplay().getSystemColor(29));
        grdata.verticalIndent = 0;
        grdata.verticalAlignment = 0;
        ctrlpan.setLayoutData((Object)grdata);
        grlay = new GridLayout(7, false);
        grlay.marginHeight = 1;
        ctrlpan.setLayout((Layout)grlay);
        Label label = new Label(ctrlpan, 16384);
        label.setText("Trace buffer slots:");
        label.setBackground(this.getDisplay().getSystemColor(29));
        grdata = new GridData(4, 2, false, false);
        grdata.verticalAlignment = 0;
        grdata.verticalIndent = 0;
        label.setLayoutData((Object)grdata);
        this.fSpinSlots = new Spinner(ctrlpan, 8);
        grdata = new GridData(4, 2, false, false);
        this.fSpinSlots.setLayoutData((Object)grdata);
        this.fSpinSlots.setBackground(this.getDisplay().getSystemColor(29));
        this.fSpinSlots.setToolTipText("Set the trace buffer slots for each attribute.");
        this.fSpinSlots.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OsekTraceView.this.fTrace.setSlots(OsekTraceView.this.fSpinSlots.getSelection());
                OsekTraceView.this.SendTraceParams();
            }
        });
        label = new Label(ctrlpan, 131072);
        label.setText("Sampling time:");
        label.setBackground(this.getDisplay().getSystemColor(29));
        grdata = new GridData();
        grdata.horizontalIndent = 25;
        label.setLayoutData((Object)grdata);
        this.fSpinSampleTime = new Spinner(ctrlpan, 8);
        this.fSpinSampleTime.setBackground(this.getDisplay().getSystemColor(29));
        this.fSpinSampleTime.setToolTipText("Set the sampling time interval that \n the KA plugin will compute the attribute values.");
        this.fSpinSampleTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int time = OsekTraceView.this.fSpinSampleTime.getSelection();
                OsekTraceView.this.fTrace.setSamplingTime(time);
                OsekTraceView.this.SendTraceParams();
            }
        });
        label = new Label(ctrlpan, 16384);
        label.setText(" miliseconds");
        label.setBackground(this.getDisplay().getSystemColor(29));
        this.fTraceView = new TableViewer(rpanel, 66308);
        this.fTraceView.setContentProvider((IContentProvider)new TraceElementTableContentProvider());
        Table table = this.fTraceView.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewerColumn tvc = new TableViewerColumn(this.fTraceView, 131072);
        tvc.getColumn().setText("Attribute");
        tvc.getColumn().pack();
        this.fTraceView.setLabelProvider((IBaseLabelProvider)new TraceElementTableLabelProvider());
        this.addTableMenu(table);
        return rpanel;
    }

    private void handleShowMenu() {
        Object obj;
        MenuItem mitem;
        TableItem[] items = this.fTraceView.getTable().getSelection();
        TableItem item = null;
        OrtiObjectAttribute attr = null;
        OrtiAttributeTraceElement te = null;
        if (items != null && items.length > 0) {
            item = items[0];
            te = (OrtiAttributeTraceElement)item.getData();
        }
        if (te == null) {
            return;
        }
        attr = te.getAttribute();
        if (attr == null) {
            return;
        }
        boolean show = true;
        boolean select = true;
        OrtiImplementation ortii = this.fTrace.GetImpl();
        if (ortii == null) {
            return;
        }
        OrtiImplementation.ImplObjectInfo info = ortii.getImplInfo(te.getImplObject());
        if (info == null) {
            return;
        }
        OrtiGlobal.EnumValueShow eshow = info.GetEnumDisplay().get(attr.implAttribute.name);
        MenuItem[] menuItemArray = this.fTraceViewMenu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            mitem = menuItemArray[n2];
            obj = mitem.getData();
            if (obj instanceof OrtiGlobal.EnumValueShow) {
                show = attr != null && attr.implAttribute.type == 1;
                select = false;
                if (show && te != null) {
                    select = eshow != null && eshow.equals(mitem.getData());
                }
                mitem.setSelection(select);
                mitem.setEnabled(show);
            }
            ++n2;
        }
        if (eshow == null) {
            return;
        }
        show = !eshow.equals((Object)OrtiGlobal.EnumValueShow.LabelOnly) || attr.implAttribute.type == 2;
        menuItemArray = this.fTraceViewMenu.getItems();
        n = menuItemArray.length;
        n2 = 0;
        while (n2 < n) {
            mitem = menuItemArray[n2];
            obj = mitem.getData();
            if (obj instanceof OrtiGlobal.IntBases) {
                OrtiGlobal.IntBases base = (OrtiGlobal.IntBases)((Object)obj);
                select = base.ordinal() == attr.getRepresentBase();
                mitem.setSelection(select);
                mitem.setEnabled(show);
            }
            ++n2;
        }
    }

    private void handleIntFormatMenuItemSelect(int base) {
        TableItem[] items = this.fTraceView.getTable().getSelection();
        TableItem item = null;
        OrtiObjectAttribute attr = null;
        OrtiAttributeTraceElement te = null;
        if (items != null && items.length > 0) {
            item = items[0];
            te = (OrtiAttributeTraceElement)item.getData();
            attr = te.getAttribute();
            attr.setRepresentBase(Integer.valueOf(base).shortValue());
            this.fTraceView.refresh((Object)te);
        }
    }

    private void handleEnumShowMenuItemSelect(OrtiGlobal.EnumValueShow eShow) {
        TableItem[] items = this.fTraceView.getTable().getSelection();
        TableItem item = null;
        OrtiObjectAttribute attr = null;
        OrtiAttributeTraceElement te = null;
        if (items != null && items.length > 0) {
            item = items[0];
            te = (OrtiAttributeTraceElement)item.getData();
            attr = te.getAttribute();
            OrtiImplementation ortii = this.fTrace.GetImpl();
            OrtiImplementation.ImplObjectInfo info = ortii.getImplInfo(te.getImplObject());
            info.GetEnumDisplay().put(attr.implAttribute.name, eShow);
            this.fTraceView.refresh((Object)te);
        }
    }

    private void addTableMenu(Table table) {
        this.fTraceViewMenu = new Menu((Control)table);
        table.setMenu(this.fTraceViewMenu);
        this.fTraceViewMenu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                OsekTraceView.this.handleShowMenu();
            }
        });
        Enum[] enumArray = OrtiGlobal.IntBases.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            OrtiGlobal.IntBases item_base = enumArray[n2];
            MenuItem item = new MenuItem(this.fTraceViewMenu, 16);
            item.setText(item_base.name());
            item.setData((Object)item_base);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem item = (MenuItem)e.widget;
                    OsekTraceView.this.handleIntFormatMenuItemSelect(((OrtiGlobal.IntBases)((Object)item.getData())).getBase());
                }
            });
            ++n2;
        }
        new MenuItem(this.fTraceViewMenu, 2);
        enumArray = OrtiGlobal.EnumValueShow.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum eShow = enumArray[n2];
            final MenuItem mitem = new MenuItem(this.fTraceViewMenu, 16);
            mitem.setText(((OrtiGlobal.EnumValueShow)eShow).label);
            mitem.setData((Object)eShow);
            mitem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OrtiGlobal.EnumValueShow showe = (OrtiGlobal.EnumValueShow)((Object)mitem.getData());
                    OsekTraceView.this.handleEnumShowMenuItemSelect(showe);
                }
            });
            ++n2;
        }
    }

    private void updatePanel() {
        this.fSpinSlots.setValues(this.fTrace.getSlots(), 10, 50, 0, 10, 10);
        this.fSpinSampleTime.setValues(this.fTrace.getSamplingTime(), 50, 500, 0, 50, 100);
    }

    private void updateColumns() {
        if (this.fTrace.isDirty()) {
            return;
        }
        if (this.fTrace.isUpdateNeeded()) {
            this.fTrace.UpdateElementTraceDataAll();
        }
        int slots = this.fTrace.getSlots();
        int columnCount = this.fTraceView.getTable().getColumnCount();
        if (columnCount < slots) {
            int i = 0;
            while (i < slots - (columnCount - 1)) {
                new TableViewerColumn(this.fTraceView, 131072);
                ++i;
            }
            this.fTraceView.setLabelProvider((IBaseLabelProvider)new TraceElementTableLabelProvider());
        }
        columnCount = this.fTraceView.getTable().getColumnCount();
        Table table = this.fTraceView.getTable();
        TableColumn tblcol = table.getColumn(0);
        OrtiAttributeTraceElement.TracedValue[] sampledtimes = this.fTrace.getSampledSlots();
        int filledSlots = sampledtimes.length;
        int i = 1;
        while (i < columnCount) {
            tblcol = table.getColumn(i);
            if (i <= slots) {
                if (i <= filledSlots) {
                    tblcol.setText("+" + sampledtimes[i - 1].value + " ms");
                } else {
                    tblcol.setText("+(?ms)");
                }
                if (tblcol.getWidth() == 0) {
                    tblcol.setWidth(30);
                    tblcol.pack();
                }
            } else {
                tblcol.setWidth(0);
            }
            ++i;
        }
    }

    private void checkPath(TreeItem item, boolean checked, boolean grayed) {
        if (item == null) {
            return;
        }
        if (grayed) {
            checked = true;
        } else {
            int index = 0;
            TreeItem[] items = item.getItems();
            while (index < items.length) {
                TreeItem child = items[index];
                if (child.getGrayed() || checked != child.getChecked()) {
                    grayed = true;
                    checked = true;
                    break;
                }
                ++index;
            }
        }
        item.setChecked(checked);
        item.setGrayed(grayed);
        this.checkPath(item.getParentItem(), checked, grayed);
    }

    private void checkItems(TreeItem item, boolean checked) {
        item.setGrayed(false);
        item.setChecked(checked);
        TreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            this.checkItems(items[i], checked);
            ++i;
        }
    }

    @Override
    protected void doUpdateCurrentView() {
        this.updateColumns();
        this.fTraceView.refresh();
    }

    private void SendTraceParams() {
        if (this.fSendParamsJob != null) {
            this.fSendParamsJob.schedule();
        }
    }

    private void handleTreeItemSelection(TreeItem titem) {
        boolean checked = titem.getChecked();
        TraceElementViewNode node = (TraceElementViewNode)titem.getData();
        this.setTraceElements(node, checked);
        this.fAttrTree.refresh((Object)node);
        this.fTraceView.setInput((Object)this.fTrace);
        this.checkItems(titem, checked);
        this.checkPath(titem.getParentItem(), checked, false);
        this.SendTraceParams();
    }

    private void setTraceElements(TraceElementViewNode node, boolean trace) {
        node.setChecked(trace);
        Object obj = node.getData();
        if (obj instanceof OrtiAttributeTraceElement) {
            this.fTrace.SetTracedAttr((OrtiAttributeTraceElement)obj, trace);
            ((OrtiAttributeTraceElement)obj).setTraced(trace);
        } else {
            Object[] nodes;
            Object[] objectArray = nodes = node.getChilds();
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                Object n3 = objectArray[n2];
                this.setTraceElements((TraceElementViewNode)n3, trace);
                ++n2;
            }
        }
    }

    protected void handleDebugEvent(DebugEvent event) {
        if (event.getKind() == 2) {
            this.updateView();
        } else if (event.getKind() == 1) {
            this.fTrace.setNeedUpdate(true);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    class TraceElementTableContentProvider
    implements IStructuredContentProvider {
        TraceElementTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof TraceModel) {
                Object[] objects = ((TraceModel)inputElement).GetCurrentTracedElements(true);
                return objects;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TraceElementTableLabelProvider
    extends StyledCellLabelProvider {
        TraceElementTableLabelProvider() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void update(ViewerCell cell) {
            OrtiAttributeTraceElement traceElem = (OrtiAttributeTraceElement)cell.getElement();
            int columnIndex = cell.getColumnIndex();
            if (columnIndex == 0) {
                cell.setText(traceElem.getID());
                Image img = OrtiImageResources.GetImage(OrtiImageResources.ImageType.TracedAttr);
                cell.setImage(img);
            } else {
                OrtiObjectAttribute attr = traceElem.getAttribute();
                int slots = OsekTraceView.this.fTrace.getSlots();
                OrtiAttributeTraceElement.TracedValue[] values = traceElem.getLastValues(slots);
                String value = OrtiGlobal.NADigit(attr.getSize());
                int val = 0;
                OrtiAttributeTraceElement.TracedValue[] sampledeslots = OsekTraceView.this.fTrace.getSampledSlots();
                boolean valid = false;
                int index = columnIndex - 1;
                if (values != null && index < values.length && index < sampledeslots.length && sampledeslots[index].epochID == values[index].epochID) {
                    val = values[index].value;
                    OrtiImplementation.ImplObjectInfo info = OsekTraceView.this.fTrace.GetImpl().getImplInfo(traceElem.getImplObject());
                    value = info.GetAttrValueString(attr, val);
                    valid = !values[index].erroneous && value.indexOf("?") < 0;
                }
                cell.setText(value);
                if (values != null && attr.implAttribute.name.equals("SERVICETRACE")) {
                    if (valid) {
                        if (val & true) {
                            cell.setImage(OrtiImageResources.GetImage(OrtiImageResources.ImageType.EnterSection));
                        } else {
                            cell.setImage(OrtiImageResources.GetImage(OrtiImageResources.ImageType.ExitSection));
                        }
                    } else {
                        cell.setImage(null);
                    }
                }
            }
        }
    }

    class TraceTreeContentProvider
    implements ITreeContentProvider {
        TraceTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof TraceElementViewNode) {
                TraceElementViewNode tevn = (TraceElementViewNode)parentElement;
                return tevn.getChilds();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            if (element instanceof TraceElementViewNode) {
                TraceElementViewNode tevn = (TraceElementViewNode)element;
                return tevn.getChilds().length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof TraceModel) {
                Object[] objects = ((TraceModel)inputElement).GetTraceableAttrHierarchy();
                return objects;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object getParent(Object element) {
            return null;
        }
    }

    class TraceTreeLabelProvider
    extends StyledCellLabelProvider {
        TraceTreeLabelProvider() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void update(ViewerCell cell) {
            Object element;
            if (cell.getColumnIndex() == 0 && (element = cell.getElement()) instanceof TraceElementViewNode) {
                TraceElementViewNode tevn = (TraceElementViewNode)element;
                Object obj = tevn.getData();
                Image img = null;
                String text = null;
                if (obj instanceof OrtiImplObject) {
                    img = OrtiImageResources.GetImage(OrtiImageResources.ImageType.OrtiImplObject);
                    text = ((OrtiImplObject)obj).getName();
                } else if (obj instanceof OrtiObject) {
                    img = OrtiImageResources.GetImage(OrtiImageResources.ImageType.OrtiObject);
                    text = ((OrtiObject)obj).getName();
                } else {
                    img = OrtiImageResources.GetImage(OrtiImageResources.ImageType.OrtiAttribute);
                    text = ((OrtiAttributeTraceElement)obj).getAttribute().implAttribute.name;
                }
                cell.setImage(img);
                cell.setText(text);
                Widget widget = cell.getItem();
                if (widget instanceof TreeItem) {
                    boolean checked = tevn.isChecked();
                    TreeItem ti = (TreeItem)widget;
                    OsekTraceView.this.checkItems(ti, checked);
                    OsekTraceView.this.checkPath(ti.getParentItem(), checked, false);
                }
            }
        }
    }
}

