/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek.view;

import com.freescale.s32ds.debug.ka.osek.implementation.OrtiImplObject;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObject;
import com.freescale.s32ds.debug.ka.osek.implementation.TypeObject;
import com.freescale.s32ds.debug.ka.osek.orti.model.OrtiImplementation;
import com.freescale.s32ds.debug.ka.osek.orti.model.OrtiWellKnownTypes;
import com.freescale.s32ds.debug.ka.osek.utils.OrtiGlobal;
import com.freescale.s32ds.debug.ka.osek.utils.OrtiImageResources;
import com.freescale.s32ds.debug.ka.osek.view.AbstractOsekView;
import com.freescale.s32ds.debug.ka.osek.view.TypeObjectTable;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.UIJob;

public class OsekObjectsView
extends AbstractOsekView {
    private FilteredTree m_objectTree;
    private Composite m_objectStackPanel;
    private StackLayout m_objectStackLayout;
    private Map<String, TypeObjectTable> m_typeToViewMap = new TreeMap<String, TypeObjectTable>();

    public OsekObjectsView(Composite parent, int style, OrtiImplementation ortii) {
        super(parent, style, ortii);
        this.populateTree();
    }

    @Override
    protected Composite createLeftSidePanel() {
        PatternFilter patFilter = new PatternFilter();
        patFilter.setIncludeLeadingWildcard(true);
        this.m_objectTree = new FilteredTree((Composite)this, 772, patFilter, true);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.m_sash, 0);
        this.m_objectTree.setLayoutData((Object)data);
        TreeViewer view = this.m_objectTree.getViewer();
        Color searchTreeColor = this.getDisplay().getSystemColor(29);
        this.m_objectTree.setBackground(searchTreeColor);
        this.m_objectTree.getViewer().getTree().setBackground(searchTreeColor);
        Text text = this.m_objectTree.getFilterControl();
        ((GridData)text.getLayoutData()).verticalIndent = 2;
        ((GridData)text.getLayoutData()).horizontalIndent = 10;
        view.getTree().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof TreeItem) {
                    TreeItem item = (TreeItem)e.item;
                    if (item.getParentItem() == null) {
                        OsekObjectsView.this.selectObject(item.getText(), null);
                    } else {
                        OsekObjectsView.this.selectObject(item.getParentItem().getText(), item.getText());
                    }
                }
            }
        });
        view.setContentProvider((IContentProvider)new ObjectTreeContentProvider());
        view.setLabelProvider((IBaseLabelProvider)new ObjectTreeLabelProvider());
        view.setComparator((ViewerComparator)new ObjectTreeComparator());
        view.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                String type;
                if (element instanceof TypeObject && (type = ((TypeObject)element).getType()).equals(OrtiWellKnownTypes.OS.name())) {
                    return true;
                }
                return true;
            }
        });
        return this.m_objectTree;
    }

    @Override
    protected Composite createRightSidePanel() {
        this.m_objectStackPanel = new Composite((Composite)this, 0x800000);
        this.m_objectStackLayout = new StackLayout();
        this.m_objectStackPanel.setLayout((Layout)this.m_objectStackLayout);
        return this.m_objectStackPanel;
    }

    private void populateTree() {
        UIJob job = new UIJob("Populate object tree view"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                OsekObjectsView.this.doPopulateTree();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void selectTreeItem(String itemName) {
        TreeItem[] items;
        Tree tree = this.m_objectTree.getViewer().getTree();
        TreeItem[] treeItemArray = items = tree.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem[] citems;
            TreeItem fitem = treeItemArray[n2];
            if (fitem.getText().equals(itemName)) {
                tree.select(fitem);
                this.selectObject(itemName, null);
            }
            TreeItem[] treeItemArray2 = citems = fitem.getItems();
            int n3 = citems.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem item = treeItemArray2[n4];
                if (item.getText().equals(itemName)) {
                    tree.select(item);
                    this.selectObject(fitem.getText(), itemName);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void selectObject(final String typeName, final String objectName) {
        UIJob job = new UIJob("Select object " + typeName + " : " + objectName){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                OsekObjectsView.this.doSelectObject(typeName, objectName);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    @Override
    protected void doUpdateCurrentView() {
        if (this.m_objectStackLayout.topControl != null && !this.exit && !this.m_resumed) {
            this.exit = false;
            ((TypeObjectTable)this.m_objectStackLayout.topControl).update();
        } else {
            this.doSelectObject(OrtiWellKnownTypes.OS.name(), null);
        }
    }

    protected void doPopulateTree() {
        TypeObject[] osekObjects = this.m_ortii.getObjectTree();
        if (osekObjects != null) {
            this.m_objectTree.getViewer().setAutoExpandLevel(2);
            this.m_objectTree.getViewer().setInput((Object)this.m_ortii);
            Tree tree = this.m_objectTree.getViewer().getTree();
            if (tree.getItemCount() > 0) {
                TreeItem osObjItem = tree.getItem(0);
                if (!osObjItem.isDisposed()) {
                    tree.select(osObjItem);
                }
                this.doSelectObject(OrtiWellKnownTypes.OS.name(), null);
            }
        }
    }

    protected void doSelectObject(String typeName, String objectName) {
        OrtiImplementation.ImplObjectInfo info;
        TypeObjectTable typeView = this.m_typeToViewMap.get(typeName);
        if (typeView != null && !typeView.isColumnSetLoaded()) {
            typeView.setVisible(false);
            typeView.dispose();
            typeView = null;
        }
        if (typeView == null && (info = this.m_ortii.getImplInfo(typeName)) != null) {
            info.UpdateObjectList();
            typeView = new TypeObjectTable(this.m_objectStackPanel, 0, info);
            typeView.addListener(13, new OrtiItemSelectListener());
            this.m_typeToViewMap.put(typeName, typeView);
        }
        if (typeView != null) {
            if (objectName != null) {
                typeView.SelectObject(objectName);
            }
            if (this.m_objectStackLayout.topControl != null && !this.m_objectStackLayout.topControl.isDisposed()) {
                this.m_objectStackLayout.topControl.setVisible(false);
            }
            this.m_objectStackLayout.topControl = typeView;
            typeView.setVisible(true);
            this.m_objectStackPanel.layout(false);
        }
    }

    class ObjectTreeComparator
    extends ViewerComparator {
        ObjectTreeComparator() {
        }

        protected Comparator<Object> getComparator() {
            Comparator<Object> comp = new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 instanceof TypeObject && o2 instanceof TypeObject) {
                        return ((TypeObject)o1).getType().compareTo(((TypeObject)o2).getType());
                    }
                    if (o1 instanceof String && o2 instanceof String) {
                        return ((String)o1).compareTo((String)o2);
                    }
                    return 0;
                }
            };
            return comp;
        }

        public int category(Object element) {
            if (element instanceof TypeObject) {
                String type = ((TypeObject)element).getType();
                if (type.equals(OrtiWellKnownTypes.TASK.name())) {
                    return -1;
                }
                if (type.equals(OrtiWellKnownTypes.OS.name())) {
                    return -2;
                }
            }
            return 0;
        }
    }

    class ObjectTreeContentProvider
    implements ITreeContentProvider {
        ObjectTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            TypeObject typeobj;
            if (parentElement instanceof TypeObject && (typeobj = (TypeObject)parentElement).getInstances() != null) {
                return typeobj.getInstances();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof TypeObject) {
                TypeObject typeobj = (TypeObject)element;
                return typeobj.getInstances().length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            OrtiImplementation impl;
            Object[] objtree;
            if (inputElement instanceof OrtiImplementation && (objtree = (impl = (OrtiImplementation)inputElement).getObjectTree()) != null && objtree != null) {
                return objtree;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ObjectTreeLabelProvider
    implements ILabelProvider {
        ObjectTreeLabelProvider() {
        }

        public Image getImage(Object element) {
            Image img = null;
            if (element instanceof TypeObject) {
                TypeObject tobj = (TypeObject)element;
                img = !tobj.isVendorSpecific() ? OrtiImageResources.GetImage(OrtiImageResources.ImageType.VSOrtiImplObject) : OrtiImageResources.GetImage(OrtiImageResources.ImageType.OrtiImplObject);
            } else if (element instanceof String) {
                img = OrtiImageResources.GetImage(OrtiImageResources.ImageType.OrtiObject);
            }
            return img;
        }

        public String getText(Object element) {
            String elemTxt = OrtiGlobal.NADigit(4);
            if (element instanceof TypeObject) {
                TypeObject typeobj = (TypeObject)element;
                elemTxt = typeobj.getType();
            } else if (element instanceof String) {
                elemTxt = (String)element;
            }
            return elemTxt;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class OrtiItemSelectListener
    implements Listener {
        OrtiItemSelectListener() {
        }

        public void handleEvent(Event event) {
            if (event.detail != 6735) {
                return;
            }
            Object data = event.data;
            if (data instanceof OrtiObject) {
                OrtiObject obj = (OrtiObject)data;
                OsekObjectsView.this.selectObject(obj.getOrtiType(), obj.getName());
            } else if (data instanceof OrtiImplObject) {
                OrtiImplObject iobj = (OrtiImplObject)data;
                OsekObjectsView.this.selectObject(iobj.getName(), null);
            } else if (data instanceof String) {
                OsekObjectsView.this.selectTreeItem((String)data);
            }
        }
    }
}

