/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek.view;

import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObject;
import com.freescale.s32ds.debug.ka.osek.orti.model.OrtiImplementation;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.MatchResult;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.hyperlink.DefaultHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class OrtiItemDetailsView
extends Composite
implements IHyperlinkDetector {
    private Color fInfoColor = Display.getCurrent().getSystemColor(2);
    private Color fHyperLinkColor = Display.getCurrent().getSystemColor(9);
    private Color fUnhoverHyperLinkColor = Display.getCurrent().getSystemColor(9);
    private TextViewer flinksViewPanel;
    private IHyperlinkPresenter fHlinkPresenter;
    private OrtiImplementation.ImplObjectInfo m_info;
    private IHyperlink m_highLightHyperLink;
    private List<IHyperlink> fCrtHyperLinks = new LinkedList<IHyperlink>();

    public OrtiItemDetailsView(Composite parent, int style, OrtiImplementation.ImplObjectInfo info) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        this.m_info = info;
        this.flinksViewPanel = new TextViewer((Composite)this, 770);
        this.flinksViewPanel.setDocument((IDocument)new Document());
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, 1);
        fd.bottom = new FormAttachment(100, 1);
        this.flinksViewPanel.getTextWidget().setLayoutData((Object)fd);
        this.flinksViewPanel.getTextWidget().setBackground(this.getDisplay().getSystemColor(29));
        this.flinksViewPanel.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.flinksViewPanel.setEditable(false);
        this.fHlinkPresenter = this.createHyperLinkDetector();
        this.flinksViewPanel.setHyperlinkPresenter(this.fHlinkPresenter);
        if (this.fHlinkPresenter instanceof IDocumentListener) {
            this.flinksViewPanel.getDocument().addDocumentListener((IDocumentListener)this.fHlinkPresenter);
        }
        this.flinksViewPanel.setHyperlinkDetectors(new IHyperlinkDetector[]{this}, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.layout();
        return this.getSize();
    }

    public void showOrtiObject(OrtiObject object) {
        StringBuilder desc = new StringBuilder();
        if (object == null || this.m_info == null) {
            desc.append("No description available.");
        } else {
            desc.append(this.m_info.GetObjectDescription(object));
        }
        this.setText(desc.toString());
    }

    public void showOrtiObjectAttribute(OrtiObject object, String attributeName) {
        StringBuilder desc = new StringBuilder();
        if (object == null || this.m_info == null) {
            desc.append("No description available.");
        } else {
            desc.append(this.m_info.GetObjectAttrDescription(object.name, attributeName));
            desc.append("\n\n");
            desc.append(this.m_info.GetImplAttrDescription(attributeName));
        }
        this.setText(desc.toString());
    }

    private IHyperlinkPresenter createHyperLinkDetector() {
        DefaultHyperlinkPresenter hlPresenter = new DefaultHyperlinkPresenter(this.fHyperLinkColor){
            private StyleRange fStyleRangeHLink;
            {
                this.fStyleRangeHLink = new StyleRange();
            }

            private void highlightRegion(IHyperlink hlink, boolean highlight) {
                this.fStyleRangeHLink.start = hlink.getHyperlinkRegion().getOffset();
                this.fStyleRangeHLink.length = hlink.getHyperlinkRegion().getLength();
                this.fStyleRangeHLink.underline = highlight;
                this.fStyleRangeHLink.foreground = highlight ? OrtiItemDetailsView.this.fHyperLinkColor : OrtiItemDetailsView.this.fUnhoverHyperLinkColor;
                OrtiItemDetailsView.this.flinksViewPanel.getTextWidget().setStyleRange(this.fStyleRangeHLink);
                OrtiItemDetailsView.this.flinksViewPanel.invalidateTextPresentation(this.fStyleRangeHLink.start, this.fStyleRangeHLink.length);
            }

            public void showHyperlinks(IHyperlink[] hyperlinks) {
                if (hyperlinks == null || hyperlinks.length < 1) {
                    return;
                }
                super.showHyperlinks(hyperlinks);
                if (OrtiItemDetailsView.this.m_highLightHyperLink != null) {
                    this.highlightRegion(OrtiItemDetailsView.this.m_highLightHyperLink, false);
                }
                OrtiItemDetailsView.this.m_highLightHyperLink = hyperlinks[0];
                this.highlightRegion(OrtiItemDetailsView.this.m_highLightHyperLink, true);
            }

            public void hideHyperlinks() {
                super.hideHyperlinks();
                if (OrtiItemDetailsView.this.m_highLightHyperLink != null) {
                    this.highlightRegion(OrtiItemDetailsView.this.m_highLightHyperLink, false);
                    OrtiItemDetailsView.this.m_highLightHyperLink = null;
                }
            }
        };
        return hlPresenter;
    }

    public void setText(String text) {
        this.setText(text, this.fInfoColor);
    }

    public void setText(String text, Color color) {
        if (color != null) {
            this.flinksViewPanel.setTextColor(color);
        } else {
            this.flinksViewPanel.setTextColor(this.fInfoColor);
        }
        this.flinksViewPanel.getDocument().set(text);
        this.fCrtHyperLinks.clear();
        this.hyperLinksParser(text);
    }

    public Widget getTextControl() {
        return this.flinksViewPanel.getTextWidget();
    }

    private boolean isDelimiterChar(char ch) {
        return Character.isSpaceChar(ch) || ch == '\"' || ch == '\'' || ch == ';' || ch == ':';
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        Object data;
        String urlString;
        int begin;
        IRegion lineInfo;
        if (region == null || textViewer == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        int offset = region.getOffset();
        String textLine = "";
        try {
            lineInfo = document.getLineInformationOfOffset(offset);
            textLine = document.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        int end = begin = offset - lineInfo.getOffset();
        while (end < textLine.length() && !this.isDelimiterChar(textLine.charAt(end))) {
            ++end;
        }
        while (begin - 1 >= 0 && !this.isDelimiterChar(textLine.charAt(begin - 1))) {
            --begin;
        }
        for (IHyperlink link : this.fCrtHyperLinks) {
            region = link.getHyperlinkRegion();
            if (region.getOffset() != begin || region.getLength() != end - begin + 1) continue;
            return new IHyperlink[]{link};
        }
        if (end > begin && (urlString = textLine.substring(begin, end)) != null && urlString.length() > 0 && (data = this.m_info.GetObjectForTag(urlString)) != null) {
            OrtiHyperLink hlink = null;
            OrtiRegion lregion = new OrtiRegion(lineInfo.getOffset() + begin, end - begin, data);
            hlink = new OrtiHyperLink(lregion, urlString);
            return new IHyperlink[]{hlink};
        }
        return null;
    }

    private void hyperLinksParser(String text) {
        Scanner scanner = new Scanner(text);
        scanner.useDelimiter("[\\s'\";:]+?");
        while (scanner.hasNext()) {
            String token = scanner.next();
            Object data = this.m_info.GetObjectForTag(token);
            if (data == null) continue;
            MatchResult result = scanner.match();
            this.setHypeLinkStyleRange(result.start(), result.end());
        }
        scanner.close();
    }

    private void setHypeLinkStyleRange(int start, int end) {
        StyleRange range = new StyleRange();
        range.start = start;
        range.length = end - start;
        range.foreground = this.fUnhoverHyperLinkColor;
        this.flinksViewPanel.getTextWidget().setStyleRange(range);
    }

    class OrtiHyperLink
    implements IHyperlink {
        private OrtiRegion fRegion;
        private String fHLinkText;

        private OrtiHyperLink(OrtiRegion reg, String hLinkTxt) {
            this.fRegion = reg;
            this.fHLinkText = hLinkTxt;
        }

        public IRegion getHyperlinkRegion() {
            return this.fRegion;
        }

        public String getHyperlinkText() {
            return this.fHLinkText;
        }

        public String getTypeLabel() {
            return this.fHLinkText;
        }

        public void open() {
            Object data = this.fRegion.getData();
            Event event = new Event();
            event.data = data;
            event.type = 13;
            event.detail = 6735;
            event.widget = OrtiItemDetailsView.this;
            OrtiItemDetailsView.this.notifyListeners(13, event);
        }
    }

    class OrtiRegion
    extends Region {
        private Object fdata;

        public OrtiRegion(int offset, int length, Object data) {
            super(offset, length);
            this.setData(data);
        }

        public void setData(Object fdata) {
            this.fdata = fdata;
        }

        public Object getData() {
            return this.fdata;
        }
    }
}

