/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek.parser;

import com.freescale.s32ds.debug.ka.osek.implementation.OrtiImplAttr;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiImplEnumAttr;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiImplObject;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObject;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObjectAttribute;
import com.freescale.s32ds.debug.ka.osek.parser.AbstractOrtiParser;
import com.freescale.s32ds.debug.ka.osek.parser.ILexemeAnalyzer;
import com.freescale.s32ds.debug.ka.osek.parser.IOrtiParser;
import com.freescale.s32ds.debug.ka.osek.parser.LexemAnalyzer;
import com.freescale.s32ds.debug.ka.osek.parser.OrtiRepository;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;

public class OrtiParser
extends AbstractOrtiParser
implements ILexemeAnalyzer {
    int m_limitObjects;
    LexemAnalyzer lex;
    String curStr;
    int attrCount = 0;
    OrtiRepository m_ortiRepository;
    private HashMap<String, OrtiImplEnumAttr> m_enumWithLinkedObjectList = new HashMap();
    private String m_parseErrors;
    public boolean parsedOK = false;

    public IOrtiParser OP_CreateParser() {
        return new OrtiParser();
    }

    private void syntaxError() {
        this.m_parseErrors = String.valueOf(this.m_parseErrors) + "ORTI parser error: line -" + Integer.toString(this.lex.getLineNumber());
    }

    private void _Clear() {
    }

    private boolean loadFile(String fileName) {
        Path path = Paths.get(fileName, new String[0]);
        try {
            this.lex = new LexemAnalyzer(Files.readAllLines(path, StandardCharsets.UTF_8));
        }
        catch (IOException ex) {
            this.m_parseErrors = String.valueOf(this.m_parseErrors) + "Cannot read file - " + fileName + " Error reason :" + ex.getMessage();
            return false;
        }
        return true;
    }

    private boolean processKOILSection() {
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID, "VERSION") || !this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "{")) {
            return false;
        }
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID, "KOIL") || !this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "=")) {
            return false;
        }
        if (!(this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_String) || this.lex.getStr().equalsIgnoreCase("2.2") && this.lex.getStr().equalsIgnoreCase("2.1"))) {
            return false;
        }
        this.m_ortiRepository.setKOILVersion(this.lex.getStr());
        return this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ";");
    }

    private boolean processSemanticSection() {
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID, "OSSEMANTICS") || !this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "=")) {
            return false;
        }
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_String)) {
            return false;
        }
        this.m_ortiRepository.setSemanticsName(this.lex.getStr());
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ",")) {
            return false;
        }
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_String)) {
            return false;
        }
        this.m_ortiRepository.setSemanticsVersion(this.lex.getStr());
        return true;
    }

    private boolean processEndSection() {
        return this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ";") && this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "}") && this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ";");
    }

    private boolean processVersionSection() {
        if (!this.processKOILSection() || !this.processSemanticSection()) {
            return false;
        }
        return this.processEndSection();
    }

    private boolean processImplSection() {
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID, "IMPLEMENTATION")) {
            return false;
        }
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID)) {
            return false;
        }
        this.m_ortiRepository.setName(this.lex.getStr());
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "{")) {
            return false;
        }
        while (this.processImplObject()) {
        }
        return this.lex.Cmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "}") && this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ";");
    }

    private boolean processImplObject() {
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID)) {
            return false;
        }
        OrtiImplObject implObject = new OrtiImplObject();
        implObject.name = this.lex.getStr();
        if (this.m_ortiRepository.hasImplObject(implObject.name)) {
            return false;
        }
        this.m_ortiRepository.setImplObject(implObject.name, implObject);
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "{")) {
            return false;
        }
        while (this.processImplAttr(implObject)) {
        }
        if (!this.lex.Cmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "}")) {
            return false;
        }
        if (this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ",")) {
            if (this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_String)) {
                implObject.desc = this.lex.getStr();
                this.lex.getNext();
            } else {
                return false;
            }
        }
        return this.lex.Cmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ";");
    }

    /*
     * Unable to fully structure code
     */
    private boolean processImplAttr(OrtiImplObject implObject) {
        block16: {
            block17: {
                toTrace = false;
                noType = false;
                if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID)) {
                    return false;
                }
                if (this.lex.getStr().equalsIgnoreCase("TOTRACE")) {
                    toTrace = true;
                    if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID)) {
                        return false;
                    }
                }
                implAttr = new OrtiImplAttr(implObject, toTrace);
                if (!this.lex.getStr().equalsIgnoreCase("ENUM")) break block17;
                implAttr.type = 1;
                if (this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_String)) {
                    implAttr.ctype = this.lex.getStr();
                    this.lex.getNext();
                } else {
                    implAttr.ctype = "Not defined";
                }
                if (this.lex.Cmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "[")) ** GOTO lbl-1000
                return false;
                while (this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ",")) lbl-1000:
                // 2 sources

                {
                    if (this.processImplAttrEnumValue(implAttr)) continue;
                    break block16;
                }
                break block16;
            }
            if (this.lex.getStr().equalsIgnoreCase("CTYPE")) {
                implAttr.type = 2;
                if (this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_String)) {
                    implAttr.ctype = this.lex.getStr();
                } else {
                    implAttr.ctype = "Not defined";
                    noType = true;
                }
            } else if (this.lex.getStr().equalsIgnoreCase("STRING")) {
                implAttr.type = 3;
            }
        }
        if (!noType && !this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID)) {
            return false;
        }
        implAttr.name = this.lex.getStr();
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol)) {
            return false;
        }
        if (this.lex.Cmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ",")) {
            if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_String)) {
                return false;
            }
            implAttr.description = this.lex.getStr();
            this.lex.getNext();
        }
        if (!this.lex.Cmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ";")) {
            return false;
        }
        implObject.attributesList.put(implAttr.name, implAttr);
        return true;
    }

    private boolean processImplAttrEnumValue(OrtiImplAttr ImplAttr) {
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_String)) {
            return false;
        }
        OrtiImplEnumAttr enumValue = new OrtiImplEnumAttr(ImplAttr);
        ImplAttr.enumList.add(enumValue);
        enumValue.desc = this.lex.getStr();
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol)) {
            return false;
        }
        if (this.lex.Cmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ":")) {
            if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID)) {
                return false;
            }
            enumValue.linkedName = this.lex.getStr();
            this.m_enumWithLinkedObjectList.put(this.lex.getStr(), enumValue);
            this.lex.getNext();
        }
        if (!this.lex.Cmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "=")) {
            return false;
        }
        this.lex.getNext();
        switch (this.lex.m_type) {
            case OP_String: 
            case OP_IntegerConstant: {
                break;
            }
            default: {
                return false;
            }
        }
        enumValue.m_formula = this.lex.getStr();
        return true;
    }

    private boolean processObject() {
        OrtiObject ortiObject;
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID)) {
            return false;
        }
        String impName = this.lex.getStr();
        if (this.m_ortiRepository.hasImplObject(impName)) {
            OrtiImplObject implObject = this.m_ortiRepository.getImplObject(impName);
            if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID)) {
                return false;
            }
            ortiObject = new OrtiObject();
            ortiObject.name = this.lex.getStr();
            if (this.m_ortiRepository.hasObject(ortiObject.name)) {
                return false;
            }
            if (this.m_enumWithLinkedObjectList.containsKey(ortiObject.name)) {
                this.m_enumWithLinkedObjectList.get((Object)ortiObject.name).linkedObject = ortiObject;
                this.m_enumWithLinkedObjectList.remove(ortiObject.name);
            }
            ortiObject.m_implObject = implObject;
            if (implObject.typeObjectList.type == null) {
                implObject.typeObjectList.type = impName;
            }
            implObject.typeObjectList.instances.add(ortiObject.name);
            this.m_ortiRepository.setObject(ortiObject.name, ortiObject);
            if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "{")) {
                return false;
            }
        } else {
            return false;
        }
        while (this.processAttr(ortiObject)) {
        }
        return this.lex.Cmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "}") && this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ";");
    }

    private boolean processAttr(OrtiObject ortiObject) {
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID)) {
            return false;
        }
        String impAttrName = this.lex.getStr();
        if (ortiObject.m_implObject.attributesList.containsKey(impAttrName)) {
            if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "=")) {
                return false;
            }
            if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_String)) {
                return false;
            }
            OrtiObjectAttribute ortiObjAttr = new OrtiObjectAttribute();
            ortiObjAttr.formula = this.lex.getStr();
            ortiObjAttr.attrID = this.attrCount;
            if (ortiObject.m_implObject.attributesList.get((Object)impAttrName).type == 3) {
                ortiObjAttr.isStatic = true;
            }
            if (Character.isDigit(ortiObjAttr.formula.charAt(0))) {
                ortiObjAttr.isStatic = true;
                ortiObjAttr.value = ortiObjAttr.formula.startsWith("0x") ? Integer.parseInt(ortiObjAttr.formula.substring(2), 16) : Integer.parseInt(ortiObjAttr.formula, 10);
            }
            ++this.attrCount;
            this.m_ortiRepository.addAttrList(ortiObjAttr);
            ortiObjAttr.implAttribute = ortiObject.m_implObject.attributesList.get(impAttrName);
            ortiObject.attributes.add(ortiObjAttr);
            return this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ";");
        }
        return false;
    }

    public boolean parseFile(String fName, int limitObjects, OrtiRepository rep) {
        this.m_parseErrors = "Starting.. \n";
        this.m_limitObjects = limitObjects;
        this.m_ortiRepository = rep;
        this._Clear();
        if (!this.loadFile(fName)) {
            return false;
        }
        if (!this.processVersionSection()) {
            this.syntaxError();
            this._Clear();
            return false;
        }
        if (!this.processImplSection()) {
            this.syntaxError();
            this._Clear();
            return false;
        }
        while (this.processObject()) {
        }
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_EOF)) {
            this.syntaxError();
            this._Clear();
            return false;
        }
        this.m_parseErrors = String.valueOf(this.m_parseErrors) + "Parse OK.. \n";
        this.parsedOK = true;
        return true;
    }

    @Override
    public String getErrors() {
        return this.m_parseErrors;
    }

    @Override
    public boolean parseFile(String fName, int limitObjects) {
        return false;
    }
}

