/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek.controller;

import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObject;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObjectAttribute;
import com.freescale.s32ds.debug.ka.osek.orti.model.OrtiImplementation;
import com.freescale.s32ds.debug.ka.osek.utils.OrtiGlobal;
import com.freescale.s32ds.debug.ka.osek.utils.OrtiImageResources;
import com.freescale.s32ds.debug.ka.osek.view.TypeObjectTable;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;

public class TypeObjectTableColumnLabelProvider
extends StyledCellLabelProvider {
    private Color fChangeValueColorBkg = Display.getCurrent().getSystemColor(7);
    private Color fErrValueColorFg = Display.getCurrent().getSystemColor(3);
    private Color fDefaultValueColorFg = Display.getCurrent().getSystemColor(2);
    private Color fDefaultValueColorBkg;
    private Color fDynAttrColorBkg = new Color((Device)Display.getCurrent(), 200, 220, 250);
    private String implAttr;
    private OrtiImplementation.ImplObjectInfo implInfo;

    public TypeObjectTableColumnLabelProvider(TypeObjectTable table, String attr) {
        this.implAttr = attr;
        this.implInfo = table.getImplObject();
        this.fDefaultValueColorBkg = table.getDefaultTableColor();
    }

    public void update(ViewerCell cell) {
        if (cell.getElement() instanceof OrtiObject) {
            OrtiObject obj = (OrtiObject)cell.getElement();
            if (cell.getColumnIndex() == 0) {
                cell.setText(obj.name);
                ((TableItem)cell.getItem()).setChecked(this.implInfo.getUpdateObjects().contains(obj.getName()));
            } else {
                OrtiObjectAttribute attr = null;
                OrtiObjectAttribute[] ortiObjectAttributeArray = obj.getAtributes();
                int n = ortiObjectAttributeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    OrtiObjectAttribute a = ortiObjectAttributeArray[n2];
                    if (this.implAttr.equals(a.implAttribute.name)) {
                        attr = a;
                        break;
                    }
                    ++n2;
                }
                String setValue = "";
                setValue = attr != null ? this.implInfo.GetAttrValueString(attr) : OrtiGlobal.NADigit(4);
                cell.setText(setValue);
                if (attr != null) {
                    if (attr.erroneous) {
                        Image img = OrtiImageResources.GetImage(OrtiImageResources.ImageType.Warning);
                        cell.setImage(img);
                        cell.setForeground(this.fErrValueColorFg);
                    } else {
                        cell.setImage(null);
                        cell.setForeground(this.fDefaultValueColorFg);
                    }
                    if (attr.valueChanged) {
                        cell.setBackground(this.fChangeValueColorBkg);
                    } else if (!attr.isStatic) {
                        cell.setBackground(this.fDynAttrColorBkg);
                    } else {
                        cell.setBackground(this.fDefaultValueColorBkg);
                    }
                } else {
                    cell.setBackground(this.fDefaultValueColorBkg);
                }
            }
        }
    }

    public String getToolTipText(Object element) {
        return null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }
}

