/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek;

import com.freescale.s32ds.debug.ka.osek.OsekAwareAdapter;
import com.freescale.s32ds.debug.ka.osek.OsekConsoleLogger;
import com.freescale.s32ds.debug.ka.osek.orti.model.OrtiImplementationManager;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class OsekPlugin
extends AbstractUIPlugin {
    private static final String PLUGIN_ID = "com.freescale.s32ds.debug.ka.osek";
    public static final String SERVANT_EPOINT = "osekaservants";
    public static final String SERVANT_ELEMENT = "osekaservant";
    public static final String OSPLUGIN_LAUNCH_ATTR = "com.freescale.s32ds.debug.ka.osek.osplugin";
    public Map<IRunControl.IExecutionDMContext, OsekAwareAdapter> fOsekAdapters = new HashMap<IRunControl.IExecutionDMContext, OsekAwareAdapter>();
    public OsekAwareAdapter fAdapter;
    private static OsekPlugin plugin;
    private OsekConsoleLogger m_OsekLogConsole;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if (!this.getBundle().getSymbolicName().equals(PLUGIN_ID)) {
            throw new IllegalStateException("PLUGIN_ID constant is not correct");
        }
        this.InitOsekAdapters();
        this.ConfigureDebugUI();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    protected void InitOsekAdapters() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, SERVANT_EPOINT);
    }

    public static OsekPlugin getDefault() {
        return plugin;
    }

    private void ConfigureDebugUI() {
        DebugUITools.getDebugContextManager().addDebugContextListener(new IDebugContextListener(){

            public void debugContextChanged(DebugContextEvent event) {
                IProcess process = DebugUITools.getCurrentProcess();
                if (process != null && process.isTerminated()) {
                    OrtiImplementationManager.getDefault().RemoveOrtiImpl(process);
                }
            }
        });
    }

    public synchronized OsekConsoleLogger getOsekLogConsole() {
        if (this.m_OsekLogConsole == null) {
            this.m_OsekLogConsole = new OsekConsoleLogger();
        }
        return this.m_OsekLogConsole;
    }

    public void iorAdded(String interfaceName, String ior) {
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static void log(IStatus status) {
        OsekPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        OsekPlugin.log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), e));
    }

    public OsekAwareAdapter getOsekAwareAdapter(IRunControl.IExecutionDMContext context) {
        if (this.fOsekAdapters.containsKey(context)) {
            this.fAdapter = this.fOsekAdapters.get(context);
            return this.fAdapter;
        }
        OsekAwareAdapter adapter = new OsekAwareAdapter(context, "debugger", "servid");
        this.fOsekAdapters.put(context, adapter);
        this.fAdapter = adapter;
        return this.fAdapter;
    }
}

